/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFeatureGroupsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListFeatureGroupsRequest.Builder, ListFeatureGroupsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListFeatureGroupsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> FEATURE_GROUP_STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupStatusEquals").getter(getter(ListFeatureGroupsRequest::featureGroupStatusEqualsAsString))
            .setter(setter(Builder::featureGroupStatusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatusEquals").build())
            .build();

    private static final SdkField<String> OFFLINE_STORE_STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfflineStoreStatusEquals").getter(getter(ListFeatureGroupsRequest::offlineStoreStatusEqualsAsString))
            .setter(setter(Builder::offlineStoreStatusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatusEquals").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListFeatureGroupsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListFeatureGroupsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListFeatureGroupsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListFeatureGroupsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFeatureGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFeatureGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD,
            FEATURE_GROUP_STATUS_EQUALS_FIELD, OFFLINE_STORE_STATUS_EQUALS_FIELD, CREATION_TIME_AFTER_FIELD,
            CREATION_TIME_BEFORE_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NameContains", NAME_CONTAINS_FIELD);
                    put("FeatureGroupStatusEquals", FEATURE_GROUP_STATUS_EQUALS_FIELD);
                    put("OfflineStoreStatusEquals", OFFLINE_STORE_STATUS_EQUALS_FIELD);
                    put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
                    put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String nameContains;

    private final String featureGroupStatusEquals;

    private final String offlineStoreStatusEquals;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final String sortOrder;

    private final String sortBy;

    private final Integer maxResults;

    private final String nextToken;

    private ListFeatureGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.featureGroupStatusEquals = builder.featureGroupStatusEquals;
        this.offlineStoreStatusEquals = builder.offlineStoreStatusEquals;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A string that partially matches one or more <code>FeatureGroup</code>s names. Filters <code>FeatureGroup</code>s
     * by name.
     * </p>
     * 
     * @return A string that partially matches one or more <code>FeatureGroup</code>s names. Filters
     *         <code>FeatureGroup</code>s by name.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatusEquals} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #featureGroupStatusEqualsAsString}.
     * </p>
     * 
     * @return A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
     * @see FeatureGroupStatus
     */
    public final FeatureGroupStatus featureGroupStatusEquals() {
        return FeatureGroupStatus.fromValue(featureGroupStatusEquals);
    }

    /**
     * <p>
     * A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #featureGroupStatusEquals} will return {@link FeatureGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #featureGroupStatusEqualsAsString}.
     * </p>
     * 
     * @return A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
     * @see FeatureGroupStatus
     */
    public final String featureGroupStatusEqualsAsString() {
        return featureGroupStatusEquals;
    }

    /**
     * <p>
     * An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #offlineStoreStatusEquals} will return {@link OfflineStoreStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #offlineStoreStatusEqualsAsString}.
     * </p>
     * 
     * @return An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
     * @see OfflineStoreStatusValue
     */
    public final OfflineStoreStatusValue offlineStoreStatusEquals() {
        return OfflineStoreStatusValue.fromValue(offlineStoreStatusEquals);
    }

    /**
     * <p>
     * An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #offlineStoreStatusEquals} will return {@link OfflineStoreStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #offlineStoreStatusEqualsAsString}.
     * </p>
     * 
     * @return An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
     * @see OfflineStoreStatusValue
     */
    public final String offlineStoreStatusEqualsAsString() {
        return offlineStoreStatusEquals;
    }

    /**
     * <p>
     * Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.
     * </p>
     * 
     * @return Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.
     * </p>
     * 
     * @return Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * The order in which feature groups are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link FeatureGroupSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which feature groups are listed.
     * @see FeatureGroupSortOrder
     */
    public final FeatureGroupSortOrder sortOrder() {
        return FeatureGroupSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which feature groups are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link FeatureGroupSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which feature groups are listed.
     * @see FeatureGroupSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The value on which the feature group list is sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FeatureGroupSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value on which the feature group list is sorted.
     * @see FeatureGroupSortBy
     */
    public final FeatureGroupSortBy sortBy() {
        return FeatureGroupSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value on which the feature group list is sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FeatureGroupSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value on which the feature group list is sorted.
     * @see FeatureGroupSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListFeatureGroups</code>.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListFeatureGroups</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to resume pagination of <code>ListFeatureGroups</code> results.
     * </p>
     * 
     * @return A token to resume pagination of <code>ListFeatureGroups</code> results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offlineStoreStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeatureGroupsRequest)) {
            return false;
        }
        ListFeatureGroupsRequest other = (ListFeatureGroupsRequest) obj;
        return Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(featureGroupStatusEqualsAsString(), other.featureGroupStatusEqualsAsString())
                && Objects.equals(offlineStoreStatusEqualsAsString(), other.offlineStoreStatusEqualsAsString())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFeatureGroupsRequest").add("NameContains", nameContains())
                .add("FeatureGroupStatusEquals", featureGroupStatusEqualsAsString())
                .add("OfflineStoreStatusEquals", offlineStoreStatusEqualsAsString())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "FeatureGroupStatusEquals":
            return Optional.ofNullable(clazz.cast(featureGroupStatusEqualsAsString()));
        case "OfflineStoreStatusEquals":
            return Optional.ofNullable(clazz.cast(offlineStoreStatusEqualsAsString()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFeatureGroupsRequest, T> g) {
        return obj -> g.apply((ListFeatureGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFeatureGroupsRequest> {
        /**
         * <p>
         * A string that partially matches one or more <code>FeatureGroup</code>s names. Filters
         * <code>FeatureGroup</code>s by name.
         * </p>
         * 
         * @param nameContains
         *        A string that partially matches one or more <code>FeatureGroup</code>s names. Filters
         *        <code>FeatureGroup</code>s by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
         * </p>
         * 
         * @param featureGroupStatusEquals
         *        A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatusEquals(String featureGroupStatusEquals);

        /**
         * <p>
         * A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
         * </p>
         * 
         * @param featureGroupStatusEquals
         *        A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status.
         * @see FeatureGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupStatus
         */
        Builder featureGroupStatusEquals(FeatureGroupStatus featureGroupStatusEquals);

        /**
         * <p>
         * An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
         * </p>
         * 
         * @param offlineStoreStatusEquals
         *        An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
         * @see OfflineStoreStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfflineStoreStatusValue
         */
        Builder offlineStoreStatusEquals(String offlineStoreStatusEquals);

        /**
         * <p>
         * An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
         * </p>
         * 
         * @param offlineStoreStatusEquals
         *        An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status.
         * @see OfflineStoreStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfflineStoreStatusValue
         */
        Builder offlineStoreStatusEquals(OfflineStoreStatusValue offlineStoreStatusEquals);

        /**
         * <p>
         * Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * The order in which feature groups are listed.
         * </p>
         * 
         * @param sortOrder
         *        The order in which feature groups are listed.
         * @see FeatureGroupSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which feature groups are listed.
         * </p>
         * 
         * @param sortOrder
         *        The order in which feature groups are listed.
         * @see FeatureGroupSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupSortOrder
         */
        Builder sortOrder(FeatureGroupSortOrder sortOrder);

        /**
         * <p>
         * The value on which the feature group list is sorted.
         * </p>
         * 
         * @param sortBy
         *        The value on which the feature group list is sorted.
         * @see FeatureGroupSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value on which the feature group list is sorted.
         * </p>
         * 
         * @param sortBy
         *        The value on which the feature group list is sorted.
         * @see FeatureGroupSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureGroupSortBy
         */
        Builder sortBy(FeatureGroupSortBy sortBy);

        /**
         * <p>
         * The maximum number of results returned by <code>ListFeatureGroups</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListFeatureGroups</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to resume pagination of <code>ListFeatureGroups</code> results.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of <code>ListFeatureGroups</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nameContains;

        private String featureGroupStatusEquals;

        private String offlineStoreStatusEquals;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private String sortOrder;

        private String sortBy;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeatureGroupsRequest model) {
            super(model);
            nameContains(model.nameContains);
            featureGroupStatusEquals(model.featureGroupStatusEquals);
            offlineStoreStatusEquals(model.offlineStoreStatusEquals);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getFeatureGroupStatusEquals() {
            return featureGroupStatusEquals;
        }

        public final void setFeatureGroupStatusEquals(String featureGroupStatusEquals) {
            this.featureGroupStatusEquals = featureGroupStatusEquals;
        }

        @Override
        public final Builder featureGroupStatusEquals(String featureGroupStatusEquals) {
            this.featureGroupStatusEquals = featureGroupStatusEquals;
            return this;
        }

        @Override
        public final Builder featureGroupStatusEquals(FeatureGroupStatus featureGroupStatusEquals) {
            this.featureGroupStatusEquals(featureGroupStatusEquals == null ? null : featureGroupStatusEquals.toString());
            return this;
        }

        public final String getOfflineStoreStatusEquals() {
            return offlineStoreStatusEquals;
        }

        public final void setOfflineStoreStatusEquals(String offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals = offlineStoreStatusEquals;
        }

        @Override
        public final Builder offlineStoreStatusEquals(String offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals = offlineStoreStatusEquals;
            return this;
        }

        @Override
        public final Builder offlineStoreStatusEquals(OfflineStoreStatusValue offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals(offlineStoreStatusEquals == null ? null : offlineStoreStatusEquals.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(FeatureGroupSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(FeatureGroupSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFeatureGroupsRequest build() {
            return new ListFeatureGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
