/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHubsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListHubsRequest.Builder, ListHubsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListHubsRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListHubsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListHubsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListHubsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListHubsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListHubsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListHubsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListHubsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHubsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD,
            CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD,
            LAST_MODIFIED_TIME_AFTER_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NameContains", NAME_CONTAINS_FIELD);
                    put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
                    put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
                    put("LastModifiedTimeBefore", LAST_MODIFIED_TIME_BEFORE_FIELD);
                    put("LastModifiedTimeAfter", LAST_MODIFIED_TIME_AFTER_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final String sortBy;

    private final String sortOrder;

    private final Integer maxResults;

    private final String nextToken;

    private ListHubsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Only list hubs with names that contain the specified string.
     * </p>
     * 
     * @return Only list hubs with names that contain the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Only list hubs that were created before the time specified.
     * </p>
     * 
     * @return Only list hubs that were created before the time specified.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Only list hubs that were created after the time specified.
     * </p>
     * 
     * @return Only list hubs that were created after the time specified.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Only list hubs that were last modified before the time specified.
     * </p>
     * 
     * @return Only list hubs that were last modified before the time specified.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * Only list hubs that were last modified after the time specified.
     * </p>
     * 
     * @return Only list hubs that were last modified after the time specified.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Sort hubs by either name or creation time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link HubSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort hubs by either name or creation time.
     * @see HubSortBy
     */
    public final HubSortBy sortBy() {
        return HubSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort hubs by either name or creation time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link HubSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort hubs by either name or creation time.
     * @see HubSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Sort hubs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort hubs by ascending or descending order.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sort hubs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort hubs by ascending or descending order.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of hubs to list.
     * </p>
     * 
     * @return The maximum number of hubs to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response to a previous <code>ListHubs</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of hubs, use the token in the next request.
     * </p>
     * 
     * @return If the response to a previous <code>ListHubs</code> request was truncated, the response includes a
     *         <code>NextToken</code>. To retrieve the next set of hubs, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubsRequest)) {
            return false;
        }
        ListHubsRequest other = (ListHubsRequest) obj;
        return Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHubsRequest").add("NameContains", nameContains())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter())
                .add("LastModifiedTimeBefore", lastModifiedTimeBefore()).add("LastModifiedTimeAfter", lastModifiedTimeAfter())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHubsRequest, T> g) {
        return obj -> g.apply((ListHubsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHubsRequest> {
        /**
         * <p>
         * Only list hubs with names that contain the specified string.
         * </p>
         * 
         * @param nameContains
         *        Only list hubs with names that contain the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Only list hubs that were created before the time specified.
         * </p>
         * 
         * @param creationTimeBefore
         *        Only list hubs that were created before the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Only list hubs that were created after the time specified.
         * </p>
         * 
         * @param creationTimeAfter
         *        Only list hubs that were created after the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Only list hubs that were last modified before the time specified.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Only list hubs that were last modified before the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * Only list hubs that were last modified after the time specified.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Only list hubs that were last modified after the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Sort hubs by either name or creation time.
         * </p>
         * 
         * @param sortBy
         *        Sort hubs by either name or creation time.
         * @see HubSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort hubs by either name or creation time.
         * </p>
         * 
         * @param sortBy
         *        Sort hubs by either name or creation time.
         * @see HubSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubSortBy
         */
        Builder sortBy(HubSortBy sortBy);

        /**
         * <p>
         * Sort hubs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort hubs by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sort hubs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort hubs by ascending or descending order.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The maximum number of hubs to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of hubs to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response to a previous <code>ListHubs</code> request was truncated, the response includes a
         * <code>NextToken</code>. To retrieve the next set of hubs, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to a previous <code>ListHubs</code> request was truncated, the response includes a
         *        <code>NextToken</code>. To retrieve the next set of hubs, use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant lastModifiedTimeBefore;

        private Instant lastModifiedTimeAfter;

        private String sortBy;

        private String sortOrder;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubsRequest model) {
            super(model);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(HubSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHubsRequest build() {
            return new ListHubsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
