/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelCardExportJobsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListModelCardExportJobsRequest.Builder, ListModelCardExportJobsRequest> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(ListModelCardExportJobsRequest::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(ListModelCardExportJobsRequest::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListModelCardExportJobsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListModelCardExportJobsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_CONTAINS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelCardExportJobNameContains")
            .getter(getter(ListModelCardExportJobsRequest::modelCardExportJobNameContains))
            .setter(setter(Builder::modelCardExportJobNameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobNameContains")
                    .build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListModelCardExportJobsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListModelCardExportJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListModelCardExportJobsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelCardExportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelCardExportJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD,
            MODEL_CARD_VERSION_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD,
            MODEL_CARD_EXPORT_JOB_NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelCardName", MODEL_CARD_NAME_FIELD);
                    put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
                    put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
                    put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
                    put("ModelCardExportJobNameContains", MODEL_CARD_EXPORT_JOB_NAME_CONTAINS_FIELD);
                    put("StatusEquals", STATUS_EQUALS_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                }
            });

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final String modelCardExportJobNameContains;

    private final String statusEquals;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListModelCardExportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.modelCardExportJobNameContains = builder.modelCardExportJobNameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * List export jobs for the model card with the specified name.
     * </p>
     * 
     * @return List export jobs for the model card with the specified name.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * List export jobs for the model card with the specified version.
     * </p>
     * 
     * @return List export jobs for the model card with the specified version.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * Only list model card export jobs that were created after the time specified.
     * </p>
     * 
     * @return Only list model card export jobs that were created after the time specified.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Only list model card export jobs that were created before the time specified.
     * </p>
     * 
     * @return Only list model card export jobs that were created before the time specified.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Only list model card export jobs with names that contain the specified string.
     * </p>
     * 
     * @return Only list model card export jobs with names that contain the specified string.
     */
    public final String modelCardExportJobNameContains() {
        return modelCardExportJobNameContains;
    }

    /**
     * <p>
     * Only list model card export jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Only list model card export jobs with the specified status.
     * @see ModelCardExportJobStatus
     */
    public final ModelCardExportJobStatus statusEquals() {
        return ModelCardExportJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Only list model card export jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link ModelCardExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Only list model card export jobs with the specified status.
     * @see ModelCardExportJobStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * Sort model card export jobs by either name or creation time. Sorts by creation time by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ModelCardExportJobSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort model card export jobs by either name or creation time. Sorts by creation time by default.
     * @see ModelCardExportJobSortBy
     */
    public final ModelCardExportJobSortBy sortBy() {
        return ModelCardExportJobSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Sort model card export jobs by either name or creation time. Sorts by creation time by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ModelCardExportJobSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sort model card export jobs by either name or creation time. Sorts by creation time by default.
     * @see ModelCardExportJobSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Sort model card export jobs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ModelCardExportJobSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort model card export jobs by ascending or descending order.
     * @see ModelCardExportJobSortOrder
     */
    public final ModelCardExportJobSortOrder sortOrder() {
        return ModelCardExportJobSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Sort model card export jobs by ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link ModelCardExportJobSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Sort model card export jobs by ascending or descending order.
     * @see ModelCardExportJobSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the response to a previous <code>ListModelCardExportJobs</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of model card export jobs, use the token in the next request.
     * </p>
     * 
     * @return If the response to a previous <code>ListModelCardExportJobs</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of model card export jobs, use the token in
     *         the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of model card export jobs to list.
     * </p>
     * 
     * @return The maximum number of model card export jobs to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardExportJobNameContains());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCardExportJobsRequest)) {
            return false;
        }
        ListModelCardExportJobsRequest other = (ListModelCardExportJobsRequest) obj;
        return Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(modelCardExportJobNameContains(), other.modelCardExportJobNameContains())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelCardExportJobsRequest").add("ModelCardName", modelCardName())
                .add("ModelCardVersion", modelCardVersion()).add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore())
                .add("ModelCardExportJobNameContains", modelCardExportJobNameContains())
                .add("StatusEquals", statusEqualsAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "ModelCardExportJobNameContains":
            return Optional.ofNullable(clazz.cast(modelCardExportJobNameContains()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCardExportJobsRequest, T> g) {
        return obj -> g.apply((ListModelCardExportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelCardExportJobsRequest> {
        /**
         * <p>
         * List export jobs for the model card with the specified name.
         * </p>
         * 
         * @param modelCardName
         *        List export jobs for the model card with the specified name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * List export jobs for the model card with the specified version.
         * </p>
         * 
         * @param modelCardVersion
         *        List export jobs for the model card with the specified version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * Only list model card export jobs that were created after the time specified.
         * </p>
         * 
         * @param creationTimeAfter
         *        Only list model card export jobs that were created after the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Only list model card export jobs that were created before the time specified.
         * </p>
         * 
         * @param creationTimeBefore
         *        Only list model card export jobs that were created before the time specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Only list model card export jobs with names that contain the specified string.
         * </p>
         * 
         * @param modelCardExportJobNameContains
         *        Only list model card export jobs with names that contain the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardExportJobNameContains(String modelCardExportJobNameContains);

        /**
         * <p>
         * Only list model card export jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Only list model card export jobs with the specified status.
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Only list model card export jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Only list model card export jobs with the specified status.
         * @see ModelCardExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobStatus
         */
        Builder statusEquals(ModelCardExportJobStatus statusEquals);

        /**
         * <p>
         * Sort model card export jobs by either name or creation time. Sorts by creation time by default.
         * </p>
         * 
         * @param sortBy
         *        Sort model card export jobs by either name or creation time. Sorts by creation time by default.
         * @see ModelCardExportJobSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sort model card export jobs by either name or creation time. Sorts by creation time by default.
         * </p>
         * 
         * @param sortBy
         *        Sort model card export jobs by either name or creation time. Sorts by creation time by default.
         * @see ModelCardExportJobSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobSortBy
         */
        Builder sortBy(ModelCardExportJobSortBy sortBy);

        /**
         * <p>
         * Sort model card export jobs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort model card export jobs by ascending or descending order.
         * @see ModelCardExportJobSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Sort model card export jobs by ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Sort model card export jobs by ascending or descending order.
         * @see ModelCardExportJobSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardExportJobSortOrder
         */
        Builder sortOrder(ModelCardExportJobSortOrder sortOrder);

        /**
         * <p>
         * If the response to a previous <code>ListModelCardExportJobs</code> request was truncated, the response
         * includes a <code>NextToken</code>. To retrieve the next set of model card export jobs, use the token in the
         * next request.
         * </p>
         * 
         * @param nextToken
         *        If the response to a previous <code>ListModelCardExportJobs</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of model card export jobs, use the token
         *        in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of model card export jobs to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of model card export jobs to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelCardName;

        private Integer modelCardVersion;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private String modelCardExportJobNameContains;

        private String statusEquals;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCardExportJobsRequest model) {
            super(model);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            modelCardExportJobNameContains(model.modelCardExportJobNameContains);
            statusEquals(model.statusEquals);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getModelCardExportJobNameContains() {
            return modelCardExportJobNameContains;
        }

        public final void setModelCardExportJobNameContains(String modelCardExportJobNameContains) {
            this.modelCardExportJobNameContains = modelCardExportJobNameContains;
        }

        @Override
        public final Builder modelCardExportJobNameContains(String modelCardExportJobNameContains) {
            this.modelCardExportJobNameContains = modelCardExportJobNameContains;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(ModelCardExportJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ModelCardExportJobSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(ModelCardExportJobSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelCardExportJobsRequest build() {
            return new ListModelCardExportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
