/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookInstanceLifecycleConfigsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListNotebookInstanceLifecycleConfigsResponse.Builder, ListNotebookInstanceLifecycleConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNotebookInstanceLifecycleConfigsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleConfigSummary>> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_FIELD = SdkField
            .<List<NotebookInstanceLifecycleConfigSummary>> builder(MarshallingType.LIST)
            .memberName("NotebookInstanceLifecycleConfigs")
            .getter(getter(ListNotebookInstanceLifecycleConfigsResponse::notebookInstanceLifecycleConfigs))
            .setter(setter(Builder::notebookInstanceLifecycleConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("NotebookInstanceLifecycleConfigs", NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_FIELD);
                }
            });

    private final String nextToken;

    private final List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs;

    private ListNotebookInstanceLifecycleConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstanceLifecycleConfigs = builder.notebookInstanceLifecycleConfigs;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To get the next set of lifecycle configurations, use
     * it in the next request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To get the next set of lifecycle
     *         configurations, use it in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotebookInstanceLifecycleConfigs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasNotebookInstanceLifecycleConfigs() {
        return notebookInstanceLifecycleConfigs != null && !(notebookInstanceLifecycleConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotebookInstanceLifecycleConfigs}
     * method.
     * </p>
     * 
     * @return An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
     *         configuration.
     */
    public final List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs() {
        return notebookInstanceLifecycleConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasNotebookInstanceLifecycleConfigs() ? notebookInstanceLifecycleConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstanceLifecycleConfigsResponse)) {
            return false;
        }
        ListNotebookInstanceLifecycleConfigsResponse other = (ListNotebookInstanceLifecycleConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasNotebookInstanceLifecycleConfigs() == other.hasNotebookInstanceLifecycleConfigs()
                && Objects.equals(notebookInstanceLifecycleConfigs(), other.notebookInstanceLifecycleConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListNotebookInstanceLifecycleConfigsResponse")
                .add("NextToken", nextToken())
                .add("NotebookInstanceLifecycleConfigs",
                        hasNotebookInstanceLifecycleConfigs() ? notebookInstanceLifecycleConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NotebookInstanceLifecycleConfigs":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstanceLifecycleConfigsResponse, T> g) {
        return obj -> g.apply((ListNotebookInstanceLifecycleConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotebookInstanceLifecycleConfigsResponse> {
        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To get the next set of lifecycle configurations,
         * use it in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To get the next set of lifecycle
         *        configurations, use it in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigs
         *        An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigs
         *        An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigs(NotebookInstanceLifecycleConfigSummary... notebookInstanceLifecycleConfigs);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #notebookInstanceLifecycleConfigs(List<NotebookInstanceLifecycleConfigSummary>)}.
         * 
         * @param notebookInstanceLifecycleConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookInstanceLifecycleConfigs(java.util.Collection<NotebookInstanceLifecycleConfigSummary>)
         */
        Builder notebookInstanceLifecycleConfigs(
                Consumer<NotebookInstanceLifecycleConfigSummary.Builder>... notebookInstanceLifecycleConfigs);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstanceLifecycleConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            notebookInstanceLifecycleConfigs(model.notebookInstanceLifecycleConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotebookInstanceLifecycleConfigSummary.Builder> getNotebookInstanceLifecycleConfigs() {
            List<NotebookInstanceLifecycleConfigSummary.Builder> result = NotebookInstanceLifecycleConfigSummaryListCopier
                    .copyToBuilder(this.notebookInstanceLifecycleConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary.BuilderImpl> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier
                    .copyFromBuilder(notebookInstanceLifecycleConfigs);
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier
                    .copy(notebookInstanceLifecycleConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(
                NotebookInstanceLifecycleConfigSummary... notebookInstanceLifecycleConfigs) {
            notebookInstanceLifecycleConfigs(Arrays.asList(notebookInstanceLifecycleConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(
                Consumer<NotebookInstanceLifecycleConfigSummary.Builder>... notebookInstanceLifecycleConfigs) {
            notebookInstanceLifecycleConfigs(Stream.of(notebookInstanceLifecycleConfigs)
                    .map(c -> NotebookInstanceLifecycleConfigSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotebookInstanceLifecycleConfigsResponse build() {
            return new ListNotebookInstanceLifecycleConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
