/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOptimizationJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListOptimizationJobsResponse.Builder, ListOptimizationJobsResponse> {
    private static final SdkField<List<OptimizationJobSummary>> OPTIMIZATION_JOB_SUMMARIES_FIELD = SdkField
            .<List<OptimizationJobSummary>> builder(MarshallingType.LIST)
            .memberName("OptimizationJobSummaries")
            .getter(getter(ListOptimizationJobsResponse::optimizationJobSummaries))
            .setter(setter(Builder::optimizationJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptimizationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptimizationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOptimizationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OPTIMIZATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OptimizationJobSummaries", OPTIMIZATION_JOB_SUMMARIES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<OptimizationJobSummary> optimizationJobSummaries;

    private final String nextToken;

    private ListOptimizationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.optimizationJobSummaries = builder.optimizationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptimizationJobSummaries() {
        return optimizationJobSummaries != null && !(optimizationJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationJobSummaries} method.
     * </p>
     * 
     * @return A list of optimization jobs and their properties that matches any of the filters you specified in the
     *         request.
     */
    public final List<OptimizationJobSummary> optimizationJobSummaries() {
        return optimizationJobSummaries;
    }

    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results following a truncated response.
     * </p>
     * 
     * @return The token to use in a subsequent request to get the next set of results following a truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationJobSummaries() ? optimizationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOptimizationJobsResponse)) {
            return false;
        }
        ListOptimizationJobsResponse other = (ListOptimizationJobsResponse) obj;
        return hasOptimizationJobSummaries() == other.hasOptimizationJobSummaries()
                && Objects.equals(optimizationJobSummaries(), other.optimizationJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOptimizationJobsResponse")
                .add("OptimizationJobSummaries", hasOptimizationJobSummaries() ? optimizationJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizationJobSummaries":
            return Optional.ofNullable(clazz.cast(optimizationJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOptimizationJobsResponse, T> g) {
        return obj -> g.apply((ListOptimizationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOptimizationJobsResponse> {
        /**
         * <p>
         * A list of optimization jobs and their properties that matches any of the filters you specified in the
         * request.
         * </p>
         * 
         * @param optimizationJobSummaries
         *        A list of optimization jobs and their properties that matches any of the filters you specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobSummaries(Collection<OptimizationJobSummary> optimizationJobSummaries);

        /**
         * <p>
         * A list of optimization jobs and their properties that matches any of the filters you specified in the
         * request.
         * </p>
         * 
         * @param optimizationJobSummaries
         *        A list of optimization jobs and their properties that matches any of the filters you specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobSummaries(OptimizationJobSummary... optimizationJobSummaries);

        /**
         * <p>
         * A list of optimization jobs and their properties that matches any of the filters you specified in the
         * request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #optimizationJobSummaries(List<OptimizationJobSummary>)}.
         * 
         * @param optimizationJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizationJobSummaries(java.util.Collection<OptimizationJobSummary>)
         */
        Builder optimizationJobSummaries(Consumer<OptimizationJobSummary.Builder>... optimizationJobSummaries);

        /**
         * <p>
         * The token to use in a subsequent request to get the next set of results following a truncated response.
         * </p>
         * 
         * @param nextToken
         *        The token to use in a subsequent request to get the next set of results following a truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<OptimizationJobSummary> optimizationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOptimizationJobsResponse model) {
            super(model);
            optimizationJobSummaries(model.optimizationJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<OptimizationJobSummary.Builder> getOptimizationJobSummaries() {
            List<OptimizationJobSummary.Builder> result = OptimizationJobSummariesCopier
                    .copyToBuilder(this.optimizationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizationJobSummaries(Collection<OptimizationJobSummary.BuilderImpl> optimizationJobSummaries) {
            this.optimizationJobSummaries = OptimizationJobSummariesCopier.copyFromBuilder(optimizationJobSummaries);
        }

        @Override
        public final Builder optimizationJobSummaries(Collection<OptimizationJobSummary> optimizationJobSummaries) {
            this.optimizationJobSummaries = OptimizationJobSummariesCopier.copy(optimizationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationJobSummaries(OptimizationJobSummary... optimizationJobSummaries) {
            optimizationJobSummaries(Arrays.asList(optimizationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationJobSummaries(Consumer<OptimizationJobSummary.Builder>... optimizationJobSummaries) {
            optimizationJobSummaries(Stream.of(optimizationJobSummaries)
                    .map(c -> OptimizationJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOptimizationJobsResponse build() {
            return new ListOptimizationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
