/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainingPlansRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListTrainingPlansRequest.Builder, ListTrainingPlansRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrainingPlansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTrainingPlansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> START_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimeAfter").getter(getter(ListTrainingPlansRequest::startTimeAfter))
            .setter(setter(Builder::startTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeAfter").build()).build();

    private static final SdkField<Instant> START_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimeBefore").getter(getter(ListTrainingPlansRequest::startTimeBefore))
            .setter(setter(Builder::startTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeBefore").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListTrainingPlansRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListTrainingPlansRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<List<TrainingPlanFilter>> FILTERS_FIELD = SdkField
            .<List<TrainingPlanFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListTrainingPlansRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainingPlanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainingPlanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, START_TIME_AFTER_FIELD, START_TIME_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("StartTimeAfter", START_TIME_AFTER_FIELD);
                    put("StartTimeBefore", START_TIME_BEFORE_FIELD);
                    put("SortBy", SORT_BY_FIELD);
                    put("SortOrder", SORT_ORDER_FIELD);
                    put("Filters", FILTERS_FIELD);
                }
            });

    private final String nextToken;

    private final Integer maxResults;

    private final Instant startTimeAfter;

    private final Instant startTimeBefore;

    private final String sortBy;

    private final String sortOrder;

    private final List<TrainingPlanFilter> filters;

    private ListTrainingPlansRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTimeAfter = builder.startTimeAfter;
        this.startTimeBefore = builder.startTimeBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * A token to continue pagination if more results are available.
     * </p>
     * 
     * @return A token to continue pagination if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter to list only training plans with an actual start time after this date.
     * </p>
     * 
     * @return Filter to list only training plans with an actual start time after this date.
     */
    public final Instant startTimeAfter() {
        return startTimeAfter;
    }

    /**
     * <p>
     * Filter to list only training plans with an actual start time before this date.
     * </p>
     * 
     * @return Filter to list only training plans with an actual start time before this date.
     */
    public final Instant startTimeBefore() {
        return startTimeBefore;
    }

    /**
     * <p>
     * The training plan field to sort the results by (e.g., StartTime, Status).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TrainingPlanSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The training plan field to sort the results by (e.g., StartTime, Status).
     * @see TrainingPlanSortBy
     */
    public final TrainingPlanSortBy sortBy() {
        return TrainingPlanSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The training plan field to sort the results by (e.g., StartTime, Status).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link TrainingPlanSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The training plan field to sort the results by (e.g., StartTime, Status).
     * @see TrainingPlanSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to sort the results (Ascending or Descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link TrainingPlanSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort the results (Ascending or Descending).
     * @see TrainingPlanSortOrder
     */
    public final TrainingPlanSortOrder sortOrder() {
        return TrainingPlanSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort the results (Ascending or Descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link TrainingPlanSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort the results (Ascending or Descending).
     * @see TrainingPlanSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional filters to apply to the list of training plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Additional filters to apply to the list of training plans.
     */
    public final List<TrainingPlanFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingPlansRequest)) {
            return false;
        }
        ListTrainingPlansRequest other = (ListTrainingPlansRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(startTimeAfter(), other.startTimeAfter())
                && Objects.equals(startTimeBefore(), other.startTimeBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrainingPlansRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("StartTimeAfter", startTimeAfter()).add("StartTimeBefore", startTimeBefore())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StartTimeAfter":
            return Optional.ofNullable(clazz.cast(startTimeAfter()));
        case "StartTimeBefore":
            return Optional.ofNullable(clazz.cast(startTimeBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingPlansRequest, T> g) {
        return obj -> g.apply((ListTrainingPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTrainingPlansRequest> {
        /**
         * <p>
         * A token to continue pagination if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A token to continue pagination if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter to list only training plans with an actual start time after this date.
         * </p>
         * 
         * @param startTimeAfter
         *        Filter to list only training plans with an actual start time after this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeAfter(Instant startTimeAfter);

        /**
         * <p>
         * Filter to list only training plans with an actual start time before this date.
         * </p>
         * 
         * @param startTimeBefore
         *        Filter to list only training plans with an actual start time before this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeBefore(Instant startTimeBefore);

        /**
         * <p>
         * The training plan field to sort the results by (e.g., StartTime, Status).
         * </p>
         * 
         * @param sortBy
         *        The training plan field to sort the results by (e.g., StartTime, Status).
         * @see TrainingPlanSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The training plan field to sort the results by (e.g., StartTime, Status).
         * </p>
         * 
         * @param sortBy
         *        The training plan field to sort the results by (e.g., StartTime, Status).
         * @see TrainingPlanSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanSortBy
         */
        Builder sortBy(TrainingPlanSortBy sortBy);

        /**
         * <p>
         * The order to sort the results (Ascending or Descending).
         * </p>
         * 
         * @param sortOrder
         *        The order to sort the results (Ascending or Descending).
         * @see TrainingPlanSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort the results (Ascending or Descending).
         * </p>
         * 
         * @param sortOrder
         *        The order to sort the results (Ascending or Descending).
         * @see TrainingPlanSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingPlanSortOrder
         */
        Builder sortOrder(TrainingPlanSortOrder sortOrder);

        /**
         * <p>
         * Additional filters to apply to the list of training plans.
         * </p>
         * 
         * @param filters
         *        Additional filters to apply to the list of training plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<TrainingPlanFilter> filters);

        /**
         * <p>
         * Additional filters to apply to the list of training plans.
         * </p>
         * 
         * @param filters
         *        Additional filters to apply to the list of training plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(TrainingPlanFilter... filters);

        /**
         * <p>
         * Additional filters to apply to the list of training plans.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<TrainingPlanFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<TrainingPlanFilter>)
         */
        Builder filters(Consumer<TrainingPlanFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Instant startTimeAfter;

        private Instant startTimeBefore;

        private String sortBy;

        private String sortOrder;

        private List<TrainingPlanFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingPlansRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startTimeAfter(model.startTimeAfter);
            startTimeBefore(model.startTimeBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStartTimeAfter() {
            return startTimeAfter;
        }

        public final void setStartTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
        }

        @Override
        public final Builder startTimeAfter(Instant startTimeAfter) {
            this.startTimeAfter = startTimeAfter;
            return this;
        }

        public final Instant getStartTimeBefore() {
            return startTimeBefore;
        }

        public final void setStartTimeBefore(Instant startTimeBefore) {
            this.startTimeBefore = startTimeBefore;
        }

        @Override
        public final Builder startTimeBefore(Instant startTimeBefore) {
            this.startTimeBefore = startTimeBefore;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(TrainingPlanSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(TrainingPlanSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final List<TrainingPlanFilter.Builder> getFilters() {
            List<TrainingPlanFilter.Builder> result = TrainingPlanFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TrainingPlanFilter.BuilderImpl> filters) {
            this.filters = TrainingPlanFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TrainingPlanFilter> filters) {
            this.filters = TrainingPlanFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TrainingPlanFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TrainingPlanFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> TrainingPlanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrainingPlansRequest build() {
            return new ListTrainingPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
