/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkteamsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListWorkteamsResponse.Builder, ListWorkteamsResponse> {
    private static final SdkField<List<Workteam>> WORKTEAMS_FIELD = SdkField
            .<List<Workteam>> builder(MarshallingType.LIST)
            .memberName("Workteams")
            .getter(getter(ListWorkteamsResponse::workteams))
            .setter(setter(Builder::workteams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workteams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workteam> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workteam::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkteamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAMS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Workteams", WORKTEAMS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<Workteam> workteams;

    private final String nextToken;

    private ListWorkteamsResponse(BuilderImpl builder) {
        super(builder);
        this.workteams = builder.workteams;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workteams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkteams() {
        return workteams != null && !(workteams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Workteam</code> objects, each describing a work team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkteams} method.
     * </p>
     * 
     * @return An array of <code>Workteam</code> objects, each describing a work team.
     */
    public final List<Workteam> workteams() {
        return workteams;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it
     * in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work
     *         teams, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkteams() ? workteams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkteamsResponse)) {
            return false;
        }
        ListWorkteamsResponse other = (ListWorkteamsResponse) obj;
        return hasWorkteams() == other.hasWorkteams() && Objects.equals(workteams(), other.workteams())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkteamsResponse").add("Workteams", hasWorkteams() ? workteams() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workteams":
            return Optional.ofNullable(clazz.cast(workteams()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkteamsResponse, T> g) {
        return obj -> g.apply((ListWorkteamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkteamsResponse> {
        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * 
         * @param workteams
         *        An array of <code>Workteam</code> objects, each describing a work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteams(Collection<Workteam> workteams);

        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * 
         * @param workteams
         *        An array of <code>Workteam</code> objects, each describing a work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteams(Workteam... workteams);

        /**
         * <p>
         * An array of <code>Workteam</code> objects, each describing a work team.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Workteam.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Workteam#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Workteam.Builder#build()} is called immediately and
         * its result is passed to {@link #workteams(List<Workteam>)}.
         * 
         * @param workteams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Workteam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workteams(java.util.Collection<Workteam>)
         */
        Builder workteams(Consumer<Workteam.Builder>... workteams);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work
         *        teams, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Workteam> workteams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkteamsResponse model) {
            super(model);
            workteams(model.workteams);
            nextToken(model.nextToken);
        }

        public final List<Workteam.Builder> getWorkteams() {
            List<Workteam.Builder> result = WorkteamsCopier.copyToBuilder(this.workteams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkteams(Collection<Workteam.BuilderImpl> workteams) {
            this.workteams = WorkteamsCopier.copyFromBuilder(workteams);
        }

        @Override
        public final Builder workteams(Collection<Workteam> workteams) {
            this.workteams = WorkteamsCopier.copy(workteams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workteams(Workteam... workteams) {
            workteams(Arrays.asList(workteams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workteams(Consumer<Workteam.Builder>... workteams) {
            workteams(Stream.of(workteams).map(c -> Workteam.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkteamsResponse build() {
            return new ListWorkteamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
