/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code>. You can view
 * these logs to understand how your training job performs and check for any errors encountered during training.
 * SageMaker hyperparameter tuning captures all defined metrics. Specify one of the defined metrics to use as an
 * objective metric using the <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-TuningObjective"
 * >TuningObjective</a> parameter in the <code>HyperParameterTrainingJobDefinition</code> API to evaluate job
 * performance during hyperparameter tuning.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDefinition.Builder, MetricDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Regex")
            .getter(getter(MetricDefinition::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Regex", REGEX_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String regex;

    private MetricDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.regex = builder.regex;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A regular expression that searches the output of a training job and gets the value of the metric. For more
     * information about using regular expressions to define metrics, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
     * >Defining metrics and environment variables</a>.
     * </p>
     * 
     * @return A regular expression that searches the output of a training job and gets the value of the metric. For
     *         more information about using regular expressions to define metrics, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
     *         >Defining metrics and environment variables</a>.
     */
    public final String regex() {
        return regex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(regex(), other.regex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDefinition").add("Name", name()).add("Regex", regex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Regex":
            return Optional.ofNullable(clazz.cast(regex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinition, T> g) {
        return obj -> g.apply((MetricDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDefinition> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param name
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A regular expression that searches the output of a training job and gets the value of the metric. For more
         * information about using regular expressions to define metrics, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
         * >Defining metrics and environment variables</a>.
         * </p>
         * 
         * @param regex
         *        A regular expression that searches the output of a training job and gets the value of the metric. For
         *        more information about using regular expressions to define metrics, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html"
         *        >Defining metrics and environment variables</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String regex;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            name(model.name);
            regex(model.regex);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        @Override
        public MetricDefinition build() {
            return new MetricDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
