/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The artifacts of the model card export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelCardExportArtifacts implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelCardExportArtifacts.Builder, ModelCardExportArtifacts> {
    private static final SdkField<String> S3_EXPORT_ARTIFACTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ExportArtifacts").getter(getter(ModelCardExportArtifacts::s3ExportArtifacts))
            .setter(setter(Builder::s3ExportArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportArtifacts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_EXPORT_ARTIFACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("S3ExportArtifacts", S3_EXPORT_ARTIFACTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String s3ExportArtifacts;

    private ModelCardExportArtifacts(BuilderImpl builder) {
        this.s3ExportArtifacts = builder.s3ExportArtifacts;
    }

    /**
     * <p>
     * The Amazon S3 URI of the exported model artifacts.
     * </p>
     * 
     * @return The Amazon S3 URI of the exported model artifacts.
     */
    public final String s3ExportArtifacts() {
        return s3ExportArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportArtifacts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCardExportArtifacts)) {
            return false;
        }
        ModelCardExportArtifacts other = (ModelCardExportArtifacts) obj;
        return Objects.equals(s3ExportArtifacts(), other.s3ExportArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelCardExportArtifacts").add("S3ExportArtifacts", s3ExportArtifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ExportArtifacts":
            return Optional.ofNullable(clazz.cast(s3ExportArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelCardExportArtifacts, T> g) {
        return obj -> g.apply((ModelCardExportArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelCardExportArtifacts> {
        /**
         * <p>
         * The Amazon S3 URI of the exported model artifacts.
         * </p>
         * 
         * @param s3ExportArtifacts
         *        The Amazon S3 URI of the exported model artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportArtifacts(String s3ExportArtifacts);
    }

    static final class BuilderImpl implements Builder {
        private String s3ExportArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCardExportArtifacts model) {
            s3ExportArtifacts(model.s3ExportArtifacts);
        }

        public final String getS3ExportArtifacts() {
            return s3ExportArtifacts;
        }

        public final void setS3ExportArtifacts(String s3ExportArtifacts) {
            this.s3ExportArtifacts = s3ExportArtifacts;
        }

        @Override
        public final Builder s3ExportArtifacts(String s3ExportArtifacts) {
            this.s3ExportArtifacts = s3ExportArtifacts;
            return this;
        }

        @Override
        public ModelCardExportArtifacts build() {
            return new ModelCardExportArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
