/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringAlertActions implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringAlertActions.Builder, MonitoringAlertActions> {
    private static final SdkField<ModelDashboardIndicatorAction> MODEL_DASHBOARD_INDICATOR_FIELD = SdkField
            .<ModelDashboardIndicatorAction> builder(MarshallingType.SDK_POJO).memberName("ModelDashboardIndicator")
            .getter(getter(MonitoringAlertActions::modelDashboardIndicator)).setter(setter(Builder::modelDashboardIndicator))
            .constructor(ModelDashboardIndicatorAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDashboardIndicator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MODEL_DASHBOARD_INDICATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelDashboardIndicator", MODEL_DASHBOARD_INDICATOR_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ModelDashboardIndicatorAction modelDashboardIndicator;

    private MonitoringAlertActions(BuilderImpl builder) {
        this.modelDashboardIndicator = builder.modelDashboardIndicator;
    }

    /**
     * <p>
     * An alert action taken to light up an icon on the Model Dashboard when an alert goes into <code>InAlert</code>
     * status.
     * </p>
     * 
     * @return An alert action taken to light up an icon on the Model Dashboard when an alert goes into
     *         <code>InAlert</code> status.
     */
    public final ModelDashboardIndicatorAction modelDashboardIndicator() {
        return modelDashboardIndicator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelDashboardIndicator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAlertActions)) {
            return false;
        }
        MonitoringAlertActions other = (MonitoringAlertActions) obj;
        return Objects.equals(modelDashboardIndicator(), other.modelDashboardIndicator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringAlertActions").add("ModelDashboardIndicator", modelDashboardIndicator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelDashboardIndicator":
            return Optional.ofNullable(clazz.cast(modelDashboardIndicator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAlertActions, T> g) {
        return obj -> g.apply((MonitoringAlertActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringAlertActions> {
        /**
         * <p>
         * An alert action taken to light up an icon on the Model Dashboard when an alert goes into <code>InAlert</code>
         * status.
         * </p>
         * 
         * @param modelDashboardIndicator
         *        An alert action taken to light up an icon on the Model Dashboard when an alert goes into
         *        <code>InAlert</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDashboardIndicator(ModelDashboardIndicatorAction modelDashboardIndicator);

        /**
         * <p>
         * An alert action taken to light up an icon on the Model Dashboard when an alert goes into <code>InAlert</code>
         * status.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDashboardIndicatorAction.Builder}
         * avoiding the need to create one manually via {@link ModelDashboardIndicatorAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDashboardIndicatorAction.Builder#build()} is called
         * immediately and its result is passed to {@link #modelDashboardIndicator(ModelDashboardIndicatorAction)}.
         * 
         * @param modelDashboardIndicator
         *        a consumer that will call methods on {@link ModelDashboardIndicatorAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDashboardIndicator(ModelDashboardIndicatorAction)
         */
        default Builder modelDashboardIndicator(Consumer<ModelDashboardIndicatorAction.Builder> modelDashboardIndicator) {
            return modelDashboardIndicator(ModelDashboardIndicatorAction.builder().applyMutation(modelDashboardIndicator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelDashboardIndicatorAction modelDashboardIndicator;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAlertActions model) {
            modelDashboardIndicator(model.modelDashboardIndicator);
        }

        public final ModelDashboardIndicatorAction.Builder getModelDashboardIndicator() {
            return modelDashboardIndicator != null ? modelDashboardIndicator.toBuilder() : null;
        }

        public final void setModelDashboardIndicator(ModelDashboardIndicatorAction.BuilderImpl modelDashboardIndicator) {
            this.modelDashboardIndicator = modelDashboardIndicator != null ? modelDashboardIndicator.build() : null;
        }

        @Override
        public final Builder modelDashboardIndicator(ModelDashboardIndicatorAction modelDashboardIndicator) {
            this.modelDashboardIndicator = modelDashboardIndicator;
            return this;
        }

        @Override
        public MonitoringAlertActions build() {
            return new MonitoringAlertActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
