/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a monitor alert.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringAlertSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringAlertSummary.Builder, MonitoringAlertSummary> {
    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringAlertName").getter(getter(MonitoringAlertSummary::monitoringAlertName))
            .setter(setter(Builder::monitoringAlertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitoringAlertSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(MonitoringAlertSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertStatus").getter(getter(MonitoringAlertSummary::alertStatusAsString))
            .setter(setter(Builder::alertStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()).build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALERT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlert").getter(getter(MonitoringAlertSummary::datapointsToAlert))
            .setter(setter(Builder::datapointsToAlert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlert").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriod").getter(getter(MonitoringAlertSummary::evaluationPeriod))
            .setter(setter(Builder::evaluationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriod").build()).build();

    private static final SdkField<MonitoringAlertActions> ACTIONS_FIELD = SdkField
            .<MonitoringAlertActions> builder(MarshallingType.SDK_POJO).memberName("Actions")
            .getter(getter(MonitoringAlertSummary::actions)).setter(setter(Builder::actions))
            .constructor(MonitoringAlertActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_ALERT_NAME_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ALERT_STATUS_FIELD, DATAPOINTS_TO_ALERT_FIELD,
            EVALUATION_PERIOD_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("AlertStatus", ALERT_STATUS_FIELD);
                    put("DatapointsToAlert", DATAPOINTS_TO_ALERT_FIELD);
                    put("EvaluationPeriod", EVALUATION_PERIOD_FIELD);
                    put("Actions", ACTIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String monitoringAlertName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String alertStatus;

    private final Integer datapointsToAlert;

    private final Integer evaluationPeriod;

    private final MonitoringAlertActions actions;

    private MonitoringAlertSummary(BuilderImpl builder) {
        this.monitoringAlertName = builder.monitoringAlertName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.alertStatus = builder.alertStatus;
        this.datapointsToAlert = builder.datapointsToAlert;
        this.evaluationPeriod = builder.evaluationPeriod;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @return The name of a monitoring alert.
     */
    public final String monitoringAlertName() {
        return monitoringAlertName;
    }

    /**
     * <p>
     * A timestamp that indicates when a monitor alert was created.
     * </p>
     * 
     * @return A timestamp that indicates when a monitor alert was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that indicates when a monitor alert was last updated.
     * </p>
     * 
     * @return A timestamp that indicates when a monitor alert was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The current status of an alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The current status of an alert.
     * @see MonitoringAlertStatus
     */
    public final MonitoringAlertStatus alertStatus() {
        return MonitoringAlertStatus.fromValue(alertStatus);
    }

    /**
     * <p>
     * The current status of an alert.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alertStatus} will
     * return {@link MonitoringAlertStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #alertStatusAsString}.
     * </p>
     * 
     * @return The current status of an alert.
     * @see MonitoringAlertStatus
     */
    public final String alertStatusAsString() {
        return alertStatus;
    }

    /**
     * <p>
     * Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
     * </p>
     * 
     * @return Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
     */
    public final Integer datapointsToAlert() {
        return datapointsToAlert;
    }

    /**
     * <p>
     * The number of most recent monitoring executions to consider when evaluating alert status.
     * </p>
     * 
     * @return The number of most recent monitoring executions to consider when evaluating alert status.
     */
    public final Integer evaluationPeriod() {
        return evaluationPeriod;
    }

    /**
     * <p>
     * A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
     * </p>
     * 
     * @return A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
     */
    public final MonitoringAlertActions actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlert());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAlertSummary)) {
            return false;
        }
        MonitoringAlertSummary other = (MonitoringAlertSummary) obj;
        return Objects.equals(monitoringAlertName(), other.monitoringAlertName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(alertStatusAsString(), other.alertStatusAsString())
                && Objects.equals(datapointsToAlert(), other.datapointsToAlert())
                && Objects.equals(evaluationPeriod(), other.evaluationPeriod()) && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringAlertSummary").add("MonitoringAlertName", monitoringAlertName())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("AlertStatus", alertStatusAsString()).add("DatapointsToAlert", datapointsToAlert())
                .add("EvaluationPeriod", evaluationPeriod()).add("Actions", actions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringAlertName":
            return Optional.ofNullable(clazz.cast(monitoringAlertName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "AlertStatus":
            return Optional.ofNullable(clazz.cast(alertStatusAsString()));
        case "DatapointsToAlert":
            return Optional.ofNullable(clazz.cast(datapointsToAlert()));
        case "EvaluationPeriod":
            return Optional.ofNullable(clazz.cast(evaluationPeriod()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAlertSummary, T> g) {
        return obj -> g.apply((MonitoringAlertSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringAlertSummary> {
        /**
         * <p>
         * The name of a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertName
         *        The name of a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertName(String monitoringAlertName);

        /**
         * <p>
         * A timestamp that indicates when a monitor alert was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when a monitor alert was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that indicates when a monitor alert was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates when a monitor alert was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The current status of an alert.
         * </p>
         * 
         * @param alertStatus
         *        The current status of an alert.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder alertStatus(String alertStatus);

        /**
         * <p>
         * The current status of an alert.
         * </p>
         * 
         * @param alertStatus
         *        The current status of an alert.
         * @see MonitoringAlertStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringAlertStatus
         */
        Builder alertStatus(MonitoringAlertStatus alertStatus);

        /**
         * <p>
         * Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
         * </p>
         * 
         * @param datapointsToAlert
         *        Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlert(Integer datapointsToAlert);

        /**
         * <p>
         * The number of most recent monitoring executions to consider when evaluating alert status.
         * </p>
         * 
         * @param evaluationPeriod
         *        The number of most recent monitoring executions to consider when evaluating alert status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriod(Integer evaluationPeriod);

        /**
         * <p>
         * A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
         * </p>
         * 
         * @param actions
         *        A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(MonitoringAlertActions actions);

        /**
         * <p>
         * A list of alert actions taken in response to an alert going into <code>InAlert</code> status.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringAlertActions.Builder} avoiding
         * the need to create one manually via {@link MonitoringAlertActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringAlertActions.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(MonitoringAlertActions)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link MonitoringAlertActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(MonitoringAlertActions)
         */
        default Builder actions(Consumer<MonitoringAlertActions.Builder> actions) {
            return actions(MonitoringAlertActions.builder().applyMutation(actions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String monitoringAlertName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String alertStatus;

        private Integer datapointsToAlert;

        private Integer evaluationPeriod;

        private MonitoringAlertActions actions;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAlertSummary model) {
            monitoringAlertName(model.monitoringAlertName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            alertStatus(model.alertStatus);
            datapointsToAlert(model.datapointsToAlert);
            evaluationPeriod(model.evaluationPeriod);
            actions(model.actions);
        }

        public final String getMonitoringAlertName() {
            return monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getAlertStatus() {
            return alertStatus;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(MonitoringAlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final Integer getDatapointsToAlert() {
            return datapointsToAlert;
        }

        public final void setDatapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
        }

        @Override
        public final Builder datapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
            return this;
        }

        public final Integer getEvaluationPeriod() {
            return evaluationPeriod;
        }

        public final void setEvaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
        }

        @Override
        public final Builder evaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
            return this;
        }

        public final MonitoringAlertActions.Builder getActions() {
            return actions != null ? actions.toBuilder() : null;
        }

        public final void setActions(MonitoringAlertActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MonitoringAlertActions actions) {
            this.actions = actions;
            return this;
        }

        @Override
        public MonitoringAlertSummary build() {
            return new MonitoringAlertSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
