/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringJobDefinitionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringJobDefinitionSummary.Builder, MonitoringJobDefinitionSummary> {
    private static final SdkField<String> MONITORING_JOB_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MonitoringJobDefinitionName")
            .getter(getter(MonitoringJobDefinitionSummary::monitoringJobDefinitionName))
            .setter(setter(Builder::monitoringJobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionName")
                    .build()).build();

    private static final SdkField<String> MONITORING_JOB_DEFINITION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MonitoringJobDefinitionArn")
            .getter(getter(MonitoringJobDefinitionSummary::monitoringJobDefinitionArn))
            .setter(setter(Builder::monitoringJobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionArn").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitoringJobDefinitionSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(MonitoringJobDefinitionSummary::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_JOB_DEFINITION_NAME_FIELD, MONITORING_JOB_DEFINITION_ARN_FIELD, CREATION_TIME_FIELD, ENDPOINT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MonitoringJobDefinitionName", MONITORING_JOB_DEFINITION_NAME_FIELD);
                    put("MonitoringJobDefinitionArn", MONITORING_JOB_DEFINITION_ARN_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("EndpointName", ENDPOINT_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String monitoringJobDefinitionName;

    private final String monitoringJobDefinitionArn;

    private final Instant creationTime;

    private final String endpointName;

    private MonitoringJobDefinitionSummary(BuilderImpl builder) {
        this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
        this.monitoringJobDefinitionArn = builder.monitoringJobDefinitionArn;
        this.creationTime = builder.creationTime;
        this.endpointName = builder.endpointName;
    }

    /**
     * <p>
     * The name of the monitoring job.
     * </p>
     * 
     * @return The name of the monitoring job.
     */
    public final String monitoringJobDefinitionName() {
        return monitoringJobDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring job.
     */
    public final String monitoringJobDefinitionArn() {
        return monitoringJobDefinitionArn;
    }

    /**
     * <p>
     * The time that the monitoring job was created.
     * </p>
     * 
     * @return The time that the monitoring job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the endpoint that the job monitors.
     * </p>
     * 
     * @return The name of the endpoint that the job monitors.
     */
    public final String endpointName() {
        return endpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringJobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringJobDefinitionSummary)) {
            return false;
        }
        MonitoringJobDefinitionSummary other = (MonitoringJobDefinitionSummary) obj;
        return Objects.equals(monitoringJobDefinitionName(), other.monitoringJobDefinitionName())
                && Objects.equals(monitoringJobDefinitionArn(), other.monitoringJobDefinitionArn())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endpointName(), other.endpointName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringJobDefinitionSummary")
                .add("MonitoringJobDefinitionName", monitoringJobDefinitionName())
                .add("MonitoringJobDefinitionArn", monitoringJobDefinitionArn()).add("CreationTime", creationTime())
                .add("EndpointName", endpointName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringJobDefinitionName":
            return Optional.ofNullable(clazz.cast(monitoringJobDefinitionName()));
        case "MonitoringJobDefinitionArn":
            return Optional.ofNullable(clazz.cast(monitoringJobDefinitionArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringJobDefinitionSummary, T> g) {
        return obj -> g.apply((MonitoringJobDefinitionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringJobDefinitionSummary> {
        /**
         * <p>
         * The name of the monitoring job.
         * </p>
         * 
         * @param monitoringJobDefinitionName
         *        The name of the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringJobDefinitionName(String monitoringJobDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring job.
         * </p>
         * 
         * @param monitoringJobDefinitionArn
         *        The Amazon Resource Name (ARN) of the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringJobDefinitionArn(String monitoringJobDefinitionArn);

        /**
         * <p>
         * The time that the monitoring job was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the monitoring job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the endpoint that the job monitors.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint that the job monitors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringJobDefinitionName;

        private String monitoringJobDefinitionArn;

        private Instant creationTime;

        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringJobDefinitionSummary model) {
            monitoringJobDefinitionName(model.monitoringJobDefinitionName);
            monitoringJobDefinitionArn(model.monitoringJobDefinitionArn);
            creationTime(model.creationTime);
            endpointName(model.endpointName);
        }

        public final String getMonitoringJobDefinitionName() {
            return monitoringJobDefinitionName;
        }

        public final void setMonitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
        }

        @Override
        public final Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
            return this;
        }

        public final String getMonitoringJobDefinitionArn() {
            return monitoringJobDefinitionArn;
        }

        public final void setMonitoringJobDefinitionArn(String monitoringJobDefinitionArn) {
            this.monitoringJobDefinitionArn = monitoringJobDefinitionArn;
        }

        @Override
        public final Builder monitoringJobDefinitionArn(String monitoringJobDefinitionArn) {
            this.monitoringJobDefinitionArn = monitoringJobDefinitionArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        @Override
        public MonitoringJobDefinitionSummary build() {
            return new MonitoringJobDefinitionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
