/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time limit for how long the monitoring job is allowed to run before stopping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringStoppingCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringStoppingCondition.Builder, MonitoringStoppingCondition> {
    private static final SdkField<Integer> MAX_RUNTIME_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRuntimeInSeconds").getter(getter(MonitoringStoppingCondition::maxRuntimeInSeconds))
            .setter(setter(Builder::maxRuntimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRuntimeInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RUNTIME_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxRuntimeInSeconds", MAX_RUNTIME_IN_SECONDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer maxRuntimeInSeconds;

    private MonitoringStoppingCondition(BuilderImpl builder) {
        this.maxRuntimeInSeconds = builder.maxRuntimeInSeconds;
    }

    /**
     * <p>
     * The maximum runtime allowed in seconds.
     * </p>
     * <note>
     * <p>
     * The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model
     * explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality hourly
     * schedules, this can be up to 1800 seconds.
     * </p>
     * </note>
     * 
     * @return The maximum runtime allowed in seconds.</p> <note>
     *         <p>
     *         The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model
     *         explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality
     *         hourly schedules, this can be up to 1800 seconds.
     *         </p>
     */
    public final Integer maxRuntimeInSeconds() {
        return maxRuntimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxRuntimeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringStoppingCondition)) {
            return false;
        }
        MonitoringStoppingCondition other = (MonitoringStoppingCondition) obj;
        return Objects.equals(maxRuntimeInSeconds(), other.maxRuntimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringStoppingCondition").add("MaxRuntimeInSeconds", maxRuntimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxRuntimeInSeconds":
            return Optional.ofNullable(clazz.cast(maxRuntimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringStoppingCondition, T> g) {
        return obj -> g.apply((MonitoringStoppingCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringStoppingCondition> {
        /**
         * <p>
         * The maximum runtime allowed in seconds.
         * </p>
         * <note>
         * <p>
         * The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model
         * explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality
         * hourly schedules, this can be up to 1800 seconds.
         * </p>
         * </note>
         * 
         * @param maxRuntimeInSeconds
         *        The maximum runtime allowed in seconds.</p> <note>
         *        <p>
         *        The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and
         *        model explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model
         *        quality hourly schedules, this can be up to 1800 seconds.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuntimeInSeconds(Integer maxRuntimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxRuntimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringStoppingCondition model) {
            maxRuntimeInSeconds(model.maxRuntimeInSeconds);
        }

        public final Integer getMaxRuntimeInSeconds() {
            return maxRuntimeInSeconds;
        }

        public final void setMaxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
        }

        @Override
        public final Builder maxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
            return this;
        }

        @Override
        public MonitoringStoppingCondition build() {
            return new MonitoringStoppingCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
