/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of <code>OfflineStore</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfflineStoreStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OfflineStoreStatus.Builder, OfflineStoreStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OfflineStoreStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> BLOCKED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockedReason").getter(getter(OfflineStoreStatus::blockedReason)).setter(setter(Builder::blockedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            BLOCKED_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Status", STATUS_FIELD);
                    put("BlockedReason", BLOCKED_REASON_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String blockedReason;

    private OfflineStoreStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.blockedReason = builder.blockedReason;
    }

    /**
     * <p>
     * An <code>OfflineStore</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OfflineStoreStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return An <code>OfflineStore</code> status.
     * @see OfflineStoreStatusValue
     */
    public final OfflineStoreStatusValue status() {
        return OfflineStoreStatusValue.fromValue(status);
    }

    /**
     * <p>
     * An <code>OfflineStore</code> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OfflineStoreStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return An <code>OfflineStore</code> status.
     * @see OfflineStoreStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The justification for why the OfflineStoreStatus is Blocked (if applicable).
     * </p>
     * 
     * @return The justification for why the OfflineStoreStatus is Blocked (if applicable).
     */
    public final String blockedReason() {
        return blockedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockedReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineStoreStatus)) {
            return false;
        }
        OfflineStoreStatus other = (OfflineStoreStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(blockedReason(), other.blockedReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfflineStoreStatus").add("Status", statusAsString()).add("BlockedReason", blockedReason())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "BlockedReason":
            return Optional.ofNullable(clazz.cast(blockedReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OfflineStoreStatus, T> g) {
        return obj -> g.apply((OfflineStoreStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfflineStoreStatus> {
        /**
         * <p>
         * An <code>OfflineStore</code> status.
         * </p>
         * 
         * @param status
         *        An <code>OfflineStore</code> status.
         * @see OfflineStoreStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfflineStoreStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * An <code>OfflineStore</code> status.
         * </p>
         * 
         * @param status
         *        An <code>OfflineStore</code> status.
         * @see OfflineStoreStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfflineStoreStatusValue
         */
        Builder status(OfflineStoreStatusValue status);

        /**
         * <p>
         * The justification for why the OfflineStoreStatus is Blocked (if applicable).
         * </p>
         * 
         * @param blockedReason
         *        The justification for why the OfflineStoreStatus is Blocked (if applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedReason(String blockedReason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String blockedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(OfflineStoreStatus model) {
            status(model.status);
            blockedReason(model.blockedReason);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OfflineStoreStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getBlockedReason() {
            return blockedReason;
        }

        public final void setBlockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Override
        public final Builder blockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
            return this;
        }

        @Override
        public OfflineStoreStatus build() {
            return new OfflineStoreStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
