/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes an optimization job by providing some of its key properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizationJobSummary.Builder, OptimizationJobSummary> {
    private static final SdkField<String> OPTIMIZATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobName").getter(getter(OptimizationJobSummary::optimizationJobName))
            .setter(setter(Builder::optimizationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobName").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobArn").getter(getter(OptimizationJobSummary::optimizationJobArn))
            .setter(setter(Builder::optimizationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobArn").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(OptimizationJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> OPTIMIZATION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationJobStatus").getter(getter(OptimizationJobSummary::optimizationJobStatusAsString))
            .setter(setter(Builder::optimizationJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationJobStatus").build())
            .build();

    private static final SdkField<Instant> OPTIMIZATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptimizationStartTime").getter(getter(OptimizationJobSummary::optimizationStartTime))
            .setter(setter(Builder::optimizationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationStartTime").build())
            .build();

    private static final SdkField<Instant> OPTIMIZATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptimizationEndTime").getter(getter(OptimizationJobSummary::optimizationEndTime))
            .setter(setter(Builder::optimizationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationEndTime").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(OptimizationJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DEPLOYMENT_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentInstanceType").getter(getter(OptimizationJobSummary::deploymentInstanceTypeAsString))
            .setter(setter(Builder::deploymentInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentInstanceType").build())
            .build();

    private static final SdkField<List<String>> OPTIMIZATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptimizationTypes")
            .getter(getter(OptimizationJobSummary::optimizationTypes))
            .setter(setter(Builder::optimizationTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZATION_JOB_NAME_FIELD,
            OPTIMIZATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, OPTIMIZATION_JOB_STATUS_FIELD, OPTIMIZATION_START_TIME_FIELD,
            OPTIMIZATION_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DEPLOYMENT_INSTANCE_TYPE_FIELD, OPTIMIZATION_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OptimizationJobName", OPTIMIZATION_JOB_NAME_FIELD);
                    put("OptimizationJobArn", OPTIMIZATION_JOB_ARN_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("OptimizationJobStatus", OPTIMIZATION_JOB_STATUS_FIELD);
                    put("OptimizationStartTime", OPTIMIZATION_START_TIME_FIELD);
                    put("OptimizationEndTime", OPTIMIZATION_END_TIME_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("DeploymentInstanceType", DEPLOYMENT_INSTANCE_TYPE_FIELD);
                    put("OptimizationTypes", OPTIMIZATION_TYPES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String optimizationJobName;

    private final String optimizationJobArn;

    private final Instant creationTime;

    private final String optimizationJobStatus;

    private final Instant optimizationStartTime;

    private final Instant optimizationEndTime;

    private final Instant lastModifiedTime;

    private final String deploymentInstanceType;

    private final List<String> optimizationTypes;

    private OptimizationJobSummary(BuilderImpl builder) {
        this.optimizationJobName = builder.optimizationJobName;
        this.optimizationJobArn = builder.optimizationJobArn;
        this.creationTime = builder.creationTime;
        this.optimizationJobStatus = builder.optimizationJobStatus;
        this.optimizationStartTime = builder.optimizationStartTime;
        this.optimizationEndTime = builder.optimizationEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.deploymentInstanceType = builder.deploymentInstanceType;
        this.optimizationTypes = builder.optimizationTypes;
    }

    /**
     * <p>
     * The name that you assigned to the optimization job.
     * </p>
     * 
     * @return The name that you assigned to the optimization job.
     */
    public final String optimizationJobName() {
        return optimizationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the optimization job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the optimization job.
     */
    public final String optimizationJobArn() {
        return optimizationJobArn;
    }

    /**
     * <p>
     * The time when you created the optimization job.
     * </p>
     * 
     * @return The time when you created the optimization job.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current status of the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationJobStatus} will return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the optimization job.
     * @see OptimizationJobStatus
     */
    public final OptimizationJobStatus optimizationJobStatus() {
        return OptimizationJobStatus.fromValue(optimizationJobStatus);
    }

    /**
     * <p>
     * The current status of the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizationJobStatus} will return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #optimizationJobStatusAsString}.
     * </p>
     * 
     * @return The current status of the optimization job.
     * @see OptimizationJobStatus
     */
    public final String optimizationJobStatusAsString() {
        return optimizationJobStatus;
    }

    /**
     * <p>
     * The time when the optimization job started.
     * </p>
     * 
     * @return The time when the optimization job started.
     */
    public final Instant optimizationStartTime() {
        return optimizationStartTime;
    }

    /**
     * <p>
     * The time when the optimization job finished processing.
     * </p>
     * 
     * @return The time when the optimization job finished processing.
     */
    public final Instant optimizationEndTime() {
        return optimizationEndTime;
    }

    /**
     * <p>
     * The time when the optimization job was last updated.
     * </p>
     * 
     * @return The time when the optimization job was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final OptimizationJobDeploymentInstanceType deploymentInstanceType() {
        return OptimizationJobDeploymentInstanceType.fromValue(deploymentInstanceType);
    }

    /**
     * <p>
     * The type of instance that hosts the optimized model that you create with the optimization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentInstanceType} will return {@link OptimizationJobDeploymentInstanceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #deploymentInstanceTypeAsString}.
     * </p>
     * 
     * @return The type of instance that hosts the optimized model that you create with the optimization job.
     * @see OptimizationJobDeploymentInstanceType
     */
    public final String deploymentInstanceTypeAsString() {
        return deploymentInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptimizationTypes() {
        return optimizationTypes != null && !(optimizationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optimization techniques that are applied by the optimization job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizationTypes} method.
     * </p>
     * 
     * @return The optimization techniques that are applied by the optimization job.
     */
    public final List<String> optimizationTypes() {
        return optimizationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizationTypes() ? optimizationTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobSummary)) {
            return false;
        }
        OptimizationJobSummary other = (OptimizationJobSummary) obj;
        return Objects.equals(optimizationJobName(), other.optimizationJobName())
                && Objects.equals(optimizationJobArn(), other.optimizationJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(optimizationJobStatusAsString(), other.optimizationJobStatusAsString())
                && Objects.equals(optimizationStartTime(), other.optimizationStartTime())
                && Objects.equals(optimizationEndTime(), other.optimizationEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(deploymentInstanceTypeAsString(), other.deploymentInstanceTypeAsString())
                && hasOptimizationTypes() == other.hasOptimizationTypes()
                && Objects.equals(optimizationTypes(), other.optimizationTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizationJobSummary").add("OptimizationJobName", optimizationJobName())
                .add("OptimizationJobArn", optimizationJobArn()).add("CreationTime", creationTime())
                .add("OptimizationJobStatus", optimizationJobStatusAsString())
                .add("OptimizationStartTime", optimizationStartTime()).add("OptimizationEndTime", optimizationEndTime())
                .add("LastModifiedTime", lastModifiedTime()).add("DeploymentInstanceType", deploymentInstanceTypeAsString())
                .add("OptimizationTypes", hasOptimizationTypes() ? optimizationTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptimizationJobName":
            return Optional.ofNullable(clazz.cast(optimizationJobName()));
        case "OptimizationJobArn":
            return Optional.ofNullable(clazz.cast(optimizationJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "OptimizationJobStatus":
            return Optional.ofNullable(clazz.cast(optimizationJobStatusAsString()));
        case "OptimizationStartTime":
            return Optional.ofNullable(clazz.cast(optimizationStartTime()));
        case "OptimizationEndTime":
            return Optional.ofNullable(clazz.cast(optimizationEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DeploymentInstanceType":
            return Optional.ofNullable(clazz.cast(deploymentInstanceTypeAsString()));
        case "OptimizationTypes":
            return Optional.ofNullable(clazz.cast(optimizationTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobSummary, T> g) {
        return obj -> g.apply((OptimizationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizationJobSummary> {
        /**
         * <p>
         * The name that you assigned to the optimization job.
         * </p>
         * 
         * @param optimizationJobName
         *        The name that you assigned to the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobName(String optimizationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the optimization job.
         * </p>
         * 
         * @param optimizationJobArn
         *        The Amazon Resource Name (ARN) of the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationJobArn(String optimizationJobArn);

        /**
         * <p>
         * The time when you created the optimization job.
         * </p>
         * 
         * @param creationTime
         *        The time when you created the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The current status of the optimization job.
         * </p>
         * 
         * @param optimizationJobStatus
         *        The current status of the optimization job.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder optimizationJobStatus(String optimizationJobStatus);

        /**
         * <p>
         * The current status of the optimization job.
         * </p>
         * 
         * @param optimizationJobStatus
         *        The current status of the optimization job.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus);

        /**
         * <p>
         * The time when the optimization job started.
         * </p>
         * 
         * @param optimizationStartTime
         *        The time when the optimization job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationStartTime(Instant optimizationStartTime);

        /**
         * <p>
         * The time when the optimization job finished processing.
         * </p>
         * 
         * @param optimizationEndTime
         *        The time when the optimization job finished processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationEndTime(Instant optimizationEndTime);

        /**
         * <p>
         * The time when the optimization job was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the optimization job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(String deploymentInstanceType);

        /**
         * <p>
         * The type of instance that hosts the optimized model that you create with the optimization job.
         * </p>
         * 
         * @param deploymentInstanceType
         *        The type of instance that hosts the optimized model that you create with the optimization job.
         * @see OptimizationJobDeploymentInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobDeploymentInstanceType
         */
        Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType);

        /**
         * <p>
         * The optimization techniques that are applied by the optimization job.
         * </p>
         * 
         * @param optimizationTypes
         *        The optimization techniques that are applied by the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationTypes(Collection<String> optimizationTypes);

        /**
         * <p>
         * The optimization techniques that are applied by the optimization job.
         * </p>
         * 
         * @param optimizationTypes
         *        The optimization techniques that are applied by the optimization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationTypes(String... optimizationTypes);
    }

    static final class BuilderImpl implements Builder {
        private String optimizationJobName;

        private String optimizationJobArn;

        private Instant creationTime;

        private String optimizationJobStatus;

        private Instant optimizationStartTime;

        private Instant optimizationEndTime;

        private Instant lastModifiedTime;

        private String deploymentInstanceType;

        private List<String> optimizationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobSummary model) {
            optimizationJobName(model.optimizationJobName);
            optimizationJobArn(model.optimizationJobArn);
            creationTime(model.creationTime);
            optimizationJobStatus(model.optimizationJobStatus);
            optimizationStartTime(model.optimizationStartTime);
            optimizationEndTime(model.optimizationEndTime);
            lastModifiedTime(model.lastModifiedTime);
            deploymentInstanceType(model.deploymentInstanceType);
            optimizationTypes(model.optimizationTypes);
        }

        public final String getOptimizationJobName() {
            return optimizationJobName;
        }

        public final void setOptimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
        }

        @Override
        public final Builder optimizationJobName(String optimizationJobName) {
            this.optimizationJobName = optimizationJobName;
            return this;
        }

        public final String getOptimizationJobArn() {
            return optimizationJobArn;
        }

        public final void setOptimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
        }

        @Override
        public final Builder optimizationJobArn(String optimizationJobArn) {
            this.optimizationJobArn = optimizationJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getOptimizationJobStatus() {
            return optimizationJobStatus;
        }

        public final void setOptimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
        }

        @Override
        public final Builder optimizationJobStatus(String optimizationJobStatus) {
            this.optimizationJobStatus = optimizationJobStatus;
            return this;
        }

        @Override
        public final Builder optimizationJobStatus(OptimizationJobStatus optimizationJobStatus) {
            this.optimizationJobStatus(optimizationJobStatus == null ? null : optimizationJobStatus.toString());
            return this;
        }

        public final Instant getOptimizationStartTime() {
            return optimizationStartTime;
        }

        public final void setOptimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
        }

        @Override
        public final Builder optimizationStartTime(Instant optimizationStartTime) {
            this.optimizationStartTime = optimizationStartTime;
            return this;
        }

        public final Instant getOptimizationEndTime() {
            return optimizationEndTime;
        }

        public final void setOptimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
        }

        @Override
        public final Builder optimizationEndTime(Instant optimizationEndTime) {
            this.optimizationEndTime = optimizationEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDeploymentInstanceType() {
            return deploymentInstanceType;
        }

        public final void setDeploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
        }

        @Override
        public final Builder deploymentInstanceType(String deploymentInstanceType) {
            this.deploymentInstanceType = deploymentInstanceType;
            return this;
        }

        @Override
        public final Builder deploymentInstanceType(OptimizationJobDeploymentInstanceType deploymentInstanceType) {
            this.deploymentInstanceType(deploymentInstanceType == null ? null : deploymentInstanceType.toString());
            return this;
        }

        public final Collection<String> getOptimizationTypes() {
            if (optimizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return optimizationTypes;
        }

        public final void setOptimizationTypes(Collection<String> optimizationTypes) {
            this.optimizationTypes = OptimizationTypesCopier.copy(optimizationTypes);
        }

        @Override
        public final Builder optimizationTypes(Collection<String> optimizationTypes) {
            this.optimizationTypes = OptimizationTypesCopier.copy(optimizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizationTypes(String... optimizationTypes) {
            optimizationTypes(Arrays.asList(optimizationTypes));
            return this;
        }

        @Override
        public OptimizationJobSummary build() {
            return new OptimizationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
