/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the SageMaker Partner AI App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartnerAppConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PartnerAppConfig.Builder, PartnerAppConfig> {
    private static final SdkField<List<String>> ADMIN_USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdminUsers")
            .getter(getter(PartnerAppConfig::adminUsers))
            .setter(setter(Builder::adminUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Arguments")
            .getter(getter(PartnerAppConfig::arguments))
            .setter(setter(Builder::arguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USERS_FIELD,
            ARGUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AdminUsers", ADMIN_USERS_FIELD);
                    put("Arguments", ARGUMENTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> adminUsers;

    private final Map<String, String> arguments;

    private PartnerAppConfig(BuilderImpl builder) {
        this.adminUsers = builder.adminUsers;
        this.arguments = builder.arguments;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdminUsers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdminUsers() {
        return adminUsers != null && !(adminUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of users that are given admin access to the SageMaker Partner AI App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdminUsers} method.
     * </p>
     * 
     * @return The list of users that are given admin access to the SageMaker Partner AI App.
     */
    public final List<String> adminUsers() {
        return adminUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arguments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArguments() {
        return arguments != null && !(arguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the map is
     * populated with a key and value pair that is specific to the user and application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArguments} method.
     * </p>
     * 
     * @return This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the map
     *         is populated with a key and value pair that is specific to the user and application.
     */
    public final Map<String, String> arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdminUsers() ? adminUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasArguments() ? arguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerAppConfig)) {
            return false;
        }
        PartnerAppConfig other = (PartnerAppConfig) obj;
        return hasAdminUsers() == other.hasAdminUsers() && Objects.equals(adminUsers(), other.adminUsers())
                && hasArguments() == other.hasArguments() && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartnerAppConfig").add("AdminUsers", hasAdminUsers() ? adminUsers() : null)
                .add("Arguments", hasArguments() ? arguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminUsers":
            return Optional.ofNullable(clazz.cast(adminUsers()));
        case "Arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PartnerAppConfig, T> g) {
        return obj -> g.apply((PartnerAppConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartnerAppConfig> {
        /**
         * <p>
         * The list of users that are given admin access to the SageMaker Partner AI App.
         * </p>
         * 
         * @param adminUsers
         *        The list of users that are given admin access to the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsers(Collection<String> adminUsers);

        /**
         * <p>
         * The list of users that are given admin access to the SageMaker Partner AI App.
         * </p>
         * 
         * @param adminUsers
         *        The list of users that are given admin access to the SageMaker Partner AI App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsers(String... adminUsers);

        /**
         * <p>
         * This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the map is
         * populated with a key and value pair that is specific to the user and application.
         * </p>
         * 
         * @param arguments
         *        This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the
         *        map is populated with a key and value pair that is specific to the user and application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(Map<String, String> arguments);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adminUsers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerAppConfig model) {
            adminUsers(model.adminUsers);
            arguments(model.arguments);
        }

        public final Collection<String> getAdminUsers() {
            if (adminUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return adminUsers;
        }

        public final void setAdminUsers(Collection<String> adminUsers) {
            this.adminUsers = PartnerAppAdminUserListCopier.copy(adminUsers);
        }

        @Override
        public final Builder adminUsers(Collection<String> adminUsers) {
            this.adminUsers = PartnerAppAdminUserListCopier.copy(adminUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminUsers(String... adminUsers) {
            adminUsers(Arrays.asList(adminUsers));
            return this;
        }

        public final Map<String, String> getArguments() {
            if (arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = PartnerAppArgumentsCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = PartnerAppArgumentsCopier.copy(arguments);
            return this;
        }

        @Override
        public PartnerAppConfig build() {
            return new PartnerAppConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
