/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that control the range in the number of instances that the endpoint provisions as it scales up or down to
 * accommodate traffic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantManagedInstanceScaling implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantManagedInstanceScaling.Builder, ProductionVariantManagedInstanceScaling> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProductionVariantManagedInstanceScaling::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> MIN_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInstanceCount").getter(getter(ProductionVariantManagedInstanceScaling::minInstanceCount))
            .setter(setter(Builder::minInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInstanceCount").build()).build();

    private static final SdkField<Integer> MAX_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInstanceCount").getter(getter(ProductionVariantManagedInstanceScaling::maxInstanceCount))
            .setter(setter(Builder::maxInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            MIN_INSTANCE_COUNT_FIELD, MAX_INSTANCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Status", STATUS_FIELD);
                    put("MinInstanceCount", MIN_INSTANCE_COUNT_FIELD);
                    put("MaxInstanceCount", MAX_INSTANCE_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Integer minInstanceCount;

    private final Integer maxInstanceCount;

    private ProductionVariantManagedInstanceScaling(BuilderImpl builder) {
        this.status = builder.status;
        this.minInstanceCount = builder.minInstanceCount;
        this.maxInstanceCount = builder.maxInstanceCount;
    }

    /**
     * <p>
     * Indicates whether managed instance scaling is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedInstanceScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether managed instance scaling is enabled.
     * @see ManagedInstanceScalingStatus
     */
    public final ManagedInstanceScalingStatus status() {
        return ManagedInstanceScalingStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether managed instance scaling is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedInstanceScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether managed instance scaling is enabled.
     * @see ManagedInstanceScalingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The minimum number of instances that the endpoint must retain when it scales down to accommodate a decrease in
     * traffic.
     * </p>
     * 
     * @return The minimum number of instances that the endpoint must retain when it scales down to accommodate a
     *         decrease in traffic.
     */
    public final Integer minInstanceCount() {
        return minInstanceCount;
    }

    /**
     * <p>
     * The maximum number of instances that the endpoint can provision when it scales up to accommodate an increase in
     * traffic.
     * </p>
     * 
     * @return The maximum number of instances that the endpoint can provision when it scales up to accommodate an
     *         increase in traffic.
     */
    public final Integer maxInstanceCount() {
        return maxInstanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxInstanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantManagedInstanceScaling)) {
            return false;
        }
        ProductionVariantManagedInstanceScaling other = (ProductionVariantManagedInstanceScaling) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(minInstanceCount(), other.minInstanceCount())
                && Objects.equals(maxInstanceCount(), other.maxInstanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantManagedInstanceScaling").add("Status", statusAsString())
                .add("MinInstanceCount", minInstanceCount()).add("MaxInstanceCount", maxInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MinInstanceCount":
            return Optional.ofNullable(clazz.cast(minInstanceCount()));
        case "MaxInstanceCount":
            return Optional.ofNullable(clazz.cast(maxInstanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantManagedInstanceScaling, T> g) {
        return obj -> g.apply((ProductionVariantManagedInstanceScaling) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantManagedInstanceScaling> {
        /**
         * <p>
         * Indicates whether managed instance scaling is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether managed instance scaling is enabled.
         * @see ManagedInstanceScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedInstanceScalingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether managed instance scaling is enabled.
         * </p>
         * 
         * @param status
         *        Indicates whether managed instance scaling is enabled.
         * @see ManagedInstanceScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedInstanceScalingStatus
         */
        Builder status(ManagedInstanceScalingStatus status);

        /**
         * <p>
         * The minimum number of instances that the endpoint must retain when it scales down to accommodate a decrease
         * in traffic.
         * </p>
         * 
         * @param minInstanceCount
         *        The minimum number of instances that the endpoint must retain when it scales down to accommodate a
         *        decrease in traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInstanceCount(Integer minInstanceCount);

        /**
         * <p>
         * The maximum number of instances that the endpoint can provision when it scales up to accommodate an increase
         * in traffic.
         * </p>
         * 
         * @param maxInstanceCount
         *        The maximum number of instances that the endpoint can provision when it scales up to accommodate an
         *        increase in traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInstanceCount(Integer maxInstanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Integer minInstanceCount;

        private Integer maxInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantManagedInstanceScaling model) {
            status(model.status);
            minInstanceCount(model.minInstanceCount);
            maxInstanceCount(model.maxInstanceCount);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedInstanceScalingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMinInstanceCount() {
            return minInstanceCount;
        }

        public final void setMinInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
        }

        @Override
        public final Builder minInstanceCount(Integer minInstanceCount) {
            this.minInstanceCount = minInstanceCount;
            return this;
        }

        public final Integer getMaxInstanceCount() {
            return maxInstanceCount;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        @Override
        public ProductionVariantManagedInstanceScaling build() {
            return new ProductionVariantManagedInstanceScaling(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
