/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a project as returned by the Search API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Project implements SdkPojo, Serializable, ToCopyableBuilder<Project.Builder, Project> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(Project::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(Project::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectId").getter(getter(Project::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectDescription").getter(getter(Project::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build())
            .build();

    private static final SdkField<ServiceCatalogProvisioningDetails> SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD = SdkField
            .<ServiceCatalogProvisioningDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceCatalogProvisioningDetails")
            .getter(getter(Project::serviceCatalogProvisioningDetails))
            .setter(setter(Builder::serviceCatalogProvisioningDetails))
            .constructor(ServiceCatalogProvisioningDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisioningDetails")
                    .build()).build();

    private static final SdkField<ServiceCatalogProvisionedProductDetails> SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD = SdkField
            .<ServiceCatalogProvisionedProductDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceCatalogProvisionedProductDetails")
            .getter(getter(Project::serviceCatalogProvisionedProductDetails))
            .setter(setter(Builder::serviceCatalogProvisionedProductDetails))
            .constructor(ServiceCatalogProvisionedProductDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceCatalogProvisionedProductDetails").build()).build();

    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectStatus").getter(getter(Project::projectStatusAsString)).setter(setter(Builder::projectStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStatus").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(Project::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Project::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Project::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Project::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(Project::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PROJECT_NAME_FIELD, PROJECT_ID_FIELD, PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD,
            SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD, PROJECT_STATUS_FIELD, CREATED_BY_FIELD, CREATION_TIME_FIELD,
            TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProjectArn", PROJECT_ARN_FIELD);
                    put("ProjectName", PROJECT_NAME_FIELD);
                    put("ProjectId", PROJECT_ID_FIELD);
                    put("ProjectDescription", PROJECT_DESCRIPTION_FIELD);
                    put("ServiceCatalogProvisioningDetails", SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD);
                    put("ServiceCatalogProvisionedProductDetails", SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD);
                    put("ProjectStatus", PROJECT_STATUS_FIELD);
                    put("CreatedBy", CREATED_BY_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("Tags", TAGS_FIELD);
                    put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
                    put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String projectArn;

    private final String projectName;

    private final String projectId;

    private final String projectDescription;

    private final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;

    private final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;

    private final String projectStatus;

    private final UserContext createdBy;

    private final Instant creationTime;

    private final List<Tag> tags;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private Project(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.projectId = builder.projectId;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningDetails = builder.serviceCatalogProvisioningDetails;
        this.serviceCatalogProvisionedProductDetails = builder.serviceCatalogProvisionedProductDetails;
        this.projectStatus = builder.projectStatus;
        this.createdBy = builder.createdBy;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The description of the project.
     * </p>
     * 
     * @return The description of the project.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * Returns the value of the ServiceCatalogProvisioningDetails property for this object.
     * 
     * @return The value of the ServiceCatalogProvisioningDetails property for this object.
     */
    public final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails() {
        return serviceCatalogProvisioningDetails;
    }

    /**
     * Returns the value of the ServiceCatalogProvisionedProductDetails property for this object.
     * 
     * @return The value of the ServiceCatalogProvisionedProductDetails property for this object.
     */
    public final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails() {
        return serviceCatalogProvisionedProductDetails;
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(projectStatus);
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final String projectStatusAsString() {
        return projectStatus;
    }

    /**
     * <p>
     * Who created the project.
     * </p>
     * 
     * @return Who created the project.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * A timestamp specifying when the project was created.
     * </p>
     * 
     * @return A timestamp specifying when the project was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A timestamp container for when the project was last modified.
     * </p>
     * 
     * @return A timestamp container for when the project was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCatalogProvisioningDetails());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCatalogProvisionedProductDetails());
        hashCode = 31 * hashCode + Objects.hashCode(projectStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectId(), other.projectId())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(serviceCatalogProvisioningDetails(), other.serviceCatalogProvisioningDetails())
                && Objects.equals(serviceCatalogProvisionedProductDetails(), other.serviceCatalogProvisionedProductDetails())
                && Objects.equals(projectStatusAsString(), other.projectStatusAsString())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(creationTime(), other.creationTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Project").add("ProjectArn", projectArn()).add("ProjectName", projectName())
                .add("ProjectId", projectId()).add("ProjectDescription", projectDescription())
                .add("ServiceCatalogProvisioningDetails", serviceCatalogProvisioningDetails())
                .add("ServiceCatalogProvisionedProductDetails", serviceCatalogProvisionedProductDetails())
                .add("ProjectStatus", projectStatusAsString()).add("CreatedBy", createdBy()).add("CreationTime", creationTime())
                .add("Tags", hasTags() ? tags() : null).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ProjectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "ProjectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "ServiceCatalogProvisioningDetails":
            return Optional.ofNullable(clazz.cast(serviceCatalogProvisioningDetails()));
        case "ServiceCatalogProvisionedProductDetails":
            return Optional.ofNullable(clazz.cast(serviceCatalogProvisionedProductDetails()));
        case "ProjectStatus":
            return Optional.ofNullable(clazz.cast(projectStatusAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Project> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param projectId
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The description of the project.
         * </p>
         * 
         * @param projectDescription
         *        The description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * Sets the value of the ServiceCatalogProvisioningDetails property for this object.
         *
         * @param serviceCatalogProvisioningDetails
         *        The new value for the ServiceCatalogProvisioningDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails);

        /**
         * Sets the value of the ServiceCatalogProvisioningDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ServiceCatalogProvisioningDetails.Builder} avoiding the need to create one manually via
         * {@link ServiceCatalogProvisioningDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCatalogProvisioningDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails)}.
         * 
         * @param serviceCatalogProvisioningDetails
         *        a consumer that will call methods on {@link ServiceCatalogProvisioningDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails)
         */
        default Builder serviceCatalogProvisioningDetails(
                Consumer<ServiceCatalogProvisioningDetails.Builder> serviceCatalogProvisioningDetails) {
            return serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails.builder()
                    .applyMutation(serviceCatalogProvisioningDetails).build());
        }

        /**
         * Sets the value of the ServiceCatalogProvisionedProductDetails property for this object.
         *
         * @param serviceCatalogProvisionedProductDetails
         *        The new value for the ServiceCatalogProvisionedProductDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCatalogProvisionedProductDetails(
                ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails);

        /**
         * Sets the value of the ServiceCatalogProvisionedProductDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ServiceCatalogProvisionedProductDetails.Builder} avoiding the need to create one manually via
         * {@link ServiceCatalogProvisionedProductDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCatalogProvisionedProductDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails)}.
         * 
         * @param serviceCatalogProvisionedProductDetails
         *        a consumer that will call methods on {@link ServiceCatalogProvisionedProductDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails)
         */
        default Builder serviceCatalogProvisionedProductDetails(
                Consumer<ServiceCatalogProvisionedProductDetails.Builder> serviceCatalogProvisionedProductDetails) {
            return serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails.builder()
                    .applyMutation(serviceCatalogProvisionedProductDetails).build());
        }

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(String projectStatus);

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(ProjectStatus projectStatus);

        /**
         * <p>
         * Who created the project.
         * </p>
         * 
         * @param createdBy
         *        Who created the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the project.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * A timestamp specifying when the project was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp specifying when the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A timestamp container for when the project was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp container for when the project was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String projectArn;

        private String projectName;

        private String projectId;

        private String projectDescription;

        private ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;

        private ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;

        private String projectStatus;

        private UserContext createdBy;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            projectArn(model.projectArn);
            projectName(model.projectName);
            projectId(model.projectId);
            projectDescription(model.projectDescription);
            serviceCatalogProvisioningDetails(model.serviceCatalogProvisioningDetails);
            serviceCatalogProvisionedProductDetails(model.serviceCatalogProvisionedProductDetails);
            projectStatus(model.projectStatus);
            createdBy(model.createdBy);
            creationTime(model.creationTime);
            tags(model.tags);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final ServiceCatalogProvisioningDetails.Builder getServiceCatalogProvisioningDetails() {
            return serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisioningDetails(
                ServiceCatalogProvisioningDetails.BuilderImpl serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails
                    .build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails;
            return this;
        }

        public final ServiceCatalogProvisionedProductDetails.Builder getServiceCatalogProvisionedProductDetails() {
            return serviceCatalogProvisionedProductDetails != null ? serviceCatalogProvisionedProductDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisionedProductDetails(
                ServiceCatalogProvisionedProductDetails.BuilderImpl serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails != null ? serviceCatalogProvisionedProductDetails
                    .build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisionedProductDetails(
                ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails;
            return this;
        }

        public final String getProjectStatus() {
            return projectStatus;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public Project build() {
            return new Project(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
