/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProjectSummary.Builder, ProjectSummary> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(ProjectSummary::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectDescription").getter(getter(ProjectSummary::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build())
            .build();

    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(ProjectSummary::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectId").getter(getter(ProjectSummary::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ProjectSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectStatus").getter(getter(ProjectSummary::projectStatusAsString))
            .setter(setter(Builder::projectStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PROJECT_DESCRIPTION_FIELD, PROJECT_ARN_FIELD, PROJECT_ID_FIELD, CREATION_TIME_FIELD, PROJECT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProjectName", PROJECT_NAME_FIELD);
                    put("ProjectDescription", PROJECT_DESCRIPTION_FIELD);
                    put("ProjectArn", PROJECT_ARN_FIELD);
                    put("ProjectId", PROJECT_ID_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                    put("ProjectStatus", PROJECT_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String projectName;

    private final String projectDescription;

    private final String projectArn;

    private final String projectId;

    private final Instant creationTime;

    private final String projectStatus;

    private ProjectSummary(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectArn = builder.projectArn;
        this.projectId = builder.projectId;
        this.creationTime = builder.creationTime;
        this.projectStatus = builder.projectStatus;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The description of the project.
     * </p>
     * 
     * @return The description of the project.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the project.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The time that the project was created.
     * </p>
     * 
     * @return The time that the project was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(projectStatus);
    }

    /**
     * <p>
     * The status of the project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectStatus}
     * will return {@link ProjectStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #projectStatusAsString}.
     * </p>
     * 
     * @return The status of the project.
     * @see ProjectStatus
     */
    public final String projectStatusAsString() {
        return projectStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(projectStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSummary)) {
            return false;
        }
        ProjectSummary other = (ProjectSummary) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(projectArn(), other.projectArn()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(projectStatusAsString(), other.projectStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectSummary").add("ProjectName", projectName())
                .add("ProjectDescription", projectDescription()).add("ProjectArn", projectArn()).add("ProjectId", projectId())
                .add("CreationTime", creationTime()).add("ProjectStatus", projectStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ProjectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "ProjectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ProjectStatus":
            return Optional.ofNullable(clazz.cast(projectStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectSummary, T> g) {
        return obj -> g.apply((ProjectSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectSummary> {
        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The description of the project.
         * </p>
         * 
         * @param projectDescription
         *        The description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param projectId
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The time that the project was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(String projectStatus);

        /**
         * <p>
         * The status of the project.
         * </p>
         * 
         * @param projectStatus
         *        The status of the project.
         * @see ProjectStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectStatus
         */
        Builder projectStatus(ProjectStatus projectStatus);
    }

    static final class BuilderImpl implements Builder {
        private String projectName;

        private String projectDescription;

        private String projectArn;

        private String projectId;

        private Instant creationTime;

        private String projectStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSummary model) {
            projectName(model.projectName);
            projectDescription(model.projectDescription);
            projectArn(model.projectArn);
            projectId(model.projectId);
            creationTime(model.creationTime);
            projectStatus(model.projectStatus);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getProjectStatus() {
            return projectStatus;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        @Override
        public ProjectSummary build() {
            return new ProjectSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
