/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed.
 * </p>
 * <p>
 * Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the
 * complexity of the task; the longer it takes in your initial testing, the more you should offer.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 0.036
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.048
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.060
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.072
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.120
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.240
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.360
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.480
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.600
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.720
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * </ul>
 * <p>
 * Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US
 * dollars.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 0.012
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.024
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.036
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.048
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.060
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.072
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.120
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.240
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.360
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.480
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.600
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.720
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * </ul>
 * <p>
 * Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * </ul>
 * <p>
 * Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks.
 * Prices are in US dollars.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 2.400
 * </p>
 * </li>
 * <li>
 * <p>
 * 2.280
 * </p>
 * </li>
 * <li>
 * <p>
 * 2.160
 * </p>
 * </li>
 * <li>
 * <p>
 * 2.040
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.920
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.800
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.680
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.560
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.440
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.320
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.720
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.600
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.480
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.360
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.240
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.120
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.072
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.060
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.048
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.036
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.024
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.012
 * </p>
 * </li>
 * </ul>
 * <p>
 * Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are
 * in US dollars.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.720
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.600
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.480
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.360
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.240
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.120
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.072
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.060
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.048
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.036
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.024
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.012
 * </p>
 * </li>
 * </ul>
 * <p>
 * Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.
 * </p>
 * <ul>
 * <li>
 * <p>
 * 1.200
 * </p>
 * </li>
 * <li>
 * <p>
 * 1.080
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.960
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.840
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.720
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.600
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.480
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.360
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.240
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.120
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.072
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.060
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.048
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.036
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.024
 * </p>
 * </li>
 * <li>
 * <p>
 * 0.012
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicWorkforceTaskPrice implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicWorkforceTaskPrice.Builder, PublicWorkforceTaskPrice> {
    private static final SdkField<USD> AMOUNT_IN_USD_FIELD = SdkField.<USD> builder(MarshallingType.SDK_POJO)
            .memberName("AmountInUsd").getter(getter(PublicWorkforceTaskPrice::amountInUsd)).setter(setter(Builder::amountInUsd))
            .constructor(USD::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmountInUsd").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_IN_USD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AmountInUsd", AMOUNT_IN_USD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final USD amountInUsd;

    private PublicWorkforceTaskPrice(BuilderImpl builder) {
        this.amountInUsd = builder.amountInUsd;
    }

    /**
     * <p>
     * Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.
     * </p>
     * 
     * @return Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.
     */
    public final USD amountInUsd() {
        return amountInUsd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amountInUsd());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicWorkforceTaskPrice)) {
            return false;
        }
        PublicWorkforceTaskPrice other = (PublicWorkforceTaskPrice) obj;
        return Objects.equals(amountInUsd(), other.amountInUsd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicWorkforceTaskPrice").add("AmountInUsd", amountInUsd()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmountInUsd":
            return Optional.ofNullable(clazz.cast(amountInUsd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublicWorkforceTaskPrice, T> g) {
        return obj -> g.apply((PublicWorkforceTaskPrice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicWorkforceTaskPrice> {
        /**
         * <p>
         * Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.
         * </p>
         * 
         * @param amountInUsd
         *        Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amountInUsd(USD amountInUsd);

        /**
         * <p>
         * Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.
         * </p>
         * This is a convenience method that creates an instance of the {@link USD.Builder} avoiding the need to create
         * one manually via {@link USD#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link USD.Builder#build()} is called immediately and its result is
         * passed to {@link #amountInUsd(USD)}.
         * 
         * @param amountInUsd
         *        a consumer that will call methods on {@link USD.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amountInUsd(USD)
         */
        default Builder amountInUsd(Consumer<USD.Builder> amountInUsd) {
            return amountInUsd(USD.builder().applyMutation(amountInUsd).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private USD amountInUsd;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicWorkforceTaskPrice model) {
            amountInUsd(model.amountInUsd);
        }

        public final USD.Builder getAmountInUsd() {
            return amountInUsd != null ? amountInUsd.toBuilder() : null;
        }

        public final void setAmountInUsd(USD.BuilderImpl amountInUsd) {
            this.amountInUsd = amountInUsd != null ? amountInUsd.build() : null;
        }

        @Override
        public final Builder amountInUsd(USD amountInUsd) {
            this.amountInUsd = amountInUsd;
            return this;
        }

        @Override
        public PublicWorkforceTaskPrice build() {
            return new PublicWorkforceTaskPrice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
