/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of filters to narrow the set of lineage entities connected to the <code>StartArn</code>(s) returned by the
 * <code>QueryLineage</code> API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryFilters implements SdkPojo, Serializable, ToCopyableBuilder<QueryFilters.Builder, QueryFilters> {
    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Types")
            .getter(getter(QueryFilters::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LINEAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LineageTypes")
            .getter(getter(QueryFilters::lineageTypesAsStrings))
            .setter(setter(Builder::lineageTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(QueryFilters::createdBefore)).setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(QueryFilters::createdAfter)).setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> MODIFIED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedBefore").getter(getter(QueryFilters::modifiedBefore)).setter(setter(Builder::modifiedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedBefore").build()).build();

    private static final SdkField<Instant> MODIFIED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAfter").getter(getter(QueryFilters::modifiedAfter)).setter(setter(Builder::modifiedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAfter").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(QueryFilters::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPES_FIELD,
            LINEAGE_TYPES_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, MODIFIED_BEFORE_FIELD, MODIFIED_AFTER_FIELD,
            PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Types", TYPES_FIELD);
                    put("LineageTypes", LINEAGE_TYPES_FIELD);
                    put("CreatedBefore", CREATED_BEFORE_FIELD);
                    put("CreatedAfter", CREATED_AFTER_FIELD);
                    put("ModifiedBefore", MODIFIED_BEFORE_FIELD);
                    put("ModifiedAfter", MODIFIED_AFTER_FIELD);
                    put("Properties", PROPERTIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> types;

    private final List<String> lineageTypes;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private final Instant modifiedBefore;

    private final Instant modifiedAfter;

    private final Map<String, String> properties;

    private QueryFilters(BuilderImpl builder) {
        this.types = builder.types;
        this.lineageTypes = builder.lineageTypes;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.modifiedBefore = builder.modifiedBefore;
        this.modifiedAfter = builder.modifiedAfter;
        this.properties = builder.properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code> by type. For example: <code>DataSet</code>,
     * <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code> by type. For example:
     *         <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
     */
    public final List<String> types() {
        return types;
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineageTypes} method.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
     */
    public final List<LineageType> lineageTypes() {
        return QueryLineageTypesCopier.copyStringToEnum(lineageTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the LineageTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLineageTypes() {
        return lineageTypes != null && !(lineageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineageTypes} method.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
     */
    public final List<String> lineageTypesAsStrings() {
        return lineageTypes;
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) by created date.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) by created date.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) after the create date.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) after the create date.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) before the last modified date.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) before the last modified date.
     */
    public final Instant modifiedBefore() {
        return modifiedBefore;
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) after the last modified date.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) after the last modified date.
     */
    public final Instant modifiedAfter() {
        return modifiedAfter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value pairs. If
     * multiple pairs are provided, an entity is included in the results if it matches any of the provided pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value
     *         pairs. If multiple pairs are provided, an entity is included in the results if it matches any of the
     *         provided pairs.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLineageTypes() ? lineageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryFilters)) {
            return false;
        }
        QueryFilters other = (QueryFilters) obj;
        return hasTypes() == other.hasTypes() && Objects.equals(types(), other.types())
                && hasLineageTypes() == other.hasLineageTypes()
                && Objects.equals(lineageTypesAsStrings(), other.lineageTypesAsStrings())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(modifiedBefore(), other.modifiedBefore())
                && Objects.equals(modifiedAfter(), other.modifiedAfter()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryFilters").add("Types", hasTypes() ? types() : null)
                .add("LineageTypes", hasLineageTypes() ? lineageTypesAsStrings() : null).add("CreatedBefore", createdBefore())
                .add("CreatedAfter", createdAfter()).add("ModifiedBefore", modifiedBefore())
                .add("ModifiedAfter", modifiedAfter()).add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "LineageTypes":
            return Optional.ofNullable(clazz.cast(lineageTypesAsStrings()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "ModifiedBefore":
            return Optional.ofNullable(clazz.cast(modifiedBefore()));
        case "ModifiedAfter":
            return Optional.ofNullable(clazz.cast(modifiedAfter()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryFilters, T> g) {
        return obj -> g.apply((QueryFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryFilters> {
        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code> by type. For example: <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
         * </p>
         * 
         * @param types
         *        Filter the lineage entities connected to the <code>StartArn</code> by type. For example:
         *        <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code> by type. For example: <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
         * </p>
         * 
         * @param types
         *        Filter the lineage entities connected to the <code>StartArn</code> by type. For example:
         *        <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
         * </p>
         * 
         * @param lineageTypes
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageTypesWithStrings(Collection<String> lineageTypes);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
         * </p>
         * 
         * @param lineageTypes
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageTypesWithStrings(String... lineageTypes);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
         * </p>
         * 
         * @param lineageTypes
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageTypes(Collection<LineageType> lineageTypes);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.
         * </p>
         * 
         * @param lineageTypes
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage
         *        entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageTypes(LineageType... lineageTypes);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by created date.
         * </p>
         * 
         * @param createdBefore
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by created date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) after the create date.
         * </p>
         * 
         * @param createdAfter
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) after the create date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) before the last modified date.
         * </p>
         * 
         * @param modifiedBefore
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) before the last modified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedBefore(Instant modifiedBefore);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) after the last modified date.
         * </p>
         * 
         * @param modifiedAfter
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) after the last modified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAfter(Instant modifiedAfter);

        /**
         * <p>
         * Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value pairs.
         * If multiple pairs are provided, an entity is included in the results if it matches any of the provided pairs.
         * </p>
         * 
         * @param properties
         *        Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value
         *        pairs. If multiple pairs are provided, an entity is included in the results if it matches any of the
         *        provided pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);
    }

    static final class BuilderImpl implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private List<String> lineageTypes = DefaultSdkAutoConstructList.getInstance();

        private Instant createdBefore;

        private Instant createdAfter;

        private Instant modifiedBefore;

        private Instant modifiedAfter;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryFilters model) {
            types(model.types);
            lineageTypesWithStrings(model.lineageTypes);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
            modifiedBefore(model.modifiedBefore);
            modifiedAfter(model.modifiedAfter);
            properties(model.properties);
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = QueryTypesCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = QueryTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final Collection<String> getLineageTypes() {
            if (lineageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return lineageTypes;
        }

        public final void setLineageTypes(Collection<String> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copy(lineageTypes);
        }

        @Override
        public final Builder lineageTypesWithStrings(Collection<String> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copy(lineageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageTypesWithStrings(String... lineageTypes) {
            lineageTypesWithStrings(Arrays.asList(lineageTypes));
            return this;
        }

        @Override
        public final Builder lineageTypes(Collection<LineageType> lineageTypes) {
            this.lineageTypes = QueryLineageTypesCopier.copyEnumToString(lineageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageTypes(LineageType... lineageTypes) {
            lineageTypes(Arrays.asList(lineageTypes));
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getModifiedBefore() {
            return modifiedBefore;
        }

        public final void setModifiedBefore(Instant modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
        }

        @Override
        public final Builder modifiedBefore(Instant modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public final Instant getModifiedAfter() {
            return modifiedAfter;
        }

        public final void setModifiedAfter(Instant modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
        }

        @Override
        public final Builder modifiedAfter(Instant modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = QueryPropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = QueryPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        public QueryFilters build() {
            return new QueryFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
