/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryLineageResponse extends SageMakerResponse implements
        ToCopyableBuilder<QueryLineageResponse.Builder, QueryLineageResponse> {
    private static final SdkField<List<Vertex>> VERTICES_FIELD = SdkField
            .<List<Vertex>> builder(MarshallingType.LIST)
            .memberName("Vertices")
            .getter(getter(QueryLineageResponse::vertices))
            .setter(setter(Builder::vertices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vertices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Vertex> builder(MarshallingType.SDK_POJO)
                                            .constructor(Vertex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Edge>> EDGES_FIELD = SdkField
            .<List<Edge>> builder(MarshallingType.LIST)
            .memberName("Edges")
            .getter(getter(QueryLineageResponse::edges))
            .setter(setter(Builder::edges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Edge> builder(MarshallingType.SDK_POJO)
                                            .constructor(Edge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QueryLineageResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERTICES_FIELD, EDGES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Vertices", VERTICES_FIELD);
                    put("Edges", EDGES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<Vertex> vertices;

    private final List<Edge> edges;

    private final String nextToken;

    private QueryLineageResponse(BuilderImpl builder) {
        super(builder);
        this.vertices = builder.vertices;
        this.edges = builder.edges;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Vertices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVertices() {
        return vertices != null && !(vertices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of vertices connected to the start entity(ies) in the lineage graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVertices} method.
     * </p>
     * 
     * @return A list of vertices connected to the start entity(ies) in the lineage graph.
     */
    public final List<Vertex> vertices() {
        return vertices;
    }

    /**
     * For responses, this returns true if the service returned a value for the Edges property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEdges() {
        return edges != null && !(edges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of edges that connect vertices in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdges} method.
     * </p>
     * 
     * @return A list of edges that connect vertices in the response.
     */
    public final List<Edge> edges() {
        return edges;
    }

    /**
     * <p>
     * Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the
     * next page of results.
     * </p>
     * 
     * @return Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to
     *         retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVertices() ? vertices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEdges() ? edges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLineageResponse)) {
            return false;
        }
        QueryLineageResponse other = (QueryLineageResponse) obj;
        return hasVertices() == other.hasVertices() && Objects.equals(vertices(), other.vertices())
                && hasEdges() == other.hasEdges() && Objects.equals(edges(), other.edges())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryLineageResponse").add("Vertices", hasVertices() ? vertices() : null)
                .add("Edges", hasEdges() ? edges() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vertices":
            return Optional.ofNullable(clazz.cast(vertices()));
        case "Edges":
            return Optional.ofNullable(clazz.cast(edges()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryLineageResponse, T> g) {
        return obj -> g.apply((QueryLineageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryLineageResponse> {
        /**
         * <p>
         * A list of vertices connected to the start entity(ies) in the lineage graph.
         * </p>
         * 
         * @param vertices
         *        A list of vertices connected to the start entity(ies) in the lineage graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vertices(Collection<Vertex> vertices);

        /**
         * <p>
         * A list of vertices connected to the start entity(ies) in the lineage graph.
         * </p>
         * 
         * @param vertices
         *        A list of vertices connected to the start entity(ies) in the lineage graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vertices(Vertex... vertices);

        /**
         * <p>
         * A list of vertices connected to the start entity(ies) in the lineage graph.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Vertex.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Vertex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Vertex.Builder#build()} is called immediately and its
         * result is passed to {@link #vertices(List<Vertex>)}.
         * 
         * @param vertices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Vertex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vertices(java.util.Collection<Vertex>)
         */
        Builder vertices(Consumer<Vertex.Builder>... vertices);

        /**
         * <p>
         * A list of edges that connect vertices in the response.
         * </p>
         * 
         * @param edges
         *        A list of edges that connect vertices in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Collection<Edge> edges);

        /**
         * <p>
         * A list of edges that connect vertices in the response.
         * </p>
         * 
         * @param edges
         *        A list of edges that connect vertices in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edges(Edge... edges);

        /**
         * <p>
         * A list of edges that connect vertices in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Edge.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Edge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Edge.Builder#build()} is called immediately and its
         * result is passed to {@link #edges(List<Edge>)}.
         * 
         * @param edges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Edge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edges(java.util.Collection<Edge>)
         */
        Builder edges(Consumer<Edge.Builder>... edges);

        /**
         * <p>
         * Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve
         * the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to
         *        retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Vertex> vertices = DefaultSdkAutoConstructList.getInstance();

        private List<Edge> edges = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLineageResponse model) {
            super(model);
            vertices(model.vertices);
            edges(model.edges);
            nextToken(model.nextToken);
        }

        public final List<Vertex.Builder> getVertices() {
            List<Vertex.Builder> result = VerticesCopier.copyToBuilder(this.vertices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVertices(Collection<Vertex.BuilderImpl> vertices) {
            this.vertices = VerticesCopier.copyFromBuilder(vertices);
        }

        @Override
        public final Builder vertices(Collection<Vertex> vertices) {
            this.vertices = VerticesCopier.copy(vertices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vertices(Vertex... vertices) {
            vertices(Arrays.asList(vertices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vertices(Consumer<Vertex.Builder>... vertices) {
            vertices(Stream.of(vertices).map(c -> Vertex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Edge.Builder> getEdges() {
            List<Edge.Builder> result = EdgesCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<Edge.BuilderImpl> edges) {
            this.edges = EdgesCopier.copyFromBuilder(edges);
        }

        @Override
        public final Builder edges(Collection<Edge> edges) {
            this.edges = EdgesCopier.copy(edges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Edge... edges) {
            edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edges(Consumer<Edge.Builder>... edges) {
            edges(Stream.of(edges).map(c -> Edge.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public QueryLineageResponse build() {
            return new QueryLineageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
