/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the output configuration for the compiled model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobOutputConfig.Builder, RecommendationJobOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RecommendationJobOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<RecommendationJobCompiledOutputConfig> COMPILED_OUTPUT_CONFIG_FIELD = SdkField
            .<RecommendationJobCompiledOutputConfig> builder(MarshallingType.SDK_POJO).memberName("CompiledOutputConfig")
            .getter(getter(RecommendationJobOutputConfig::compiledOutputConfig)).setter(setter(Builder::compiledOutputConfig))
            .constructor(RecommendationJobCompiledOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompiledOutputConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            COMPILED_OUTPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("CompiledOutputConfig", COMPILED_OUTPUT_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final RecommendationJobCompiledOutputConfig compiledOutputConfig;

    private RecommendationJobOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.compiledOutputConfig = builder.compiledOutputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key that
     * Amazon SageMaker uses to encrypt your output artifacts with Amazon S3 server-side encryption. The SageMaker
     * execution role must have <code>kms:GenerateDataKey</code> permission.
     * </p>
     * <p>
     * The <code>KmsKeyId</code> can be any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * // KMS Key ID
     * </p>
     * <p>
     * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // Amazon Resource Name (ARN) of a KMS Key
     * </p>
     * <p>
     * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // KMS Key Alias
     * </p>
     * <p>
     * <code>"alias/ExampleAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // Amazon Resource Name (ARN) of a KMS Key Alias
     * </p>
     * <p>
     * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about key identifiers, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
     * (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS)
     *         key that Amazon SageMaker uses to encrypt your output artifacts with Amazon S3 server-side encryption.
     *         The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.</p>
     *         <p>
     *         The <code>KmsKeyId</code> can be any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         // KMS Key ID
     *         </p>
     *         <p>
     *         <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // Amazon Resource Name (ARN) of a KMS Key
     *         </p>
     *         <p>
     *         <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // KMS Key Alias
     *         </p>
     *         <p>
     *         <code>"alias/ExampleAlias"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // Amazon Resource Name (ARN) of a KMS Key Alias
     *         </p>
     *         <p>
     *         <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about key identifiers, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
     *         (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Provides information about the output configuration for the compiled model.
     * </p>
     * 
     * @return Provides information about the output configuration for the compiled model.
     */
    public final RecommendationJobCompiledOutputConfig compiledOutputConfig() {
        return compiledOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(compiledOutputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobOutputConfig)) {
            return false;
        }
        RecommendationJobOutputConfig other = (RecommendationJobOutputConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(compiledOutputConfig(), other.compiledOutputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobOutputConfig").add("KmsKeyId", kmsKeyId())
                .add("CompiledOutputConfig", compiledOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "CompiledOutputConfig":
            return Optional.ofNullable(clazz.cast(compiledOutputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobOutputConfig, T> g) {
        return obj -> g.apply((RecommendationJobOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobOutputConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services KMS) key
         * that Amazon SageMaker uses to encrypt your output artifacts with Amazon S3 server-side encryption. The
         * SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.
         * </p>
         * <p>
         * The <code>KmsKeyId</code> can be any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * // KMS Key ID
         * </p>
         * <p>
         * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // Amazon Resource Name (ARN) of a KMS Key
         * </p>
         * <p>
         * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // KMS Key Alias
         * </p>
         * <p>
         * <code>"alias/ExampleAlias"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // Amazon Resource Name (ARN) of a KMS Key Alias
         * </p>
         * <p>
         * <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about key identifiers, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key identifiers
         * (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS) documentation.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service (Amazon Web Services
         *        KMS) key that Amazon SageMaker uses to encrypt your output artifacts with Amazon S3 server-side
         *        encryption. The SageMaker execution role must have <code>kms:GenerateDataKey</code> permission.</p>
         *        <p>
         *        The <code>KmsKeyId</code> can be any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        // KMS Key ID
         *        </p>
         *        <p>
         *        <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // Amazon Resource Name (ARN) of a KMS Key
         *        </p>
         *        <p>
         *        <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:key/&lt;key-id-12ab-34cd-56ef-1234567890ab&gt;"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // KMS Key Alias
         *        </p>
         *        <p>
         *        <code>"alias/ExampleAlias"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // Amazon Resource Name (ARN) of a KMS Key Alias
         *        </p>
         *        <p>
         *        <code>"arn:aws:kms:&lt;region&gt;:&lt;account&gt;:alias/&lt;ExampleAlias&gt;"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about key identifiers, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key
         *        identifiers (KeyID)</a> in the Amazon Web Services Key Management Service (Amazon Web Services KMS)
         *        documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Provides information about the output configuration for the compiled model.
         * </p>
         * 
         * @param compiledOutputConfig
         *        Provides information about the output configuration for the compiled model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compiledOutputConfig(RecommendationJobCompiledOutputConfig compiledOutputConfig);

        /**
         * <p>
         * Provides information about the output configuration for the compiled model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationJobCompiledOutputConfig.Builder} avoiding the need to create one manually via
         * {@link RecommendationJobCompiledOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationJobCompiledOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #compiledOutputConfig(RecommendationJobCompiledOutputConfig)}.
         * 
         * @param compiledOutputConfig
         *        a consumer that will call methods on {@link RecommendationJobCompiledOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compiledOutputConfig(RecommendationJobCompiledOutputConfig)
         */
        default Builder compiledOutputConfig(Consumer<RecommendationJobCompiledOutputConfig.Builder> compiledOutputConfig) {
            return compiledOutputConfig(RecommendationJobCompiledOutputConfig.builder().applyMutation(compiledOutputConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private RecommendationJobCompiledOutputConfig compiledOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobOutputConfig model) {
            kmsKeyId(model.kmsKeyId);
            compiledOutputConfig(model.compiledOutputConfig);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final RecommendationJobCompiledOutputConfig.Builder getCompiledOutputConfig() {
            return compiledOutputConfig != null ? compiledOutputConfig.toBuilder() : null;
        }

        public final void setCompiledOutputConfig(RecommendationJobCompiledOutputConfig.BuilderImpl compiledOutputConfig) {
            this.compiledOutputConfig = compiledOutputConfig != null ? compiledOutputConfig.build() : null;
        }

        @Override
        public final Builder compiledOutputConfig(RecommendationJobCompiledOutputConfig compiledOutputConfig) {
            this.compiledOutputConfig = compiledOutputConfig;
            return this;
        }

        @Override
        public RecommendationJobOutputConfig build() {
            return new RecommendationJobOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
