/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for remote debugging for the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a>
 * API. To learn more about the remote debugging functionality of SageMaker, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html">Access a training container
 * through Amazon Web Services Systems Manager (SSM) for remote debugging</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteDebugConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteDebugConfig.Builder, RemoteDebugConfig> {
    private static final SdkField<Boolean> ENABLE_REMOTE_DEBUG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableRemoteDebug").getter(getter(RemoteDebugConfig::enableRemoteDebug))
            .setter(setter(Builder::enableRemoteDebug))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableRemoteDebug").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_REMOTE_DEBUG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("EnableRemoteDebug", ENABLE_REMOTE_DEBUG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enableRemoteDebug;

    private RemoteDebugConfig(BuilderImpl builder) {
        this.enableRemoteDebug = builder.enableRemoteDebug;
    }

    /**
     * <p>
     * If set to True, enables remote debugging.
     * </p>
     * 
     * @return If set to True, enables remote debugging.
     */
    public final Boolean enableRemoteDebug() {
        return enableRemoteDebug;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableRemoteDebug());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteDebugConfig)) {
            return false;
        }
        RemoteDebugConfig other = (RemoteDebugConfig) obj;
        return Objects.equals(enableRemoteDebug(), other.enableRemoteDebug());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoteDebugConfig").add("EnableRemoteDebug", enableRemoteDebug()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableRemoteDebug":
            return Optional.ofNullable(clazz.cast(enableRemoteDebug()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoteDebugConfig, T> g) {
        return obj -> g.apply((RemoteDebugConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteDebugConfig> {
        /**
         * <p>
         * If set to True, enables remote debugging.
         * </p>
         * 
         * @param enableRemoteDebug
         *        If set to True, enables remote debugging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableRemoteDebug(Boolean enableRemoteDebug);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableRemoteDebug;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteDebugConfig model) {
            enableRemoteDebug(model.enableRemoteDebug);
        }

        public final Boolean getEnableRemoteDebug() {
            return enableRemoteDebug;
        }

        public final void setEnableRemoteDebug(Boolean enableRemoteDebug) {
            this.enableRemoteDebug = enableRemoteDebug;
        }

        @Override
        public final Builder enableRemoteDebug(Boolean enableRemoteDebug) {
            this.enableRemoteDebug = enableRemoteDebug;
            return this;
        }

        @Override
        public RemoteDebugConfig build() {
            return new RemoteDebugConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
