/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource catalog containing all of the resources of a specific resource type within a resource owner account. For
 * an example on sharing the Amazon SageMaker Feature Store <code>DefaultFeatureGroupCatalog</code>, see <a href=
 * "https://docs.aws.amazon.com/sagemaker/latest/APIReference/feature-store-cross-account-discoverability-share-sagemaker-catalog.html"
 * >Share Amazon SageMaker Catalog resource type</a> in the Amazon SageMaker Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCatalog implements SdkPojo, Serializable, ToCopyableBuilder<ResourceCatalog.Builder, ResourceCatalog> {
    private static final SdkField<String> RESOURCE_CATALOG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceCatalogArn").getter(getter(ResourceCatalog::resourceCatalogArn))
            .setter(setter(Builder::resourceCatalogArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCatalogArn").build())
            .build();

    private static final SdkField<String> RESOURCE_CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceCatalogName").getter(getter(ResourceCatalog::resourceCatalogName))
            .setter(setter(Builder::resourceCatalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCatalogName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ResourceCatalog::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ResourceCatalog::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_CATALOG_ARN_FIELD,
            RESOURCE_CATALOG_NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ResourceCatalogArn", RESOURCE_CATALOG_ARN_FIELD);
                    put("ResourceCatalogName", RESOURCE_CATALOG_NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("CreationTime", CREATION_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String resourceCatalogArn;

    private final String resourceCatalogName;

    private final String description;

    private final Instant creationTime;

    private ResourceCatalog(BuilderImpl builder) {
        this.resourceCatalogArn = builder.resourceCatalogArn;
        this.resourceCatalogName = builder.resourceCatalogName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ResourceCatalog</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ResourceCatalog</code>.
     */
    public final String resourceCatalogArn() {
        return resourceCatalogArn;
    }

    /**
     * <p>
     * The name of the <code>ResourceCatalog</code>.
     * </p>
     * 
     * @return The name of the <code>ResourceCatalog</code>.
     */
    public final String resourceCatalogName() {
        return resourceCatalogName;
    }

    /**
     * <p>
     * A free form description of the <code>ResourceCatalog</code>.
     * </p>
     * 
     * @return A free form description of the <code>ResourceCatalog</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time the <code>ResourceCatalog</code> was created.
     * </p>
     * 
     * @return The time the <code>ResourceCatalog</code> was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceCatalogArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCatalogName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCatalog)) {
            return false;
        }
        ResourceCatalog other = (ResourceCatalog) obj;
        return Objects.equals(resourceCatalogArn(), other.resourceCatalogArn())
                && Objects.equals(resourceCatalogName(), other.resourceCatalogName())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCatalog").add("ResourceCatalogArn", resourceCatalogArn())
                .add("ResourceCatalogName", resourceCatalogName()).add("Description", description())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceCatalogArn":
            return Optional.ofNullable(clazz.cast(resourceCatalogArn()));
        case "ResourceCatalogName":
            return Optional.ofNullable(clazz.cast(resourceCatalogName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCatalog, T> g) {
        return obj -> g.apply((ResourceCatalog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCatalog> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ResourceCatalog</code>.
         * </p>
         * 
         * @param resourceCatalogArn
         *        The Amazon Resource Name (ARN) of the <code>ResourceCatalog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCatalogArn(String resourceCatalogArn);

        /**
         * <p>
         * The name of the <code>ResourceCatalog</code>.
         * </p>
         * 
         * @param resourceCatalogName
         *        The name of the <code>ResourceCatalog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCatalogName(String resourceCatalogName);

        /**
         * <p>
         * A free form description of the <code>ResourceCatalog</code>.
         * </p>
         * 
         * @param description
         *        A free form description of the <code>ResourceCatalog</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time the <code>ResourceCatalog</code> was created.
         * </p>
         * 
         * @param creationTime
         *        The time the <code>ResourceCatalog</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String resourceCatalogArn;

        private String resourceCatalogName;

        private String description;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCatalog model) {
            resourceCatalogArn(model.resourceCatalogArn);
            resourceCatalogName(model.resourceCatalogName);
            description(model.description);
            creationTime(model.creationTime);
        }

        public final String getResourceCatalogArn() {
            return resourceCatalogArn;
        }

        public final void setResourceCatalogArn(String resourceCatalogArn) {
            this.resourceCatalogArn = resourceCatalogArn;
        }

        @Override
        public final Builder resourceCatalogArn(String resourceCatalogArn) {
            this.resourceCatalogArn = resourceCatalogArn;
            return this;
        }

        public final String getResourceCatalogName() {
            return resourceCatalogName;
        }

        public final void setResourceCatalogName(String resourceCatalogName) {
            this.resourceCatalogName = resourceCatalogName;
        }

        @Override
        public final Builder resourceCatalogName(String resourceCatalogName) {
            this.resourceCatalogName = resourceCatalogName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public ResourceCatalog build() {
            return new ResourceCatalog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
