/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ResourceConfig</code> to update <code>KeepAlivePeriodInSeconds</code>. Other fields in the
 * <code>ResourceConfig</code> cannot be updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfigForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceConfigForUpdate.Builder, ResourceConfigForUpdate> {
    private static final SdkField<Integer> KEEP_ALIVE_PERIOD_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("KeepAlivePeriodInSeconds")
            .getter(getter(ResourceConfigForUpdate::keepAlivePeriodInSeconds)).setter(setter(Builder::keepAlivePeriodInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepAlivePeriodInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KEEP_ALIVE_PERIOD_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("KeepAlivePeriodInSeconds", KEEP_ALIVE_PERIOD_IN_SECONDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer keepAlivePeriodInSeconds;

    private ResourceConfigForUpdate(BuilderImpl builder) {
        this.keepAlivePeriodInSeconds = builder.keepAlivePeriodInSeconds;
    }

    /**
     * <p>
     * The <code>KeepAlivePeriodInSeconds</code> value specified in the <code>ResourceConfig</code> to update.
     * </p>
     * 
     * @return The <code>KeepAlivePeriodInSeconds</code> value specified in the <code>ResourceConfig</code> to update.
     */
    public final Integer keepAlivePeriodInSeconds() {
        return keepAlivePeriodInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keepAlivePeriodInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigForUpdate)) {
            return false;
        }
        ResourceConfigForUpdate other = (ResourceConfigForUpdate) obj;
        return Objects.equals(keepAlivePeriodInSeconds(), other.keepAlivePeriodInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceConfigForUpdate").add("KeepAlivePeriodInSeconds", keepAlivePeriodInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeepAlivePeriodInSeconds":
            return Optional.ofNullable(clazz.cast(keepAlivePeriodInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigForUpdate, T> g) {
        return obj -> g.apply((ResourceConfigForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfigForUpdate> {
        /**
         * <p>
         * The <code>KeepAlivePeriodInSeconds</code> value specified in the <code>ResourceConfig</code> to update.
         * </p>
         * 
         * @param keepAlivePeriodInSeconds
         *        The <code>KeepAlivePeriodInSeconds</code> value specified in the <code>ResourceConfig</code> to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer keepAlivePeriodInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigForUpdate model) {
            keepAlivePeriodInSeconds(model.keepAlivePeriodInSeconds);
        }

        public final Integer getKeepAlivePeriodInSeconds() {
            return keepAlivePeriodInSeconds;
        }

        public final void setKeepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
        }

        @Override
        public final Builder keepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
            this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
            return this;
        }

        @Override
        public ResourceConfigForUpdate build() {
            return new ResourceConfigForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
