/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTrainingPlanOfferingsResponse extends SageMakerResponse implements
        ToCopyableBuilder<SearchTrainingPlanOfferingsResponse.Builder, SearchTrainingPlanOfferingsResponse> {
    private static final SdkField<List<TrainingPlanOffering>> TRAINING_PLAN_OFFERINGS_FIELD = SdkField
            .<List<TrainingPlanOffering>> builder(MarshallingType.LIST)
            .memberName("TrainingPlanOfferings")
            .getter(getter(SearchTrainingPlanOfferingsResponse::trainingPlanOfferings))
            .setter(setter(Builder::trainingPlanOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainingPlanOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainingPlanOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TRAINING_PLAN_OFFERINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TrainingPlanOfferings", TRAINING_PLAN_OFFERINGS_FIELD);
                }
            });

    private final List<TrainingPlanOffering> trainingPlanOfferings;

    private SearchTrainingPlanOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.trainingPlanOfferings = builder.trainingPlanOfferings;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingPlanOfferings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrainingPlanOfferings() {
        return trainingPlanOfferings != null && !(trainingPlanOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of training plan offerings that match the search criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingPlanOfferings} method.
     * </p>
     * 
     * @return A list of training plan offerings that match the search criteria.
     */
    public final List<TrainingPlanOffering> trainingPlanOfferings() {
        return trainingPlanOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingPlanOfferings() ? trainingPlanOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTrainingPlanOfferingsResponse)) {
            return false;
        }
        SearchTrainingPlanOfferingsResponse other = (SearchTrainingPlanOfferingsResponse) obj;
        return hasTrainingPlanOfferings() == other.hasTrainingPlanOfferings()
                && Objects.equals(trainingPlanOfferings(), other.trainingPlanOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTrainingPlanOfferingsResponse")
                .add("TrainingPlanOfferings", hasTrainingPlanOfferings() ? trainingPlanOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingPlanOfferings":
            return Optional.ofNullable(clazz.cast(trainingPlanOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTrainingPlanOfferingsResponse, T> g) {
        return obj -> g.apply((SearchTrainingPlanOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchTrainingPlanOfferingsResponse> {
        /**
         * <p>
         * A list of training plan offerings that match the search criteria.
         * </p>
         * 
         * @param trainingPlanOfferings
         *        A list of training plan offerings that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanOfferings(Collection<TrainingPlanOffering> trainingPlanOfferings);

        /**
         * <p>
         * A list of training plan offerings that match the search criteria.
         * </p>
         * 
         * @param trainingPlanOfferings
         *        A list of training plan offerings that match the search criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanOfferings(TrainingPlanOffering... trainingPlanOfferings);

        /**
         * <p>
         * A list of training plan offerings that match the search criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanOffering.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanOffering.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingPlanOfferings(List<TrainingPlanOffering>)}.
         * 
         * @param trainingPlanOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.TrainingPlanOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingPlanOfferings(java.util.Collection<TrainingPlanOffering>)
         */
        Builder trainingPlanOfferings(Consumer<TrainingPlanOffering.Builder>... trainingPlanOfferings);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TrainingPlanOffering> trainingPlanOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTrainingPlanOfferingsResponse model) {
            super(model);
            trainingPlanOfferings(model.trainingPlanOfferings);
        }

        public final List<TrainingPlanOffering.Builder> getTrainingPlanOfferings() {
            List<TrainingPlanOffering.Builder> result = TrainingPlanOfferingsCopier.copyToBuilder(this.trainingPlanOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingPlanOfferings(Collection<TrainingPlanOffering.BuilderImpl> trainingPlanOfferings) {
            this.trainingPlanOfferings = TrainingPlanOfferingsCopier.copyFromBuilder(trainingPlanOfferings);
        }

        @Override
        public final Builder trainingPlanOfferings(Collection<TrainingPlanOffering> trainingPlanOfferings) {
            this.trainingPlanOfferings = TrainingPlanOfferingsCopier.copy(trainingPlanOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanOfferings(TrainingPlanOffering... trainingPlanOfferings) {
            trainingPlanOfferings(Arrays.asList(trainingPlanOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanOfferings(Consumer<TrainingPlanOffering.Builder>... trainingPlanOfferings) {
            trainingPlanOfferings(Stream.of(trainingPlanOfferings)
                    .map(c -> TrainingPlanOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchTrainingPlanOfferingsResponse build() {
            return new SearchTrainingPlanOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
