/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a provisioned service catalog product. For information about service catalog, see <a
 * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services
 * Service Catalog</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceCatalogProvisionedProductDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceCatalogProvisionedProductDetails.Builder, ServiceCatalogProvisionedProductDetails> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId").getter(getter(ServiceCatalogProvisionedProductDetails::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<String> PROVISIONED_PRODUCT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductStatusMessage")
            .getter(getter(ServiceCatalogProvisionedProductDetails::provisionedProductStatusMessage))
            .setter(setter(Builder::provisionedProductStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductStatusMessage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD,
            PROVISIONED_PRODUCT_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProvisionedProductId", PROVISIONED_PRODUCT_ID_FIELD);
                    put("ProvisionedProductStatusMessage", PROVISIONED_PRODUCT_STATUS_MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String provisionedProductId;

    private final String provisionedProductStatusMessage;

    private ServiceCatalogProvisionedProductDetails(BuilderImpl builder) {
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductStatusMessage = builder.provisionedProductStatusMessage;
    }

    /**
     * <p>
     * The ID of the provisioned product.
     * </p>
     * 
     * @return The ID of the provisioned product.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * The current status of the product.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and
     * completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
     * AVAILABLE status before performing operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
     * operation but is not exactly what was requested. For example, a request to update to a new version failed and the
     * stack rolled back to the current version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
     * For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
     * but resources have not yet been created. After reviewing the list of resources to be created, execute the plan.
     * Wait for an AVAILABLE status before performing operations.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the product.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
     *         succeeded and completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for
     *         an AVAILABLE status before performing operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
     *         requested operation but is not exactly what was requested. For example, a request to update to a new
     *         version failed and the stack rolled back to the current version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
     *         running. For example, CloudFormation received a parameter value that was not valid and could not launch
     *         the stack.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
     *         product, but resources have not yet been created. After reviewing the list of resources to be created,
     *         execute the plan. Wait for an AVAILABLE status before performing operations.
     *         </p>
     *         </li>
     */
    public final String provisionedProductStatusMessage() {
        return provisionedProductStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCatalogProvisionedProductDetails)) {
            return false;
        }
        ServiceCatalogProvisionedProductDetails other = (ServiceCatalogProvisionedProductDetails) obj;
        return Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(provisionedProductStatusMessage(), other.provisionedProductStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceCatalogProvisionedProductDetails").add("ProvisionedProductId", provisionedProductId())
                .add("ProvisionedProductStatusMessage", provisionedProductStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ProvisionedProductStatusMessage":
            return Optional.ofNullable(clazz.cast(provisionedProductStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCatalogProvisionedProductDetails, T> g) {
        return obj -> g.apply((ServiceCatalogProvisionedProductDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceCatalogProvisionedProductDetails> {
        /**
         * <p>
         * The ID of the provisioned product.
         * </p>
         * 
         * @param provisionedProductId
         *        The ID of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * The current status of the product.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded
         * and completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
         * AVAILABLE status before performing operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
         * operation but is not exactly what was requested. For example, a request to update to a new version failed and
         * the stack rolled back to the current version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         * running. For example, CloudFormation received a parameter value that was not valid and could not launch the
         * stack.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
         * product, but resources have not yet been created. After reviewing the list of resources to be created,
         * execute the plan. Wait for an AVAILABLE status before performing operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param provisionedProductStatusMessage
         *        The current status of the product.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
         *        succeeded and completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait
         *        for an AVAILABLE status before performing operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
         *        requested operation but is not exactly what was requested. For example, a request to update to a new
         *        version failed and the stack rolled back to the current version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         *        running. For example, CloudFormation received a parameter value that was not valid and could not
         *        launch the stack.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a
         *        new product, but resources have not yet been created. After reviewing the list of resources to be
         *        created, execute the plan. Wait for an AVAILABLE status before performing operations.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductStatusMessage(String provisionedProductStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String provisionedProductId;

        private String provisionedProductStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCatalogProvisionedProductDetails model) {
            provisionedProductId(model.provisionedProductId);
            provisionedProductStatusMessage(model.provisionedProductStatusMessage);
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final String getProvisionedProductStatusMessage() {
            return provisionedProductStatusMessage;
        }

        public final void setProvisionedProductStatusMessage(String provisionedProductStatusMessage) {
            this.provisionedProductStatusMessage = provisionedProductStatusMessage;
        }

        @Override
        public final Builder provisionedProductStatusMessage(String provisionedProductStatusMessage) {
            this.provisionedProductStatusMessage = provisionedProductStatusMessage;
            return this;
        }

        @Override
        public ServiceCatalogProvisionedProductDetails build() {
            return new ServiceCatalogProvisionedProductDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
