/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details that you specify to provision a service catalog product. For information about service catalog, see <a
 * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services
 * Service Catalog</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceCatalogProvisioningUpdateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceCatalogProvisioningUpdateDetails.Builder, ServiceCatalogProvisioningUpdateDetails> {
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(ServiceCatalogProvisioningUpdateDetails::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningParameters")
            .getter(getter(ServiceCatalogProvisioningUpdateDetails::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
                    put("ProvisioningParameters", PROVISIONING_PARAMETERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String provisioningArtifactId;

    private final List<ProvisioningParameter> provisioningParameters;

    private ServiceCatalogProvisioningUpdateDetails(BuilderImpl builder) {
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningParameters = builder.provisioningParameters;
    }

    /**
     * <p>
     * The ID of the provisioning artifact.
     * </p>
     * 
     * @return The ID of the provisioning artifact.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key value pairs that you specify when you provision a product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningParameters} method.
     * </p>
     * 
     * @return A list of key value pairs that you specify when you provision a product.
     */
    public final List<ProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningParameters() ? provisioningParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCatalogProvisioningUpdateDetails)) {
            return false;
        }
        ServiceCatalogProvisioningUpdateDetails other = (ServiceCatalogProvisioningUpdateDetails) obj;
        return Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && hasProvisioningParameters() == other.hasProvisioningParameters()
                && Objects.equals(provisioningParameters(), other.provisioningParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceCatalogProvisioningUpdateDetails")
                .add("ProvisioningArtifactId", provisioningArtifactId())
                .add("ProvisioningParameters", hasProvisioningParameters() ? provisioningParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCatalogProvisioningUpdateDetails, T> g) {
        return obj -> g.apply((ServiceCatalogProvisioningUpdateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceCatalogProvisioningUpdateDetails> {
        /**
         * <p>
         * The ID of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The ID of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * 
         * @param provisioningParameters
         *        A list of key value pairs that you specify when you provision a product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * 
         * @param provisioningParameters
         *        A list of key value pairs that you specify when you provision a product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(ProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningParameters(List<ProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(java.util.Collection<ProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters);
    }

    static final class BuilderImpl implements Builder {
        private String provisioningArtifactId;

        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCatalogProvisioningUpdateDetails model) {
            provisioningArtifactId(model.provisioningArtifactId);
            provisioningParameters(model.provisioningParameters);
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> ProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceCatalogProvisioningUpdateDetails build() {
            return new ServiceCatalogProvisioningUpdateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
