/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the traffic pattern of the load test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficPattern implements SdkPojo, Serializable, ToCopyableBuilder<TrafficPattern.Builder, TrafficPattern> {
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficType").getter(getter(TrafficPattern::trafficTypeAsString)).setter(setter(Builder::trafficType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()).build();

    private static final SdkField<List<Phase>> PHASES_FIELD = SdkField
            .<List<Phase>> builder(MarshallingType.LIST)
            .memberName("Phases")
            .getter(getter(TrafficPattern::phases))
            .setter(setter(Builder::phases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Phase> builder(MarshallingType.SDK_POJO)
                                            .constructor(Phase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Stairs> STAIRS_FIELD = SdkField.<Stairs> builder(MarshallingType.SDK_POJO).memberName("Stairs")
            .getter(getter(TrafficPattern::stairs)).setter(setter(Builder::stairs)).constructor(Stairs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stairs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_TYPE_FIELD,
            PHASES_FIELD, STAIRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TrafficType", TRAFFIC_TYPE_FIELD);
                    put("Phases", PHASES_FIELD);
                    put("Stairs", STAIRS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String trafficType;

    private final List<Phase> phases;

    private final Stairs stairs;

    private TrafficPattern(BuilderImpl builder) {
        this.trafficType = builder.trafficType;
        this.phases = builder.phases;
        this.stairs = builder.stairs;
    }

    /**
     * <p>
     * Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
     * @see TrafficType
     */
    public final TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
     * @see TrafficType
     */
    public final String trafficTypeAsString() {
        return trafficType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPhases() {
        return phases != null && !(phases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the phases traffic specification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhases} method.
     * </p>
     * 
     * @return Defines the phases traffic specification.
     */
    public final List<Phase> phases() {
        return phases;
    }

    /**
     * <p>
     * Defines the stairs traffic pattern.
     * </p>
     * 
     * @return Defines the stairs traffic pattern.
     */
    public final Stairs stairs() {
        return stairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhases() ? phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stairs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPattern)) {
            return false;
        }
        TrafficPattern other = (TrafficPattern) obj;
        return Objects.equals(trafficTypeAsString(), other.trafficTypeAsString()) && hasPhases() == other.hasPhases()
                && Objects.equals(phases(), other.phases()) && Objects.equals(stairs(), other.stairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficPattern").add("TrafficType", trafficTypeAsString())
                .add("Phases", hasPhases() ? phases() : null).add("Stairs", stairs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficType":
            return Optional.ofNullable(clazz.cast(trafficTypeAsString()));
        case "Phases":
            return Optional.ofNullable(clazz.cast(phases()));
        case "Stairs":
            return Optional.ofNullable(clazz.cast(stairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrafficPattern, T> g) {
        return obj -> g.apply((TrafficPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficPattern> {
        /**
         * <p>
         * Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
         * </p>
         * 
         * @param trafficType
         *        Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
         * </p>
         * 
         * @param trafficType
         *        Defines the traffic patterns. Choose either <code>PHASES</code> or <code>STAIRS</code>.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);

        /**
         * <p>
         * Defines the phases traffic specification.
         * </p>
         * 
         * @param phases
         *        Defines the phases traffic specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phases(Collection<Phase> phases);

        /**
         * <p>
         * Defines the phases traffic specification.
         * </p>
         * 
         * @param phases
         *        Defines the phases traffic specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phases(Phase... phases);

        /**
         * <p>
         * Defines the phases traffic specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Phase.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.Phase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Phase.Builder#build()} is called immediately and its
         * result is passed to {@link #phases(List<Phase>)}.
         * 
         * @param phases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Phase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phases(java.util.Collection<Phase>)
         */
        Builder phases(Consumer<Phase.Builder>... phases);

        /**
         * <p>
         * Defines the stairs traffic pattern.
         * </p>
         * 
         * @param stairs
         *        Defines the stairs traffic pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stairs(Stairs stairs);

        /**
         * <p>
         * Defines the stairs traffic pattern.
         * </p>
         * This is a convenience method that creates an instance of the {@link Stairs.Builder} avoiding the need to
         * create one manually via {@link Stairs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Stairs.Builder#build()} is called immediately and its result is
         * passed to {@link #stairs(Stairs)}.
         * 
         * @param stairs
         *        a consumer that will call methods on {@link Stairs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stairs(Stairs)
         */
        default Builder stairs(Consumer<Stairs.Builder> stairs) {
            return stairs(Stairs.builder().applyMutation(stairs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String trafficType;

        private List<Phase> phases = DefaultSdkAutoConstructList.getInstance();

        private Stairs stairs;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPattern model) {
            trafficType(model.trafficType);
            phases(model.phases);
            stairs(model.stairs);
        }

        public final String getTrafficType() {
            return trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final List<Phase.Builder> getPhases() {
            List<Phase.Builder> result = PhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<Phase.BuilderImpl> phases) {
            this.phases = PhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<Phase> phases) {
            this.phases = PhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Phase... phases) {
            phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<Phase.Builder>... phases) {
            phases(Stream.of(phases).map(c -> Phase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Stairs.Builder getStairs() {
            return stairs != null ? stairs.toBuilder() : null;
        }

        public final void setStairs(Stairs.BuilderImpl stairs) {
            this.stairs = stairs != null ? stairs.build() : null;
        }

        @Override
        public final Builder stairs(Stairs stairs) {
            this.stairs = stairs;
            return this;
        }

        @Override
        public TrafficPattern build() {
            return new TrafficPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
