/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing authentication information for a private Docker registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingRepositoryAuthConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingRepositoryAuthConfig.Builder, TrainingRepositoryAuthConfig> {
    private static final SdkField<String> TRAINING_REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrainingRepositoryCredentialsProviderArn")
            .getter(getter(TrainingRepositoryAuthConfig::trainingRepositoryCredentialsProviderArn))
            .setter(setter(Builder::trainingRepositoryCredentialsProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TrainingRepositoryCredentialsProviderArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRAINING_REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TrainingRepositoryCredentialsProviderArn", TRAINING_REPOSITORY_CREDENTIALS_PROVIDER_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String trainingRepositoryCredentialsProviderArn;

    private TrainingRepositoryAuthConfig(BuilderImpl builder) {
        this.trainingRepositoryCredentialsProviderArn = builder.trainingRepositoryCredentialsProviderArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function used to give SageMaker access
     * credentials to your private Docker registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function used to give SageMaker access
     *         credentials to your private Docker registry.
     */
    public final String trainingRepositoryCredentialsProviderArn() {
        return trainingRepositoryCredentialsProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingRepositoryCredentialsProviderArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingRepositoryAuthConfig)) {
            return false;
        }
        TrainingRepositoryAuthConfig other = (TrainingRepositoryAuthConfig) obj;
        return Objects.equals(trainingRepositoryCredentialsProviderArn(), other.trainingRepositoryCredentialsProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingRepositoryAuthConfig")
                .add("TrainingRepositoryCredentialsProviderArn", trainingRepositoryCredentialsProviderArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingRepositoryCredentialsProviderArn":
            return Optional.ofNullable(clazz.cast(trainingRepositoryCredentialsProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrainingRepositoryAuthConfig, T> g) {
        return obj -> g.apply((TrainingRepositoryAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingRepositoryAuthConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function used to give SageMaker access
         * credentials to your private Docker registry.
         * </p>
         * 
         * @param trainingRepositoryCredentialsProviderArn
         *        The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function used to give SageMaker access
         *        credentials to your private Docker registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingRepositoryCredentialsProviderArn(String trainingRepositoryCredentialsProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String trainingRepositoryCredentialsProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingRepositoryAuthConfig model) {
            trainingRepositoryCredentialsProviderArn(model.trainingRepositoryCredentialsProviderArn);
        }

        public final String getTrainingRepositoryCredentialsProviderArn() {
            return trainingRepositoryCredentialsProviderArn;
        }

        public final void setTrainingRepositoryCredentialsProviderArn(String trainingRepositoryCredentialsProviderArn) {
            this.trainingRepositoryCredentialsProviderArn = trainingRepositoryCredentialsProviderArn;
        }

        @Override
        public final Builder trainingRepositoryCredentialsProviderArn(String trainingRepositoryCredentialsProviderArn) {
            this.trainingRepositoryCredentialsProviderArn = trainingRepositoryCredentialsProviderArn;
            return this;
        }

        @Override
        public TrainingRepositoryAuthConfig build() {
            return new TrainingRepositoryAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
