/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TransformInstanceType {
    ML_M4_XLARGE("ml.m4.xlarge"),

    ML_M4_2_XLARGE("ml.m4.2xlarge"),

    ML_M4_4_XLARGE("ml.m4.4xlarge"),

    ML_M4_10_XLARGE("ml.m4.10xlarge"),

    ML_M4_16_XLARGE("ml.m4.16xlarge"),

    ML_C4_XLARGE("ml.c4.xlarge"),

    ML_C4_2_XLARGE("ml.c4.2xlarge"),

    ML_C4_4_XLARGE("ml.c4.4xlarge"),

    ML_C4_8_XLARGE("ml.c4.8xlarge"),

    ML_P2_XLARGE("ml.p2.xlarge"),

    ML_P2_8_XLARGE("ml.p2.8xlarge"),

    ML_P2_16_XLARGE("ml.p2.16xlarge"),

    ML_P3_2_XLARGE("ml.p3.2xlarge"),

    ML_P3_8_XLARGE("ml.p3.8xlarge"),

    ML_P3_16_XLARGE("ml.p3.16xlarge"),

    ML_C5_XLARGE("ml.c5.xlarge"),

    ML_C5_2_XLARGE("ml.c5.2xlarge"),

    ML_C5_4_XLARGE("ml.c5.4xlarge"),

    ML_C5_9_XLARGE("ml.c5.9xlarge"),

    ML_C5_18_XLARGE("ml.c5.18xlarge"),

    ML_M5_LARGE("ml.m5.large"),

    ML_M5_XLARGE("ml.m5.xlarge"),

    ML_M5_2_XLARGE("ml.m5.2xlarge"),

    ML_M5_4_XLARGE("ml.m5.4xlarge"),

    ML_M5_12_XLARGE("ml.m5.12xlarge"),

    ML_M5_24_XLARGE("ml.m5.24xlarge"),

    ML_M6_I_LARGE("ml.m6i.large"),

    ML_M6_I_XLARGE("ml.m6i.xlarge"),

    ML_M6_I_2_XLARGE("ml.m6i.2xlarge"),

    ML_M6_I_4_XLARGE("ml.m6i.4xlarge"),

    ML_M6_I_8_XLARGE("ml.m6i.8xlarge"),

    ML_M6_I_12_XLARGE("ml.m6i.12xlarge"),

    ML_M6_I_16_XLARGE("ml.m6i.16xlarge"),

    ML_M6_I_24_XLARGE("ml.m6i.24xlarge"),

    ML_M6_I_32_XLARGE("ml.m6i.32xlarge"),

    ML_C6_I_LARGE("ml.c6i.large"),

    ML_C6_I_XLARGE("ml.c6i.xlarge"),

    ML_C6_I_2_XLARGE("ml.c6i.2xlarge"),

    ML_C6_I_4_XLARGE("ml.c6i.4xlarge"),

    ML_C6_I_8_XLARGE("ml.c6i.8xlarge"),

    ML_C6_I_12_XLARGE("ml.c6i.12xlarge"),

    ML_C6_I_16_XLARGE("ml.c6i.16xlarge"),

    ML_C6_I_24_XLARGE("ml.c6i.24xlarge"),

    ML_C6_I_32_XLARGE("ml.c6i.32xlarge"),

    ML_R6_I_LARGE("ml.r6i.large"),

    ML_R6_I_XLARGE("ml.r6i.xlarge"),

    ML_R6_I_2_XLARGE("ml.r6i.2xlarge"),

    ML_R6_I_4_XLARGE("ml.r6i.4xlarge"),

    ML_R6_I_8_XLARGE("ml.r6i.8xlarge"),

    ML_R6_I_12_XLARGE("ml.r6i.12xlarge"),

    ML_R6_I_16_XLARGE("ml.r6i.16xlarge"),

    ML_R6_I_24_XLARGE("ml.r6i.24xlarge"),

    ML_R6_I_32_XLARGE("ml.r6i.32xlarge"),

    ML_M7_I_LARGE("ml.m7i.large"),

    ML_M7_I_XLARGE("ml.m7i.xlarge"),

    ML_M7_I_2_XLARGE("ml.m7i.2xlarge"),

    ML_M7_I_4_XLARGE("ml.m7i.4xlarge"),

    ML_M7_I_8_XLARGE("ml.m7i.8xlarge"),

    ML_M7_I_12_XLARGE("ml.m7i.12xlarge"),

    ML_M7_I_16_XLARGE("ml.m7i.16xlarge"),

    ML_M7_I_24_XLARGE("ml.m7i.24xlarge"),

    ML_M7_I_48_XLARGE("ml.m7i.48xlarge"),

    ML_C7_I_LARGE("ml.c7i.large"),

    ML_C7_I_XLARGE("ml.c7i.xlarge"),

    ML_C7_I_2_XLARGE("ml.c7i.2xlarge"),

    ML_C7_I_4_XLARGE("ml.c7i.4xlarge"),

    ML_C7_I_8_XLARGE("ml.c7i.8xlarge"),

    ML_C7_I_12_XLARGE("ml.c7i.12xlarge"),

    ML_C7_I_16_XLARGE("ml.c7i.16xlarge"),

    ML_C7_I_24_XLARGE("ml.c7i.24xlarge"),

    ML_C7_I_48_XLARGE("ml.c7i.48xlarge"),

    ML_R7_I_LARGE("ml.r7i.large"),

    ML_R7_I_XLARGE("ml.r7i.xlarge"),

    ML_R7_I_2_XLARGE("ml.r7i.2xlarge"),

    ML_R7_I_4_XLARGE("ml.r7i.4xlarge"),

    ML_R7_I_8_XLARGE("ml.r7i.8xlarge"),

    ML_R7_I_12_XLARGE("ml.r7i.12xlarge"),

    ML_R7_I_16_XLARGE("ml.r7i.16xlarge"),

    ML_R7_I_24_XLARGE("ml.r7i.24xlarge"),

    ML_R7_I_48_XLARGE("ml.r7i.48xlarge"),

    ML_G4_DN_XLARGE("ml.g4dn.xlarge"),

    ML_G4_DN_2_XLARGE("ml.g4dn.2xlarge"),

    ML_G4_DN_4_XLARGE("ml.g4dn.4xlarge"),

    ML_G4_DN_8_XLARGE("ml.g4dn.8xlarge"),

    ML_G4_DN_12_XLARGE("ml.g4dn.12xlarge"),

    ML_G4_DN_16_XLARGE("ml.g4dn.16xlarge"),

    ML_G5_XLARGE("ml.g5.xlarge"),

    ML_G5_2_XLARGE("ml.g5.2xlarge"),

    ML_G5_4_XLARGE("ml.g5.4xlarge"),

    ML_G5_8_XLARGE("ml.g5.8xlarge"),

    ML_G5_12_XLARGE("ml.g5.12xlarge"),

    ML_G5_16_XLARGE("ml.g5.16xlarge"),

    ML_G5_24_XLARGE("ml.g5.24xlarge"),

    ML_G5_48_XLARGE("ml.g5.48xlarge"),

    ML_INF2_XLARGE("ml.inf2.xlarge"),

    ML_INF2_8_XLARGE("ml.inf2.8xlarge"),

    ML_INF2_24_XLARGE("ml.inf2.24xlarge"),

    ML_INF2_48_XLARGE("ml.inf2.48xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransformInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(TransformInstanceType.class,
            TransformInstanceType::toString);

    private final String value;

    private TransformInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TransformInstanceType corresponding to the value
     */
    public static TransformInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TransformInstanceType}s
     */
    public static Set<TransformInstanceType> knownValues() {
        Set<TransformInstanceType> knownValues = EnumSet.allOf(TransformInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
