/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a hyperparameter. Only one of <code>NumberValue</code> or <code>StringValue</code> can be specified.
 * </p>
 * <p>
 * This object is specified in the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
 * >CreateTrialComponent</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentParameterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentParameterValue.Builder, TrialComponentParameterValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(TrialComponentParameterValue::stringValue))
            .setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("NumberValue").getter(getter(TrialComponentParameterValue::numberValue))
            .setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            NUMBER_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StringValue", STRING_VALUE_FIELD);
                    put("NumberValue", NUMBER_VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Double numberValue;

    private final Type type;

    private TrialComponentParameterValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.numberValue = builder.numberValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't specify
     * the <code>NumberValue</code> parameter.
     * </p>
     * 
     * @return The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
     *         specify the <code>NumberValue</code> parameter.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify the
     * <code>StringValue</code> parameter.
     * </p>
     * 
     * @return The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't
     *         specify the <code>StringValue</code> parameter.
     */
    public final Double numberValue() {
        return numberValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentParameterValue)) {
            return false;
        }
        TrialComponentParameterValue other = (TrialComponentParameterValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(numberValue(), other.numberValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponentParameterValue").add("StringValue", stringValue())
                .add("NumberValue", numberValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "NumberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't specify
     * the <code>NumberValue</code> parameter.
     * </p>
     * 
     * @param stringValue
     *        The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
     *        specify the <code>NumberValue</code> parameter.
     */
    public static TrialComponentParameterValue fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #numberValue()} initialized to the given value.
     *
     * <p>
     * The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify the
     * <code>StringValue</code> parameter.
     * </p>
     * 
     * @param numberValue
     *        The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't
     *        specify the <code>StringValue</code> parameter.
     */
    public static TrialComponentParameterValue fromNumberValue(Double numberValue) {
        return builder().numberValue(numberValue).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentParameterValue, T> g) {
        return obj -> g.apply((TrialComponentParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentParameterValue> {
        /**
         * <p>
         * The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
         * specify the <code>NumberValue</code> parameter.
         * </p>
         * 
         * @param stringValue
         *        The string value of a categorical hyperparameter. If you specify a value for this parameter, you can't
         *        specify the <code>NumberValue</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't specify
         * the <code>StringValue</code> parameter.
         * </p>
         * 
         * @param numberValue
         *        The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can't
         *        specify the <code>StringValue</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(Double numberValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Double numberValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentParameterValue model) {
            stringValue(model.stringValue);
            numberValue(model.numberValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Double getNumberValue() {
            return numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            Object oldValue = this.numberValue;
            this.numberValue = numberValue;
            handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
            return this;
        }

        @Override
        public TrialComponentParameterValue build() {
            return new TrialComponentParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TrialComponentParameterValue#type()
     */
    public enum Type {
        STRING_VALUE,

        NUMBER_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
