/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArtifactRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateArtifactRequest.Builder, UpdateArtifactRequest> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactArn").getter(getter(UpdateArtifactRequest::artifactArn)).setter(setter(Builder::artifactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()).build();

    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactName").getter(getter(UpdateArtifactRequest::artifactName)).setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(UpdateArtifactRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertiesToRemove")
            .getter(getter(UpdateArtifactRequest::propertiesToRemove))
            .setter(setter(Builder::propertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD,
            ARTIFACT_NAME_FIELD, PROPERTIES_FIELD, PROPERTIES_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ArtifactArn", ARTIFACT_ARN_FIELD);
                    put("ArtifactName", ARTIFACT_NAME_FIELD);
                    put("Properties", PROPERTIES_FIELD);
                    put("PropertiesToRemove", PROPERTIES_TO_REMOVE_FIELD);
                }
            });

    private final String artifactArn;

    private final String artifactName;

    private final Map<String, String> properties;

    private final List<String> propertiesToRemove;

    private UpdateArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.artifactArn = builder.artifactArn;
        this.artifactName = builder.artifactName;
        this.properties = builder.properties;
        this.propertiesToRemove = builder.propertiesToRemove;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the artifact to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the artifact to update.
     */
    public final String artifactArn() {
        return artifactArn;
    }

    /**
     * <p>
     * The new name for the artifact.
     * </p>
     * 
     * @return The new name for the artifact.
     */
    public final String artifactName() {
        return artifactName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The new list of properties. Overwrites the current property list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The new list of properties. Overwrites the current property list.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertiesToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertiesToRemove() {
        return propertiesToRemove != null && !(propertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properties to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToRemove} method.
     * </p>
     * 
     * @return A list of properties to remove.
     */
    public final List<String> propertiesToRemove() {
        return propertiesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertiesToRemove() ? propertiesToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArtifactRequest)) {
            return false;
        }
        UpdateArtifactRequest other = (UpdateArtifactRequest) obj;
        return Objects.equals(artifactArn(), other.artifactArn()) && Objects.equals(artifactName(), other.artifactName())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasPropertiesToRemove() == other.hasPropertiesToRemove()
                && Objects.equals(propertiesToRemove(), other.propertiesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateArtifactRequest").add("ArtifactArn", artifactArn()).add("ArtifactName", artifactName())
                .add("Properties", hasProperties() ? properties() : null)
                .add("PropertiesToRemove", hasPropertiesToRemove() ? propertiesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactArn":
            return Optional.ofNullable(clazz.cast(artifactArn()));
        case "ArtifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "PropertiesToRemove":
            return Optional.ofNullable(clazz.cast(propertiesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateArtifactRequest, T> g) {
        return obj -> g.apply((UpdateArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateArtifactRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the artifact to update.
         * </p>
         * 
         * @param artifactArn
         *        The Amazon Resource Name (ARN) of the artifact to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactArn(String artifactArn);

        /**
         * <p>
         * The new name for the artifact.
         * </p>
         * 
         * @param artifactName
         *        The new name for the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        /**
         * <p>
         * The new list of properties. Overwrites the current property list.
         * </p>
         * 
         * @param properties
         *        The new list of properties. Overwrites the current property list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(Collection<String> propertiesToRemove);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(String... propertiesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String artifactArn;

        private String artifactName;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<String> propertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArtifactRequest model) {
            super(model);
            artifactArn(model.artifactArn);
            artifactName(model.artifactName);
            properties(model.properties);
            propertiesToRemove(model.propertiesToRemove);
        }

        public final String getArtifactArn() {
            return artifactArn;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        @Override
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final String getArtifactName() {
            return artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = ArtifactPropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = ArtifactPropertiesCopier.copy(properties);
            return this;
        }

        public final Collection<String> getPropertiesToRemove() {
            if (propertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return propertiesToRemove;
        }

        public final void setPropertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
        }

        @Override
        public final Builder propertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToRemove(String... propertiesToRemove) {
            propertiesToRemove(Arrays.asList(propertiesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateArtifactRequest build() {
            return new UpdateArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
