/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCodeRepositoryRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateCodeRepositoryRequest.Builder, UpdateCodeRepositoryRequest> {
    private static final SdkField<String> CODE_REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeRepositoryName").getter(getter(UpdateCodeRepositoryRequest::codeRepositoryName))
            .setter(setter(Builder::codeRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositoryName").build())
            .build();

    private static final SdkField<GitConfigForUpdate> GIT_CONFIG_FIELD = SdkField
            .<GitConfigForUpdate> builder(MarshallingType.SDK_POJO).memberName("GitConfig")
            .getter(getter(UpdateCodeRepositoryRequest::gitConfig)).setter(setter(Builder::gitConfig))
            .constructor(GitConfigForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_NAME_FIELD,
            GIT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CodeRepositoryName", CODE_REPOSITORY_NAME_FIELD);
                    put("GitConfig", GIT_CONFIG_FIELD);
                }
            });

    private final String codeRepositoryName;

    private final GitConfigForUpdate gitConfig;

    private UpdateCodeRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.codeRepositoryName = builder.codeRepositoryName;
        this.gitConfig = builder.gitConfig;
    }

    /**
     * <p>
     * The name of the Git repository to update.
     * </p>
     * 
     * @return The name of the Git repository to update.
     */
    public final String codeRepositoryName() {
        return codeRepositoryName;
    }

    /**
     * <p>
     * The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the Amazon Web
     * Services Secrets Manager secret that contains the credentials used to access the repository. The secret must have
     * a staging label of <code>AWSCURRENT</code> and must be in the following format:
     * </p>
     * <p>
     * <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
     * </p>
     * 
     * @return The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the
     *         Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.
     *         The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p>
     *         <p>
     *         <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
     */
    public final GitConfigForUpdate gitConfig() {
        return gitConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(gitConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCodeRepositoryRequest)) {
            return false;
        }
        UpdateCodeRepositoryRequest other = (UpdateCodeRepositoryRequest) obj;
        return Objects.equals(codeRepositoryName(), other.codeRepositoryName()) && Objects.equals(gitConfig(), other.gitConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCodeRepositoryRequest").add("CodeRepositoryName", codeRepositoryName())
                .add("GitConfig", gitConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeRepositoryName":
            return Optional.ofNullable(clazz.cast(codeRepositoryName()));
        case "GitConfig":
            return Optional.ofNullable(clazz.cast(gitConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCodeRepositoryRequest, T> g) {
        return obj -> g.apply((UpdateCodeRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCodeRepositoryRequest> {
        /**
         * <p>
         * The name of the Git repository to update.
         * </p>
         * 
         * @param codeRepositoryName
         *        The name of the Git repository to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryName(String codeRepositoryName);

        /**
         * <p>
         * The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the Amazon
         * Web Services Secrets Manager secret that contains the credentials used to access the repository. The secret
         * must have a staging label of <code>AWSCURRENT</code> and must be in the following format:
         * </p>
         * <p>
         * <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
         * </p>
         * 
         * @param gitConfig
         *        The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the
         *        Amazon Web Services Secrets Manager secret that contains the credentials used to access the
         *        repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the
         *        following format:</p>
         *        <p>
         *        <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitConfig(GitConfigForUpdate gitConfig);

        /**
         * <p>
         * The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the Amazon
         * Web Services Secrets Manager secret that contains the credentials used to access the repository. The secret
         * must have a staging label of <code>AWSCURRENT</code> and must be in the following format:
         * </p>
         * <p>
         * <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link GitConfigForUpdate.Builder} avoiding the
         * need to create one manually via {@link GitConfigForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitConfigForUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #gitConfig(GitConfigForUpdate)}.
         * 
         * @param gitConfig
         *        a consumer that will call methods on {@link GitConfigForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitConfig(GitConfigForUpdate)
         */
        default Builder gitConfig(Consumer<GitConfigForUpdate.Builder> gitConfig) {
            return gitConfig(GitConfigForUpdate.builder().applyMutation(gitConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String codeRepositoryName;

        private GitConfigForUpdate gitConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCodeRepositoryRequest model) {
            super(model);
            codeRepositoryName(model.codeRepositoryName);
            gitConfig(model.gitConfig);
        }

        public final String getCodeRepositoryName() {
            return codeRepositoryName;
        }

        public final void setCodeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
        }

        @Override
        public final Builder codeRepositoryName(String codeRepositoryName) {
            this.codeRepositoryName = codeRepositoryName;
            return this;
        }

        public final GitConfigForUpdate.Builder getGitConfig() {
            return gitConfig != null ? gitConfig.toBuilder() : null;
        }

        public final void setGitConfig(GitConfigForUpdate.BuilderImpl gitConfig) {
            this.gitConfig = gitConfig != null ? gitConfig.build() : null;
        }

        @Override
        public final Builder gitConfig(GitConfigForUpdate gitConfig) {
            this.gitConfig = gitConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCodeRepositoryRequest build() {
            return new UpdateCodeRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
