/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContextRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateContextRequest.Builder, UpdateContextRequest> {
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextName").getter(getter(UpdateContextRequest::contextName)).setter(setter(Builder::contextName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateContextRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(UpdateContextRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertiesToRemove")
            .getter(getter(UpdateContextRequest::propertiesToRemove))
            .setter(setter(Builder::propertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_NAME_FIELD,
            DESCRIPTION_FIELD, PROPERTIES_FIELD, PROPERTIES_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ContextName", CONTEXT_NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Properties", PROPERTIES_FIELD);
                    put("PropertiesToRemove", PROPERTIES_TO_REMOVE_FIELD);
                }
            });

    private final String contextName;

    private final String description;

    private final Map<String, String> properties;

    private final List<String> propertiesToRemove;

    private UpdateContextRequest(BuilderImpl builder) {
        super(builder);
        this.contextName = builder.contextName;
        this.description = builder.description;
        this.properties = builder.properties;
        this.propertiesToRemove = builder.propertiesToRemove;
    }

    /**
     * <p>
     * The name of the context to update.
     * </p>
     * 
     * @return The name of the context to update.
     */
    public final String contextName() {
        return contextName;
    }

    /**
     * <p>
     * The new description for the context.
     * </p>
     * 
     * @return The new description for the context.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The new list of properties. Overwrites the current property list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The new list of properties. Overwrites the current property list.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertiesToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertiesToRemove() {
        return propertiesToRemove != null && !(propertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properties to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertiesToRemove} method.
     * </p>
     * 
     * @return A list of properties to remove.
     */
    public final List<String> propertiesToRemove() {
        return propertiesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contextName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertiesToRemove() ? propertiesToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContextRequest)) {
            return false;
        }
        UpdateContextRequest other = (UpdateContextRequest) obj;
        return Objects.equals(contextName(), other.contextName()) && Objects.equals(description(), other.description())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && hasPropertiesToRemove() == other.hasPropertiesToRemove()
                && Objects.equals(propertiesToRemove(), other.propertiesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContextRequest").add("ContextName", contextName()).add("Description", description())
                .add("Properties", hasProperties() ? properties() : null)
                .add("PropertiesToRemove", hasPropertiesToRemove() ? propertiesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextName":
            return Optional.ofNullable(clazz.cast(contextName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "PropertiesToRemove":
            return Optional.ofNullable(clazz.cast(propertiesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContextRequest, T> g) {
        return obj -> g.apply((UpdateContextRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContextRequest> {
        /**
         * <p>
         * The name of the context to update.
         * </p>
         * 
         * @param contextName
         *        The name of the context to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextName(String contextName);

        /**
         * <p>
         * The new description for the context.
         * </p>
         * 
         * @param description
         *        The new description for the context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new list of properties. Overwrites the current property list.
         * </p>
         * 
         * @param properties
         *        The new list of properties. Overwrites the current property list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(Collection<String> propertiesToRemove);

        /**
         * <p>
         * A list of properties to remove.
         * </p>
         * 
         * @param propertiesToRemove
         *        A list of properties to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertiesToRemove(String... propertiesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String contextName;

        private String description;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private List<String> propertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContextRequest model) {
            super(model);
            contextName(model.contextName);
            description(model.description);
            properties(model.properties);
            propertiesToRemove(model.propertiesToRemove);
        }

        public final String getContextName() {
            return contextName;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        @Override
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final Collection<String> getPropertiesToRemove() {
            if (propertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return propertiesToRemove;
        }

        public final void setPropertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
        }

        @Override
        public final Builder propertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToRemove(String... propertiesToRemove) {
            propertiesToRemove(Arrays.asList(propertiesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContextRequest build() {
            return new UpdateContextRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
