/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateDomainRequest.Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UpdateDomainRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField
            .<UserSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultUserSettings")
            .getter(getter(UpdateDomainRequest::defaultUserSettings)).setter(setter(Builder::defaultUserSettings))
            .constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build())
            .build();

    private static final SdkField<DomainSettingsForUpdate> DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<DomainSettingsForUpdate> builder(MarshallingType.SDK_POJO).memberName("DomainSettingsForUpdate")
            .getter(getter(UpdateDomainRequest::domainSettingsForUpdate)).setter(setter(Builder::domainSettingsForUpdate))
            .constructor(DomainSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettingsForUpdate").build())
            .build();

    private static final SdkField<String> APP_SECURITY_GROUP_MANAGEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AppSecurityGroupManagement")
            .getter(getter(UpdateDomainRequest::appSecurityGroupManagementAsString))
            .setter(setter(Builder::appSecurityGroupManagement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSecurityGroupManagement").build())
            .build();

    private static final SdkField<DefaultSpaceSettings> DEFAULT_SPACE_SETTINGS_FIELD = SdkField
            .<DefaultSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultSpaceSettings")
            .getter(getter(UpdateDomainRequest::defaultSpaceSettings)).setter(setter(Builder::defaultSpaceSettings))
            .constructor(DefaultSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSpaceSettings").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(UpdateDomainRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APP_NETWORK_ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppNetworkAccessType").getter(getter(UpdateDomainRequest::appNetworkAccessTypeAsString))
            .setter(setter(Builder::appNetworkAccessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppNetworkAccessType").build())
            .build();

    private static final SdkField<String> TAG_PROPAGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagPropagation").getter(getter(UpdateDomainRequest::tagPropagationAsString))
            .setter(setter(Builder::tagPropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagPropagation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            DEFAULT_USER_SETTINGS_FIELD, DOMAIN_SETTINGS_FOR_UPDATE_FIELD, APP_SECURITY_GROUP_MANAGEMENT_FIELD,
            DEFAULT_SPACE_SETTINGS_FIELD, SUBNET_IDS_FIELD, APP_NETWORK_ACCESS_TYPE_FIELD, TAG_PROPAGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DomainId", DOMAIN_ID_FIELD);
                    put("DefaultUserSettings", DEFAULT_USER_SETTINGS_FIELD);
                    put("DomainSettingsForUpdate", DOMAIN_SETTINGS_FOR_UPDATE_FIELD);
                    put("AppSecurityGroupManagement", APP_SECURITY_GROUP_MANAGEMENT_FIELD);
                    put("DefaultSpaceSettings", DEFAULT_SPACE_SETTINGS_FIELD);
                    put("SubnetIds", SUBNET_IDS_FIELD);
                    put("AppNetworkAccessType", APP_NETWORK_ACCESS_TYPE_FIELD);
                    put("TagPropagation", TAG_PROPAGATION_FIELD);
                }
            });

    private final String domainId;

    private final UserSettings defaultUserSettings;

    private final DomainSettingsForUpdate domainSettingsForUpdate;

    private final String appSecurityGroupManagement;

    private final DefaultSpaceSettings defaultSpaceSettings;

    private final List<String> subnetIds;

    private final String appNetworkAccessType;

    private final String tagPropagation;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.domainSettingsForUpdate = builder.domainSettingsForUpdate;
        this.appSecurityGroupManagement = builder.appSecurityGroupManagement;
        this.defaultSpaceSettings = builder.defaultSpaceSettings;
        this.subnetIds = builder.subnetIds;
        this.appNetworkAccessType = builder.appNetworkAccessType;
        this.tagPropagation = builder.tagPropagation;
    }

    /**
     * <p>
     * The ID of the domain to be updated.
     * </p>
     * 
     * @return The ID of the domain to be updated.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * A collection of settings.
     * </p>
     * 
     * @return A collection of settings.
     */
    public final UserSettings defaultUserSettings() {
        return defaultUserSettings;
    }

    /**
     * <p>
     * A collection of <code>DomainSettings</code> configuration values to update.
     * </p>
     * 
     * @return A collection of <code>DomainSettings</code> configuration values to update.
     */
    public final DomainSettingsForUpdate domainSettingsForUpdate() {
        return domainSettingsForUpdate;
    }

    /**
     * <p>
     * The entity that creates and manages the required security groups for inter-app communication in
     * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code>
     * and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up
     * the domain for use with RStudio, this value must be set to <code>Service</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appSecurityGroupManagement} will return {@link AppSecurityGroupManagement#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #appSecurityGroupManagementAsString}.
     * </p>
     * 
     * @return The entity that creates and manages the required security groups for inter-app communication in
     *         <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
     *         <code>VPCOnly</code> and
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting
     *         up the domain for use with RStudio, this value must be set to <code>Service</code>.
     * @see AppSecurityGroupManagement
     */
    public final AppSecurityGroupManagement appSecurityGroupManagement() {
        return AppSecurityGroupManagement.fromValue(appSecurityGroupManagement);
    }

    /**
     * <p>
     * The entity that creates and manages the required security groups for inter-app communication in
     * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code>
     * and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting up
     * the domain for use with RStudio, this value must be set to <code>Service</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appSecurityGroupManagement} will return {@link AppSecurityGroupManagement#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #appSecurityGroupManagementAsString}.
     * </p>
     * 
     * @return The entity that creates and manages the required security groups for inter-app communication in
     *         <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
     *         <code>VPCOnly</code> and
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If setting
     *         up the domain for use with RStudio, this value must be set to <code>Service</code>.
     * @see AppSecurityGroupManagement
     */
    public final String appSecurityGroupManagementAsString() {
        return appSecurityGroupManagement;
    }

    /**
     * <p>
     * The default settings for shared spaces that users create in the domain.
     * </p>
     * 
     * @return The default settings for shared spaces that users create in the domain.
     */
    public final DefaultSpaceSettings defaultSpaceSettings() {
        return defaultSpaceSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets that Studio uses for communication.
     * </p>
     * <p>
     * If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
     * <code>Deleting</code> state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The VPC subnets that Studio uses for communication.</p>
     *         <p>
     *         If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
     *         <code>Deleting</code> state.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This configuration can only be modified if there are no apps in the <code>InService</code>, <code>Pending</code>,
     * or <code>Deleting</code> state. The configuration cannot be updated if
     * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
     * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of the same
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This configuration can only be modified if there are no apps in the <code>InService</code>,
     *         <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of
     *         the same request.
     * @see AppNetworkAccessType
     */
    public final AppNetworkAccessType appNetworkAccessType() {
        return AppNetworkAccessType.fromValue(appNetworkAccessType);
    }

    /**
     * <p>
     * Specifies the VPC used for non-EFS traffic.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
     * direct internet access.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This configuration can only be modified if there are no apps in the <code>InService</code>, <code>Pending</code>,
     * or <code>Deleting</code> state. The configuration cannot be updated if
     * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
     * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of the same
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appNetworkAccessType} will return {@link AppNetworkAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appNetworkAccessTypeAsString}.
     * </p>
     * 
     * @return Specifies the VPC used for non-EFS traffic.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
     *         allows direct internet access.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This configuration can only be modified if there are no apps in the <code>InService</code>,
     *         <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
     *         <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of
     *         the same request.
     * @see AppNetworkAccessType
     */
    public final String appNetworkAccessTypeAsString() {
        return appNetworkAccessType;
    }

    /**
     * <p>
     * Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tagPropagation}
     * will return {@link TagPropagation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tagPropagationAsString}.
     * </p>
     * 
     * @return Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
     * @see TagPropagation
     */
    public final TagPropagation tagPropagation() {
        return TagPropagation.fromValue(tagPropagation);
    }

    /**
     * <p>
     * Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tagPropagation}
     * will return {@link TagPropagation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tagPropagationAsString}.
     * </p>
     * 
     * @return Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
     * @see TagPropagation
     */
    public final String tagPropagationAsString() {
        return tagPropagation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(domainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(appSecurityGroupManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appNetworkAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tagPropagationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(defaultUserSettings(), other.defaultUserSettings())
                && Objects.equals(domainSettingsForUpdate(), other.domainSettingsForUpdate())
                && Objects.equals(appSecurityGroupManagementAsString(), other.appSecurityGroupManagementAsString())
                && Objects.equals(defaultSpaceSettings(), other.defaultSpaceSettings()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(appNetworkAccessTypeAsString(), other.appNetworkAccessTypeAsString())
                && Objects.equals(tagPropagationAsString(), other.tagPropagationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainRequest").add("DomainId", domainId())
                .add("DefaultUserSettings", defaultUserSettings()).add("DomainSettingsForUpdate", domainSettingsForUpdate())
                .add("AppSecurityGroupManagement", appSecurityGroupManagementAsString())
                .add("DefaultSpaceSettings", defaultSpaceSettings()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("AppNetworkAccessType", appNetworkAccessTypeAsString()).add("TagPropagation", tagPropagationAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DefaultUserSettings":
            return Optional.ofNullable(clazz.cast(defaultUserSettings()));
        case "DomainSettingsForUpdate":
            return Optional.ofNullable(clazz.cast(domainSettingsForUpdate()));
        case "AppSecurityGroupManagement":
            return Optional.ofNullable(clazz.cast(appSecurityGroupManagementAsString()));
        case "DefaultSpaceSettings":
            return Optional.ofNullable(clazz.cast(defaultSpaceSettings()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "AppNetworkAccessType":
            return Optional.ofNullable(clazz.cast(appNetworkAccessTypeAsString()));
        case "TagPropagation":
            return Optional.ofNullable(clazz.cast(tagPropagationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainRequest> {
        /**
         * <p>
         * The ID of the domain to be updated.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * 
         * @param defaultUserSettings
         *        A collection of settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUserSettings(UserSettings defaultUserSettings);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserSettings.Builder} avoiding the need
         * to create one manually via {@link UserSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultUserSettings(UserSettings)}.
         * 
         * @param defaultUserSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultUserSettings(UserSettings)
         */
        default Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return defaultUserSettings(UserSettings.builder().applyMutation(defaultUserSettings).build());
        }

        /**
         * <p>
         * A collection of <code>DomainSettings</code> configuration values to update.
         * </p>
         * 
         * @param domainSettingsForUpdate
         *        A collection of <code>DomainSettings</code> configuration values to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate);

        /**
         * <p>
         * A collection of <code>DomainSettings</code> configuration values to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainSettingsForUpdate.Builder} avoiding
         * the need to create one manually via {@link DomainSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainSettingsForUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #domainSettingsForUpdate(DomainSettingsForUpdate)}.
         * 
         * @param domainSettingsForUpdate
         *        a consumer that will call methods on {@link DomainSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainSettingsForUpdate(DomainSettingsForUpdate)
         */
        default Builder domainSettingsForUpdate(Consumer<DomainSettingsForUpdate.Builder> domainSettingsForUpdate) {
            return domainSettingsForUpdate(DomainSettingsForUpdate.builder().applyMutation(domainSettingsForUpdate).build());
        }

        /**
         * <p>
         * The entity that creates and manages the required security groups for inter-app communication in
         * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         * <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
         * provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code>.
         * </p>
         * 
         * @param appSecurityGroupManagement
         *        The entity that creates and manages the required security groups for inter-app communication in
         *        <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         *        <code>VPCOnly</code> and
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If
         *        setting up the domain for use with RStudio, this value must be set to <code>Service</code>.
         * @see AppSecurityGroupManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppSecurityGroupManagement
         */
        Builder appSecurityGroupManagement(String appSecurityGroupManagement);

        /**
         * <p>
         * The entity that creates and manages the required security groups for inter-app communication in
         * <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         * <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
         * provided. If setting up the domain for use with RStudio, this value must be set to <code>Service</code>.
         * </p>
         * 
         * @param appSecurityGroupManagement
         *        The entity that creates and manages the required security groups for inter-app communication in
         *        <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is
         *        <code>VPCOnly</code> and
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided. If
         *        setting up the domain for use with RStudio, this value must be set to <code>Service</code>.
         * @see AppSecurityGroupManagement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppSecurityGroupManagement
         */
        Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement);

        /**
         * <p>
         * The default settings for shared spaces that users create in the domain.
         * </p>
         * 
         * @param defaultSpaceSettings
         *        The default settings for shared spaces that users create in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings);

        /**
         * <p>
         * The default settings for shared spaces that users create in the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultSpaceSettings.Builder} avoiding
         * the need to create one manually via {@link DefaultSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultSpaceSettings(DefaultSpaceSettings)}.
         * 
         * @param defaultSpaceSettings
         *        a consumer that will call methods on {@link DefaultSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSpaceSettings(DefaultSpaceSettings)
         */
        default Builder defaultSpaceSettings(Consumer<DefaultSpaceSettings.Builder> defaultSpaceSettings) {
            return defaultSpaceSettings(DefaultSpaceSettings.builder().applyMutation(defaultSpaceSettings).build());
        }

        /**
         * <p>
         * The VPC subnets that Studio uses for communication.
         * </p>
         * <p>
         * If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
         * <code>Deleting</code> state.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that Studio uses for communication.</p>
         *        <p>
         *        If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
         *        <code>Deleting</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The VPC subnets that Studio uses for communication.
         * </p>
         * <p>
         * If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
         * <code>Deleting</code> state.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets that Studio uses for communication.</p>
         *        <p>
         *        If removing subnets, ensure there are no apps in the <code>InService</code>, <code>Pending</code>, or
         *        <code>Deleting</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This configuration can only be modified if there are no apps in the <code>InService</code>,
         * <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
         * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
         * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of the
         * same request.
         * </p>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This configuration can only be modified if there are no apps in the <code>InService</code>,
         *        <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part
         *        of the same request.
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(String appNetworkAccessType);

        /**
         * <p>
         * Specifies the VPC used for non-EFS traffic.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows
         * direct internet access.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This configuration can only be modified if there are no apps in the <code>InService</code>,
         * <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
         * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
         * <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part of the
         * same request.
         * </p>
         * 
         * @param appNetworkAccessType
         *        Specifies the VPC used for non-EFS traffic.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which
         *        allows direct internet access.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This configuration can only be modified if there are no apps in the <code>InService</code>,
         *        <code>Pending</code>, or <code>Deleting</code> state. The configuration cannot be updated if
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is already set or
         *        <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided as part
         *        of the same request.
         * @see AppNetworkAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppNetworkAccessType
         */
        Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType);

        /**
         * <p>
         * Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
         * </p>
         * 
         * @param tagPropagation
         *        Indicates whether custom tag propagation is supported for the domain. Defaults to
         *        <code>DISABLED</code>.
         * @see TagPropagation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagPropagation
         */
        Builder tagPropagation(String tagPropagation);

        /**
         * <p>
         * Indicates whether custom tag propagation is supported for the domain. Defaults to <code>DISABLED</code>.
         * </p>
         * 
         * @param tagPropagation
         *        Indicates whether custom tag propagation is supported for the domain. Defaults to
         *        <code>DISABLED</code>.
         * @see TagPropagation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagPropagation
         */
        Builder tagPropagation(TagPropagation tagPropagation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private UserSettings defaultUserSettings;

        private DomainSettingsForUpdate domainSettingsForUpdate;

        private String appSecurityGroupManagement;

        private DefaultSpaceSettings defaultSpaceSettings;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String appNetworkAccessType;

        private String tagPropagation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            domainId(model.domainId);
            defaultUserSettings(model.defaultUserSettings);
            domainSettingsForUpdate(model.domainSettingsForUpdate);
            appSecurityGroupManagement(model.appSecurityGroupManagement);
            defaultSpaceSettings(model.defaultSpaceSettings);
            subnetIds(model.subnetIds);
            appNetworkAccessType(model.appNetworkAccessType);
            tagPropagation(model.tagPropagation);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return defaultUserSettings != null ? defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final DomainSettingsForUpdate.Builder getDomainSettingsForUpdate() {
            return domainSettingsForUpdate != null ? domainSettingsForUpdate.toBuilder() : null;
        }

        public final void setDomainSettingsForUpdate(DomainSettingsForUpdate.BuilderImpl domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate != null ? domainSettingsForUpdate.build() : null;
        }

        @Override
        public final Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate;
            return this;
        }

        public final String getAppSecurityGroupManagement() {
            return appSecurityGroupManagement;
        }

        public final void setAppSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
        }

        @Override
        public final Builder appSecurityGroupManagement(String appSecurityGroupManagement) {
            this.appSecurityGroupManagement = appSecurityGroupManagement;
            return this;
        }

        @Override
        public final Builder appSecurityGroupManagement(AppSecurityGroupManagement appSecurityGroupManagement) {
            this.appSecurityGroupManagement(appSecurityGroupManagement == null ? null : appSecurityGroupManagement.toString());
            return this;
        }

        public final DefaultSpaceSettings.Builder getDefaultSpaceSettings() {
            return defaultSpaceSettings != null ? defaultSpaceSettings.toBuilder() : null;
        }

        public final void setDefaultSpaceSettings(DefaultSpaceSettings.BuilderImpl defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings != null ? defaultSpaceSettings.build() : null;
        }

        @Override
        public final Builder defaultSpaceSettings(DefaultSpaceSettings defaultSpaceSettings) {
            this.defaultSpaceSettings = defaultSpaceSettings;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getAppNetworkAccessType() {
            return appNetworkAccessType;
        }

        public final void setAppNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
        }

        @Override
        public final Builder appNetworkAccessType(String appNetworkAccessType) {
            this.appNetworkAccessType = appNetworkAccessType;
            return this;
        }

        @Override
        public final Builder appNetworkAccessType(AppNetworkAccessType appNetworkAccessType) {
            this.appNetworkAccessType(appNetworkAccessType == null ? null : appNetworkAccessType.toString());
            return this;
        }

        public final String getTagPropagation() {
            return tagPropagation;
        }

        public final void setTagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
        }

        @Override
        public final Builder tagPropagation(String tagPropagation) {
            this.tagPropagation = tagPropagation;
            return this;
        }

        @Override
        public final Builder tagPropagation(TagPropagation tagPropagation) {
            this.tagPropagation(tagPropagation == null ? null : tagPropagation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
