/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHubRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateHubRequest.Builder, UpdateHubRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(UpdateHubRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDescription").getter(getter(UpdateHubRequest::hubDescription))
            .setter(setter(Builder::hubDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()).build();

    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDisplayName").getter(getter(UpdateHubRequest::hubDisplayName))
            .setter(setter(Builder::hubDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()).build();

    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubSearchKeywords")
            .getter(getter(UpdateHubRequest::hubSearchKeywords))
            .setter(setter(Builder::hubSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_DESCRIPTION_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_SEARCH_KEYWORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("HubName", HUB_NAME_FIELD);
                    put("HubDescription", HUB_DESCRIPTION_FIELD);
                    put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
                    put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
                }
            });

    private final String hubName;

    private final String hubDescription;

    private final String hubDisplayName;

    private final List<String> hubSearchKeywords;

    private UpdateHubRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubDescription = builder.hubDescription;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubSearchKeywords = builder.hubSearchKeywords;
    }

    /**
     * <p>
     * The name of the hub to update.
     * </p>
     * 
     * @return The name of the hub to update.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * A description of the updated hub.
     * </p>
     * 
     * @return A description of the updated hub.
     */
    public final String hubDescription() {
        return hubDescription;
    }

    /**
     * <p>
     * The display name of the hub.
     * </p>
     * 
     * @return The display name of the hub.
     */
    public final String hubDisplayName() {
        return hubDisplayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubSearchKeywords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHubSearchKeywords() {
        return hubSearchKeywords != null && !(hubSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords for the hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords for the hub.
     */
    public final List<String> hubSearchKeywords() {
        return hubSearchKeywords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubSearchKeywords() ? hubSearchKeywords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHubRequest)) {
            return false;
        }
        UpdateHubRequest other = (UpdateHubRequest) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubDescription(), other.hubDescription())
                && Objects.equals(hubDisplayName(), other.hubDisplayName())
                && hasHubSearchKeywords() == other.hasHubSearchKeywords()
                && Objects.equals(hubSearchKeywords(), other.hubSearchKeywords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHubRequest").add("HubName", hubName()).add("HubDescription", hubDescription())
                .add("HubDisplayName", hubDisplayName())
                .add("HubSearchKeywords", hasHubSearchKeywords() ? hubSearchKeywords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubDescription":
            return Optional.ofNullable(clazz.cast(hubDescription()));
        case "HubDisplayName":
            return Optional.ofNullable(clazz.cast(hubDisplayName()));
        case "HubSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubSearchKeywords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHubRequest, T> g) {
        return obj -> g.apply((UpdateHubRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHubRequest> {
        /**
         * <p>
         * The name of the hub to update.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * A description of the updated hub.
         * </p>
         * 
         * @param hubDescription
         *        A description of the updated hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDescription(String hubDescription);

        /**
         * <p>
         * The display name of the hub.
         * </p>
         * 
         * @param hubDisplayName
         *        The display name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDisplayName(String hubDisplayName);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(Collection<String> hubSearchKeywords);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(String... hubSearchKeywords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubDescription;

        private String hubDisplayName;

        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHubRequest model) {
            super(model);
            hubName(model.hubName);
            hubDescription(model.hubDescription);
            hubDisplayName(model.hubDisplayName);
            hubSearchKeywords(model.hubSearchKeywords);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubDescription() {
            return hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final String getHubDisplayName() {
            return hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String... hubSearchKeywords) {
            hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHubRequest build() {
            return new UpdateHubRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
