/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateImageRequest.Builder, UpdateImageRequest> {
    private static final SdkField<List<String>> DELETE_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeleteProperties")
            .getter(getter(UpdateImageRequest::deleteProperties))
            .setter(setter(Builder::deleteProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateImageRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateImageRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(UpdateImageRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateImageRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_PROPERTIES_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IMAGE_NAME_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeleteProperties", DELETE_PROPERTIES_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("DisplayName", DISPLAY_NAME_FIELD);
                    put("ImageName", IMAGE_NAME_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                }
            });

    private final List<String> deleteProperties;

    private final String description;

    private final String displayName;

    private final String imageName;

    private final String roleArn;

    private UpdateImageRequest(BuilderImpl builder) {
        super(builder);
        this.deleteProperties = builder.deleteProperties;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.imageName = builder.imageName;
        this.roleArn = builder.roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeleteProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeleteProperties() {
        return deleteProperties != null && !(deleteProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can be
     * deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleteProperties} method.
     * </p>
     * 
     * @return A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties
     *         can be deleted.
     */
    public final List<String> deleteProperties() {
        return deleteProperties;
    }

    /**
     * <p>
     * The new description for the image.
     * </p>
     * 
     * @return The new description for the image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new display name for the image.
     * </p>
     * 
     * @return The new display name for the image.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The name of the image to update.
     * </p>
     * 
     * @return The name of the image to update.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The new ARN for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * </p>
     * 
     * @return The new ARN for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleteProperties() ? deleteProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageRequest)) {
            return false;
        }
        UpdateImageRequest other = (UpdateImageRequest) obj;
        return hasDeleteProperties() == other.hasDeleteProperties()
                && Objects.equals(deleteProperties(), other.deleteProperties())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(imageName(), other.imageName()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageRequest").add("DeleteProperties", hasDeleteProperties() ? deleteProperties() : null)
                .add("Description", description()).add("DisplayName", displayName()).add("ImageName", imageName())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteProperties":
            return Optional.ofNullable(clazz.cast(deleteProperties()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageRequest, T> g) {
        return obj -> g.apply((UpdateImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImageRequest> {
        /**
         * <p>
         * A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can
         * be deleted.
         * </p>
         * 
         * @param deleteProperties
         *        A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code>
         *        properties can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteProperties(Collection<String> deleteProperties);

        /**
         * <p>
         * A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can
         * be deleted.
         * </p>
         * 
         * @param deleteProperties
         *        A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code>
         *        properties can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteProperties(String... deleteProperties);

        /**
         * <p>
         * The new description for the image.
         * </p>
         * 
         * @param description
         *        The new description for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new display name for the image.
         * </p>
         * 
         * @param displayName
         *        The new display name for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The name of the image to update.
         * </p>
         * 
         * @param imageName
         *        The name of the image to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The new ARN for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The new ARN for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private List<String> deleteProperties = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String displayName;

        private String imageName;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageRequest model) {
            super(model);
            deleteProperties(model.deleteProperties);
            description(model.description);
            displayName(model.displayName);
            imageName(model.imageName);
            roleArn(model.roleArn);
        }

        public final Collection<String> getDeleteProperties() {
            if (deleteProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return deleteProperties;
        }

        public final void setDeleteProperties(Collection<String> deleteProperties) {
            this.deleteProperties = ImageDeletePropertyListCopier.copy(deleteProperties);
        }

        @Override
        public final Builder deleteProperties(Collection<String> deleteProperties) {
            this.deleteProperties = ImageDeletePropertyListCopier.copy(deleteProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteProperties(String... deleteProperties) {
            deleteProperties(Arrays.asList(deleteProperties));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageRequest build() {
            return new UpdateImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
