/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInferenceExperimentResponse extends SageMakerResponse implements
        ToCopyableBuilder<UpdateInferenceExperimentResponse.Builder, UpdateInferenceExperimentResponse> {
    private static final SdkField<String> INFERENCE_EXPERIMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceExperimentArn").getter(getter(UpdateInferenceExperimentResponse::inferenceExperimentArn))
            .setter(setter(Builder::inferenceExperimentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExperimentArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INFERENCE_EXPERIMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InferenceExperimentArn", INFERENCE_EXPERIMENT_ARN_FIELD);
                }
            });

    private final String inferenceExperimentArn;

    private UpdateInferenceExperimentResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceExperimentArn = builder.inferenceExperimentArn;
    }

    /**
     * <p>
     * The ARN of the updated inference experiment.
     * </p>
     * 
     * @return The ARN of the updated inference experiment.
     */
    public final String inferenceExperimentArn() {
        return inferenceExperimentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceExperimentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceExperimentResponse)) {
            return false;
        }
        UpdateInferenceExperimentResponse other = (UpdateInferenceExperimentResponse) obj;
        return Objects.equals(inferenceExperimentArn(), other.inferenceExperimentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInferenceExperimentResponse").add("InferenceExperimentArn", inferenceExperimentArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceExperimentArn":
            return Optional.ofNullable(clazz.cast(inferenceExperimentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceExperimentResponse, T> g) {
        return obj -> g.apply((UpdateInferenceExperimentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInferenceExperimentResponse> {
        /**
         * <p>
         * The ARN of the updated inference experiment.
         * </p>
         * 
         * @param inferenceExperimentArn
         *        The ARN of the updated inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExperimentArn(String inferenceExperimentArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String inferenceExperimentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceExperimentResponse model) {
            super(model);
            inferenceExperimentArn(model.inferenceExperimentArn);
        }

        public final String getInferenceExperimentArn() {
            return inferenceExperimentArn;
        }

        public final void setInferenceExperimentArn(String inferenceExperimentArn) {
            this.inferenceExperimentArn = inferenceExperimentArn;
        }

        @Override
        public final Builder inferenceExperimentArn(String inferenceExperimentArn) {
            this.inferenceExperimentArn = inferenceExperimentArn;
            return this;
        }

        @Override
        public UpdateInferenceExperimentResponse build() {
            return new UpdateInferenceExperimentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
