/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateModelPackageRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateModelPackageRequest.Builder, UpdateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageArn").getter(getter(UpdateModelPackageRequest::modelPackageArn))
            .setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelApprovalStatus").getter(getter(UpdateModelPackageRequest::modelApprovalStatusAsString))
            .setter(setter(Builder::modelApprovalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build())
            .build();

    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalDescription").getter(getter(UpdateModelPackageRequest::approvalDescription))
            .setter(setter(Builder::approvalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build())
            .build();

    private static final SdkField<Map<String, String>> CUSTOMER_METADATA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomerMetadataProperties")
            .getter(getter(UpdateModelPackageRequest::customerMetadataProperties))
            .setter(setter(Builder::customerMetadataProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomerMetadataPropertiesToRemove")
            .getter(getter(UpdateModelPackageRequest::customerMetadataPropertiesToRemove))
            .setter(setter(Builder::customerMetadataPropertiesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMetadataPropertiesToRemove")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdditionalInferenceSpecificationDefinition>> ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD = SdkField
            .<List<AdditionalInferenceSpecificationDefinition>> builder(MarshallingType.LIST)
            .memberName("AdditionalInferenceSpecificationsToAdd")
            .getter(getter(UpdateModelPackageRequest::additionalInferenceSpecificationsToAdd))
            .setter(setter(Builder::additionalInferenceSpecificationsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AdditionalInferenceSpecificationsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalInferenceSpecificationDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalInferenceSpecificationDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO).memberName("InferenceSpecification")
            .getter(getter(UpdateModelPackageRequest::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUri").getter(getter(UpdateModelPackageRequest::sourceUri)).setter(setter(Builder::sourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()).build();

    private static final SdkField<ModelPackageModelCard> MODEL_CARD_FIELD = SdkField
            .<ModelPackageModelCard> builder(MarshallingType.SDK_POJO).memberName("ModelCard")
            .getter(getter(UpdateModelPackageRequest::modelCard)).setter(setter(Builder::modelCard))
            .constructor(ModelPackageModelCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCard").build()).build();

    private static final SdkField<ModelLifeCycle> MODEL_LIFE_CYCLE_FIELD = SdkField
            .<ModelLifeCycle> builder(MarshallingType.SDK_POJO).memberName("ModelLifeCycle")
            .getter(getter(UpdateModelPackageRequest::modelLifeCycle)).setter(setter(Builder::modelLifeCycle))
            .constructor(ModelLifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLifeCycle").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(UpdateModelPackageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_ARN_FIELD,
            MODEL_APPROVAL_STATUS_FIELD, APPROVAL_DESCRIPTION_FIELD, CUSTOMER_METADATA_PROPERTIES_FIELD,
            CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD, ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD,
            INFERENCE_SPECIFICATION_FIELD, SOURCE_URI_FIELD, MODEL_CARD_FIELD, MODEL_LIFE_CYCLE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ModelPackageArn", MODEL_PACKAGE_ARN_FIELD);
                    put("ModelApprovalStatus", MODEL_APPROVAL_STATUS_FIELD);
                    put("ApprovalDescription", APPROVAL_DESCRIPTION_FIELD);
                    put("CustomerMetadataProperties", CUSTOMER_METADATA_PROPERTIES_FIELD);
                    put("CustomerMetadataPropertiesToRemove", CUSTOMER_METADATA_PROPERTIES_TO_REMOVE_FIELD);
                    put("AdditionalInferenceSpecificationsToAdd", ADDITIONAL_INFERENCE_SPECIFICATIONS_TO_ADD_FIELD);
                    put("InferenceSpecification", INFERENCE_SPECIFICATION_FIELD);
                    put("SourceUri", SOURCE_URI_FIELD);
                    put("ModelCard", MODEL_CARD_FIELD);
                    put("ModelLifeCycle", MODEL_LIFE_CYCLE_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                }
            });

    private final String modelPackageArn;

    private final String modelApprovalStatus;

    private final String approvalDescription;

    private final Map<String, String> customerMetadataProperties;

    private final List<String> customerMetadataPropertiesToRemove;

    private final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd;

    private final InferenceSpecification inferenceSpecification;

    private final String sourceUri;

    private final ModelPackageModelCard modelCard;

    private final ModelLifeCycle modelLifeCycle;

    private final String clientToken;

    private UpdateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageArn = builder.modelPackageArn;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.approvalDescription = builder.approvalDescription;
        this.customerMetadataProperties = builder.customerMetadataProperties;
        this.customerMetadataPropertiesToRemove = builder.customerMetadataPropertiesToRemove;
        this.additionalInferenceSpecificationsToAdd = builder.additionalInferenceSpecificationsToAdd;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceUri = builder.sourceUri;
        this.modelCard = builder.modelCard;
        this.modelLifeCycle = builder.modelLifeCycle;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public final String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(modelApprovalStatus);
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public final String modelApprovalStatusAsString() {
        return modelApprovalStatus;
    }

    /**
     * <p>
     * A description for the approval status of the model.
     * </p>
     * 
     * @return A description for the approval status of the model.
     */
    public final String approvalDescription() {
        return approvalDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerMetadataProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomerMetadataProperties() {
        return customerMetadataProperties != null && !(customerMetadataProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata properties associated with the model package versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerMetadataProperties} method.
     * </p>
     * 
     * @return The metadata properties associated with the model package versions.
     */
    public final Map<String, String> customerMetadataProperties() {
        return customerMetadataProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerMetadataPropertiesToRemove
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCustomerMetadataPropertiesToRemove() {
        return customerMetadataPropertiesToRemove != null
                && !(customerMetadataPropertiesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata properties associated with the model package versions to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerMetadataPropertiesToRemove}
     * method.
     * </p>
     * 
     * @return The metadata properties associated with the model package versions to remove.
     */
    public final List<String> customerMetadataPropertiesToRemove() {
        return customerMetadataPropertiesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalInferenceSpecificationsToAdd
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalInferenceSpecificationsToAdd() {
        return additionalInferenceSpecificationsToAdd != null
                && !(additionalInferenceSpecificationsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of additional Inference Specification objects to be added to the existing array additional Inference
     * Specification. Total number of additional Inference Specifications can not exceed 15. Each additional Inference
     * Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally
     * used with SageMaker Neo to store the compiled artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalInferenceSpecificationsToAdd}
     * method.
     * </p>
     * 
     * @return An array of additional Inference Specification objects to be added to the existing array additional
     *         Inference Specification. Total number of additional Inference Specifications can not exceed 15. Each
     *         additional Inference Specification specifies artifacts based on this model package that can be used on
     *         inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
     */
    public final List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd() {
        return additionalInferenceSpecificationsToAdd;
    }

    /**
     * <p>
     * Specifies details about inference jobs that you can run with models based on this model package, including the
     * following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon ECR paths of containers that contain the inference code and model artifacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
     * </p>
     * </li>
     * <li>
     * <p>
     * The input and output content formats that the model package supports for inference.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies details about inference jobs that you can run with models based on this model package,
     *         including the following information:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The Amazon ECR paths of containers that contain the inference code and model artifacts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The instance types that the model package supports for transform jobs and real-time endpoints used for
     *         inference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input and output content formats that the model package supports for inference.
     *         </p>
     *         </li>
     */
    public final InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * The URI of the source for the model package.
     * </p>
     * 
     * @return The URI of the source for the model package.
     */
    public final String sourceUri() {
        return sourceUri;
    }

    /**
     * <p>
     * The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model
     * package, it is a specific usage of a model card and its schema is simplified compared to the schema of
     * <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
     * <code>model_package_details</code>, and <code>model_overview</code> is composed of the <code>model_creator</code>
     * and <code>model_artifact</code> properties. For more information about the model package model card schema, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model
     * package model card schema</a>. For more information about the model card associated with the model package, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of a Model
     * Version</a>.
     * </p>
     * 
     * @return The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a
     *         model package, it is a specific usage of a model card and its schema is simplified compared to the schema
     *         of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
     *         <code>model_package_details</code>, and <code>model_overview</code> is composed of the
     *         <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the
     *         model package model card schema, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema"
     *         >Model package model card schema</a>. For more information about the model card associated with the model
     *         package, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View
     *         the Details of a Model Version</a>.
     */
    public final ModelPackageModelCard modelCard() {
        return modelCard;
    }

    /**
     * <p>
     * A structure describing the current state of the model in its life cycle.
     * </p>
     * 
     * @return A structure describing the current state of the model in its life cycle.
     */
    public final ModelLifeCycle modelLifeCycle() {
        return modelLifeCycle;
    }

    /**
     * <p>
     * A unique token that guarantees that the call to this API is idempotent.
     * </p>
     * 
     * @return A unique token that guarantees that the call to this API is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerMetadataProperties() ? customerMetadataProperties() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCustomerMetadataPropertiesToRemove() ? customerMetadataPropertiesToRemove() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalInferenceSpecificationsToAdd() ? additionalInferenceSpecificationsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(modelCard());
        hashCode = 31 * hashCode + Objects.hashCode(modelLifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest) obj;
        return Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelApprovalStatusAsString(), other.modelApprovalStatusAsString())
                && Objects.equals(approvalDescription(), other.approvalDescription())
                && hasCustomerMetadataProperties() == other.hasCustomerMetadataProperties()
                && Objects.equals(customerMetadataProperties(), other.customerMetadataProperties())
                && hasCustomerMetadataPropertiesToRemove() == other.hasCustomerMetadataPropertiesToRemove()
                && Objects.equals(customerMetadataPropertiesToRemove(), other.customerMetadataPropertiesToRemove())
                && hasAdditionalInferenceSpecificationsToAdd() == other.hasAdditionalInferenceSpecificationsToAdd()
                && Objects.equals(additionalInferenceSpecificationsToAdd(), other.additionalInferenceSpecificationsToAdd())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(sourceUri(), other.sourceUri()) && Objects.equals(modelCard(), other.modelCard())
                && Objects.equals(modelLifeCycle(), other.modelLifeCycle()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateModelPackageRequest")
                .add("ModelPackageArn", modelPackageArn())
                .add("ModelApprovalStatus", modelApprovalStatusAsString())
                .add("ApprovalDescription", approvalDescription())
                .add("CustomerMetadataProperties", hasCustomerMetadataProperties() ? customerMetadataProperties() : null)
                .add("CustomerMetadataPropertiesToRemove",
                        hasCustomerMetadataPropertiesToRemove() ? customerMetadataPropertiesToRemove() : null)
                .add("AdditionalInferenceSpecificationsToAdd",
                        hasAdditionalInferenceSpecificationsToAdd() ? additionalInferenceSpecificationsToAdd() : null)
                .add("InferenceSpecification", inferenceSpecification()).add("SourceUri", sourceUri())
                .add("ModelCard", modelCard()).add("ModelLifeCycle", modelLifeCycle()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelApprovalStatus":
            return Optional.ofNullable(clazz.cast(modelApprovalStatusAsString()));
        case "ApprovalDescription":
            return Optional.ofNullable(clazz.cast(approvalDescription()));
        case "CustomerMetadataProperties":
            return Optional.ofNullable(clazz.cast(customerMetadataProperties()));
        case "CustomerMetadataPropertiesToRemove":
            return Optional.ofNullable(clazz.cast(customerMetadataPropertiesToRemove()));
        case "AdditionalInferenceSpecificationsToAdd":
            return Optional.ofNullable(clazz.cast(additionalInferenceSpecificationsToAdd()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "SourceUri":
            return Optional.ofNullable(clazz.cast(sourceUri()));
        case "ModelCard":
            return Optional.ofNullable(clazz.cast(modelCard()));
        case "ModelLifeCycle":
            return Optional.ofNullable(clazz.cast(modelLifeCycle()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelPackageRequest, T> g) {
        return obj -> g.apply((UpdateModelPackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateModelPackageRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(String modelApprovalStatus);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus);

        /**
         * <p>
         * A description for the approval status of the model.
         * </p>
         * 
         * @param approvalDescription
         *        A description for the approval status of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDescription(String approvalDescription);

        /**
         * <p>
         * The metadata properties associated with the model package versions.
         * </p>
         * 
         * @param customerMetadataProperties
         *        The metadata properties associated with the model package versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetadataProperties(Map<String, String> customerMetadataProperties);

        /**
         * <p>
         * The metadata properties associated with the model package versions to remove.
         * </p>
         * 
         * @param customerMetadataPropertiesToRemove
         *        The metadata properties associated with the model package versions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove);

        /**
         * <p>
         * The metadata properties associated with the model package versions to remove.
         * </p>
         * 
         * @param customerMetadataPropertiesToRemove
         *        The metadata properties associated with the model package versions to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerMetadataPropertiesToRemove(String... customerMetadataPropertiesToRemove);

        /**
         * <p>
         * An array of additional Inference Specification objects to be added to the existing array additional Inference
         * Specification. Total number of additional Inference Specifications can not exceed 15. Each additional
         * Inference Specification specifies artifacts based on this model package that can be used on inference
         * endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * </p>
         * 
         * @param additionalInferenceSpecificationsToAdd
         *        An array of additional Inference Specification objects to be added to the existing array additional
         *        Inference Specification. Total number of additional Inference Specifications can not exceed 15. Each
         *        additional Inference Specification specifies artifacts based on this model package that can be used on
         *        inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInferenceSpecificationsToAdd(
                Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd);

        /**
         * <p>
         * An array of additional Inference Specification objects to be added to the existing array additional Inference
         * Specification. Total number of additional Inference Specifications can not exceed 15. Each additional
         * Inference Specification specifies artifacts based on this model package that can be used on inference
         * endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * </p>
         * 
         * @param additionalInferenceSpecificationsToAdd
         *        An array of additional Inference Specification objects to be added to the existing array additional
         *        Inference Specification. Total number of additional Inference Specifications can not exceed 15. Each
         *        additional Inference Specification specifies artifacts based on this model package that can be used on
         *        inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInferenceSpecificationsToAdd(
                AdditionalInferenceSpecificationDefinition... additionalInferenceSpecificationsToAdd);

        /**
         * <p>
         * An array of additional Inference Specification objects to be added to the existing array additional Inference
         * Specification. Total number of additional Inference Specifications can not exceed 15. Each additional
         * Inference Specification specifies artifacts based on this model package that can be used on inference
         * endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalInferenceSpecificationsToAdd(List<AdditionalInferenceSpecificationDefinition>)}.
         * 
         * @param additionalInferenceSpecificationsToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AdditionalInferenceSpecificationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #additionalInferenceSpecificationsToAdd(java.util.Collection<AdditionalInferenceSpecificationDefinition>)
         */
        Builder additionalInferenceSpecificationsToAdd(
                Consumer<AdditionalInferenceSpecificationDefinition.Builder>... additionalInferenceSpecificationsToAdd);

        /**
         * <p>
         * Specifies details about inference jobs that you can run with models based on this model package, including
         * the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance types that the model package supports for transform jobs and real-time endpoints used for
         * inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * The input and output content formats that the model package supports for inference.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inferenceSpecification
         *        Specifies details about inference jobs that you can run with models based on this model package,
         *        including the following information:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The Amazon ECR paths of containers that contain the inference code and model artifacts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The instance types that the model package supports for transform jobs and real-time endpoints used for
         *        inference.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The input and output content formats that the model package supports for inference.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * <p>
         * Specifies details about inference jobs that you can run with models based on this model package, including
         * the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * </p>
         * </li>
         * <li>
         * <p>
         * The instance types that the model package supports for transform jobs and real-time endpoints used for
         * inference.
         * </p>
         * </li>
         * <li>
         * <p>
         * The input and output content formats that the model package supports for inference.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InferenceSpecification.Builder} avoiding
         * the need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * The URI of the source for the model package.
         * </p>
         * 
         * @param sourceUri
         *        The URI of the source for the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUri(String sourceUri);

        /**
         * <p>
         * The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model
         * package, it is a specific usage of a model card and its schema is simplified compared to the schema of
         * <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
         * <code>model_package_details</code>, and <code>model_overview</code> is composed of the
         * <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model
         * package model card schema, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model
         * package model card schema</a>. For more information about the model card associated with the model package,
         * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of
         * a Model Version</a>.
         * </p>
         * 
         * @param modelCard
         *        The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to
         *        a model package, it is a specific usage of a model card and its schema is simplified compared to the
         *        schema of <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
         *        <code>model_package_details</code>, and <code>model_overview</code> is composed of the
         *        <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the
         *        model package model card schema, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema"
         *        >Model package model card schema</a>. For more information about the model card associated with the
         *        model package, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of
         *        a Model Version</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCard(ModelPackageModelCard modelCard);

        /**
         * <p>
         * The model card associated with the model package. Since <code>ModelPackageModelCard</code> is tied to a model
         * package, it is a specific usage of a model card and its schema is simplified compared to the schema of
         * <code>ModelCard</code>. The <code>ModelPackageModelCard</code> schema does not include
         * <code>model_package_details</code>, and <code>model_overview</code> is composed of the
         * <code>model_creator</code> and <code>model_artifact</code> properties. For more information about the model
         * package model card schema, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema">Model
         * package model card schema</a>. For more information about the model card associated with the model package,
         * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html">View the Details of
         * a Model Version</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPackageModelCard.Builder} avoiding
         * the need to create one manually via {@link ModelPackageModelCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPackageModelCard.Builder#build()} is called immediately and
         * its result is passed to {@link #modelCard(ModelPackageModelCard)}.
         * 
         * @param modelCard
         *        a consumer that will call methods on {@link ModelPackageModelCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCard(ModelPackageModelCard)
         */
        default Builder modelCard(Consumer<ModelPackageModelCard.Builder> modelCard) {
            return modelCard(ModelPackageModelCard.builder().applyMutation(modelCard).build());
        }

        /**
         * <p>
         * A structure describing the current state of the model in its life cycle.
         * </p>
         * 
         * @param modelLifeCycle
         *        A structure describing the current state of the model in its life cycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelLifeCycle(ModelLifeCycle modelLifeCycle);

        /**
         * <p>
         * A structure describing the current state of the model in its life cycle.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelLifeCycle.Builder} avoiding the need
         * to create one manually via {@link ModelLifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelLifeCycle.Builder#build()} is called immediately and its
         * result is passed to {@link #modelLifeCycle(ModelLifeCycle)}.
         * 
         * @param modelLifeCycle
         *        a consumer that will call methods on {@link ModelLifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelLifeCycle(ModelLifeCycle)
         */
        default Builder modelLifeCycle(Consumer<ModelLifeCycle.Builder> modelLifeCycle) {
            return modelLifeCycle(ModelLifeCycle.builder().applyMutation(modelLifeCycle).build());
        }

        /**
         * <p>
         * A unique token that guarantees that the call to this API is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A unique token that guarantees that the call to this API is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String modelPackageArn;

        private String modelApprovalStatus;

        private String approvalDescription;

        private Map<String, String> customerMetadataProperties = DefaultSdkAutoConstructMap.getInstance();

        private List<String> customerMetadataPropertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd = DefaultSdkAutoConstructList
                .getInstance();

        private InferenceSpecification inferenceSpecification;

        private String sourceUri;

        private ModelPackageModelCard modelCard;

        private ModelLifeCycle modelLifeCycle;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelPackageRequest model) {
            super(model);
            modelPackageArn(model.modelPackageArn);
            modelApprovalStatus(model.modelApprovalStatus);
            approvalDescription(model.approvalDescription);
            customerMetadataProperties(model.customerMetadataProperties);
            customerMetadataPropertiesToRemove(model.customerMetadataPropertiesToRemove);
            additionalInferenceSpecificationsToAdd(model.additionalInferenceSpecificationsToAdd);
            inferenceSpecification(model.inferenceSpecification);
            sourceUri(model.sourceUri);
            modelCard(model.modelCard);
            modelLifeCycle(model.modelLifeCycle);
            clientToken(model.clientToken);
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelApprovalStatus() {
            return modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final String getApprovalDescription() {
            return approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        public final Map<String, String> getCustomerMetadataProperties() {
            if (customerMetadataProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customerMetadataProperties;
        }

        public final void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
        }

        @Override
        public final Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.customerMetadataProperties = CustomerMetadataMapCopier.copy(customerMetadataProperties);
            return this;
        }

        public final Collection<String> getCustomerMetadataPropertiesToRemove() {
            if (customerMetadataPropertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return customerMetadataPropertiesToRemove;
        }

        public final void setCustomerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
        }

        @Override
        public final Builder customerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove = CustomerMetadataKeyListCopier.copy(customerMetadataPropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerMetadataPropertiesToRemove(String... customerMetadataPropertiesToRemove) {
            customerMetadataPropertiesToRemove(Arrays.asList(customerMetadataPropertiesToRemove));
            return this;
        }

        public final List<AdditionalInferenceSpecificationDefinition.Builder> getAdditionalInferenceSpecificationsToAdd() {
            List<AdditionalInferenceSpecificationDefinition.Builder> result = AdditionalInferenceSpecificationsCopier
                    .copyToBuilder(this.additionalInferenceSpecificationsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalInferenceSpecificationsToAdd(
                Collection<AdditionalInferenceSpecificationDefinition.BuilderImpl> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier
                    .copyFromBuilder(additionalInferenceSpecificationsToAdd);
        }

        @Override
        public final Builder additionalInferenceSpecificationsToAdd(
                Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsCopier
                    .copy(additionalInferenceSpecificationsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(
                AdditionalInferenceSpecificationDefinition... additionalInferenceSpecificationsToAdd) {
            additionalInferenceSpecificationsToAdd(Arrays.asList(additionalInferenceSpecificationsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalInferenceSpecificationsToAdd(
                Consumer<AdditionalInferenceSpecificationDefinition.Builder>... additionalInferenceSpecificationsToAdd) {
            additionalInferenceSpecificationsToAdd(Stream.of(additionalInferenceSpecificationsToAdd)
                    .map(c -> AdditionalInferenceSpecificationDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final String getSourceUri() {
            return sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final ModelPackageModelCard.Builder getModelCard() {
            return modelCard != null ? modelCard.toBuilder() : null;
        }

        public final void setModelCard(ModelPackageModelCard.BuilderImpl modelCard) {
            this.modelCard = modelCard != null ? modelCard.build() : null;
        }

        @Override
        public final Builder modelCard(ModelPackageModelCard modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        public final ModelLifeCycle.Builder getModelLifeCycle() {
            return modelLifeCycle != null ? modelLifeCycle.toBuilder() : null;
        }

        public final void setModelLifeCycle(ModelLifeCycle.BuilderImpl modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle != null ? modelLifeCycle.build() : null;
        }

        @Override
        public final Builder modelLifeCycle(ModelLifeCycle modelLifeCycle) {
            this.modelLifeCycle = modelLifeCycle;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelPackageRequest build() {
            return new UpdateModelPackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
