/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMonitoringAlertRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateMonitoringAlertRequest.Builder, UpdateMonitoringAlertRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(UpdateMonitoringAlertRequest::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringAlertName").getter(getter(UpdateMonitoringAlertRequest::monitoringAlertName))
            .setter(setter(Builder::monitoringAlertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertName").build())
            .build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALERT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlert").getter(getter(UpdateMonitoringAlertRequest::datapointsToAlert))
            .setter(setter(Builder::datapointsToAlert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlert").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriod").getter(getter(UpdateMonitoringAlertRequest::evaluationPeriod))
            .setter(setter(Builder::evaluationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_ALERT_NAME_FIELD, DATAPOINTS_TO_ALERT_FIELD, EVALUATION_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MonitoringScheduleName", MONITORING_SCHEDULE_NAME_FIELD);
                    put("MonitoringAlertName", MONITORING_ALERT_NAME_FIELD);
                    put("DatapointsToAlert", DATAPOINTS_TO_ALERT_FIELD);
                    put("EvaluationPeriod", EVALUATION_PERIOD_FIELD);
                }
            });

    private final String monitoringScheduleName;

    private final String monitoringAlertName;

    private final Integer datapointsToAlert;

    private final Integer evaluationPeriod;

    private UpdateMonitoringAlertRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringAlertName = builder.monitoringAlertName;
        this.datapointsToAlert = builder.datapointsToAlert;
        this.evaluationPeriod = builder.evaluationPeriod;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @return The name of a monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @return The name of a monitoring alert.
     */
    public final String monitoringAlertName() {
        return monitoringAlertName;
    }

    /**
     * <p>
     * Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
     * </p>
     * 
     * @return Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
     */
    public final Integer datapointsToAlert() {
        return datapointsToAlert;
    }

    /**
     * <p>
     * The number of most recent monitoring executions to consider when evaluating alert status.
     * </p>
     * 
     * @return The number of most recent monitoring executions to consider when evaluating alert status.
     */
    public final Integer evaluationPeriod() {
        return evaluationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAlertName());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlert());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringAlertRequest)) {
            return false;
        }
        UpdateMonitoringAlertRequest other = (UpdateMonitoringAlertRequest) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringAlertName(), other.monitoringAlertName())
                && Objects.equals(datapointsToAlert(), other.datapointsToAlert())
                && Objects.equals(evaluationPeriod(), other.evaluationPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMonitoringAlertRequest").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringAlertName", monitoringAlertName()).add("DatapointsToAlert", datapointsToAlert())
                .add("EvaluationPeriod", evaluationPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringAlertName":
            return Optional.ofNullable(clazz.cast(monitoringAlertName()));
        case "DatapointsToAlert":
            return Optional.ofNullable(clazz.cast(datapointsToAlert()));
        case "EvaluationPeriod":
            return Optional.ofNullable(clazz.cast(evaluationPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringAlertRequest, T> g) {
        return obj -> g.apply((UpdateMonitoringAlertRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMonitoringAlertRequest> {
        /**
         * <p>
         * The name of a monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of a monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The name of a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertName
         *        The name of a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertName(String monitoringAlertName);

        /**
         * <p>
         * Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
         * </p>
         * 
         * @param datapointsToAlert
         *        Within <code>EvaluationPeriod</code>, how many execution failures will raise an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlert(Integer datapointsToAlert);

        /**
         * <p>
         * The number of most recent monitoring executions to consider when evaluating alert status.
         * </p>
         * 
         * @param evaluationPeriod
         *        The number of most recent monitoring executions to consider when evaluating alert status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriod(Integer evaluationPeriod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String monitoringAlertName;

        private Integer datapointsToAlert;

        private Integer evaluationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringAlertRequest model) {
            super(model);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringAlertName(model.monitoringAlertName);
            datapointsToAlert(model.datapointsToAlert);
            evaluationPeriod(model.evaluationPeriod);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final String getMonitoringAlertName() {
            return monitoringAlertName;
        }

        public final void setMonitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
        }

        @Override
        public final Builder monitoringAlertName(String monitoringAlertName) {
            this.monitoringAlertName = monitoringAlertName;
            return this;
        }

        public final Integer getDatapointsToAlert() {
            return datapointsToAlert;
        }

        public final void setDatapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
        }

        @Override
        public final Builder datapointsToAlert(Integer datapointsToAlert) {
            this.datapointsToAlert = datapointsToAlert;
            return this;
        }

        public final Integer getEvaluationPeriod() {
            return evaluationPeriod;
        }

        public final void setEvaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
        }

        @Override
        public final Builder evaluationPeriod(Integer evaluationPeriod) {
            this.evaluationPeriod = evaluationPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitoringAlertRequest build() {
            return new UpdateMonitoringAlertRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
