/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanOffering;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanOfferingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTrainingPlanOfferingsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, SearchTrainingPlanOfferingsResponse> {
    private static final SdkField<List<TrainingPlanOffering>> TRAINING_PLAN_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingPlanOfferings").getter(SearchTrainingPlanOfferingsResponse.getter(SearchTrainingPlanOfferingsResponse::trainingPlanOfferings)).setter(SearchTrainingPlanOfferingsResponse.setter(Builder::trainingPlanOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrainingPlanOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_OFFERINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrainingPlanOfferings", TRAINING_PLAN_OFFERINGS_FIELD);
        }
    });
    private final List<TrainingPlanOffering> trainingPlanOfferings;

    private SearchTrainingPlanOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.trainingPlanOfferings = builder.trainingPlanOfferings;
    }

    public final boolean hasTrainingPlanOfferings() {
        return this.trainingPlanOfferings != null && !(this.trainingPlanOfferings instanceof SdkAutoConstructList);
    }

    public final List<TrainingPlanOffering> trainingPlanOfferings() {
        return this.trainingPlanOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingPlanOfferings() ? this.trainingPlanOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTrainingPlanOfferingsResponse)) {
            return false;
        }
        SearchTrainingPlanOfferingsResponse other = (SearchTrainingPlanOfferingsResponse)((Object)obj);
        return this.hasTrainingPlanOfferings() == other.hasTrainingPlanOfferings() && Objects.equals(this.trainingPlanOfferings(), other.trainingPlanOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTrainingPlanOfferingsResponse").add("TrainingPlanOfferings", this.hasTrainingPlanOfferings() ? this.trainingPlanOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingPlanOfferings": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTrainingPlanOfferingsResponse, T> g) {
        return obj -> g.apply((SearchTrainingPlanOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<TrainingPlanOffering> trainingPlanOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTrainingPlanOfferingsResponse model) {
            super(model);
            this.trainingPlanOfferings(model.trainingPlanOfferings);
        }

        public final List<TrainingPlanOffering.Builder> getTrainingPlanOfferings() {
            List<TrainingPlanOffering.Builder> result = TrainingPlanOfferingsCopier.copyToBuilder(this.trainingPlanOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingPlanOfferings(Collection<TrainingPlanOffering.BuilderImpl> trainingPlanOfferings) {
            this.trainingPlanOfferings = TrainingPlanOfferingsCopier.copyFromBuilder(trainingPlanOfferings);
        }

        @Override
        public final Builder trainingPlanOfferings(Collection<TrainingPlanOffering> trainingPlanOfferings) {
            this.trainingPlanOfferings = TrainingPlanOfferingsCopier.copy(trainingPlanOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanOfferings(TrainingPlanOffering ... trainingPlanOfferings) {
            this.trainingPlanOfferings(Arrays.asList(trainingPlanOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingPlanOfferings(Consumer<TrainingPlanOffering.Builder> ... trainingPlanOfferings) {
            this.trainingPlanOfferings(Stream.of(trainingPlanOfferings).map(c -> (TrainingPlanOffering)((TrainingPlanOffering.Builder)TrainingPlanOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchTrainingPlanOfferingsResponse build() {
            return new SearchTrainingPlanOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTrainingPlanOfferingsResponse> {
        public Builder trainingPlanOfferings(Collection<TrainingPlanOffering> var1);

        public Builder trainingPlanOfferings(TrainingPlanOffering ... var1);

        public Builder trainingPlanOfferings(Consumer<TrainingPlanOffering.Builder> ... var1);
    }
}

