/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure describing the source of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionSource implements SdkPojo, Serializable, ToCopyableBuilder<ActionSource.Builder, ActionSource> {
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUri").getter(getter(ActionSource::sourceUri)).setter(setter(Builder::sourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(ActionSource::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceId").getter(getter(ActionSource::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_URI_FIELD,
            SOURCE_TYPE_FIELD, SOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceUri;

    private final String sourceType;

    private final String sourceId;

    private ActionSource(BuilderImpl builder) {
        this.sourceUri = builder.sourceUri;
        this.sourceType = builder.sourceType;
        this.sourceId = builder.sourceId;
    }

    /**
     * <p>
     * The URI of the source.
     * </p>
     * 
     * @return The URI of the source.
     */
    public final String sourceUri() {
        return sourceUri;
    }

    /**
     * <p>
     * The type of the source.
     * </p>
     * 
     * @return The type of the source.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The ID of the source.
     * </p>
     * 
     * @return The ID of the source.
     */
    public final String sourceId() {
        return sourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionSource)) {
            return false;
        }
        ActionSource other = (ActionSource) obj;
        return Objects.equals(sourceUri(), other.sourceUri()) && Objects.equals(sourceType(), other.sourceType())
                && Objects.equals(sourceId(), other.sourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionSource").add("SourceUri", sourceUri()).add("SourceType", sourceType())
                .add("SourceId", sourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceUri":
            return Optional.ofNullable(clazz.cast(sourceUri()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceUri", SOURCE_URI_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("SourceId", SOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionSource, T> g) {
        return obj -> g.apply((ActionSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionSource> {
        /**
         * <p>
         * The URI of the source.
         * </p>
         * 
         * @param sourceUri
         *        The URI of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUri(String sourceUri);

        /**
         * <p>
         * The type of the source.
         * </p>
         * 
         * @param sourceType
         *        The type of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The ID of the source.
         * </p>
         * 
         * @param sourceId
         *        The ID of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);
    }

    static final class BuilderImpl implements Builder {
        private String sourceUri;

        private String sourceType;

        private String sourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionSource model) {
            sourceUri(model.sourceUri);
            sourceType(model.sourceType);
            sourceId(model.sourceId);
        }

        public final String getSourceUri() {
            return sourceUri;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        public ActionSource build() {
            return new ActionSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
