/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration for how an endpoint performs asynchronous inference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInferenceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInferenceConfig.Builder, AsyncInferenceConfig> {
    private static final SdkField<AsyncInferenceClientConfig> CLIENT_CONFIG_FIELD = SdkField
            .<AsyncInferenceClientConfig> builder(MarshallingType.SDK_POJO).memberName("ClientConfig")
            .getter(getter(AsyncInferenceConfig::clientConfig)).setter(setter(Builder::clientConfig))
            .constructor(AsyncInferenceClientConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConfig").build()).build();

    private static final SdkField<AsyncInferenceOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<AsyncInferenceOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(AsyncInferenceConfig::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(AsyncInferenceOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CONFIG_FIELD,
            OUTPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AsyncInferenceClientConfig clientConfig;

    private final AsyncInferenceOutputConfig outputConfig;

    private AsyncInferenceConfig(BuilderImpl builder) {
        this.clientConfig = builder.clientConfig;
        this.outputConfig = builder.outputConfig;
    }

    /**
     * <p>
     * Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous
     * inference.
     * </p>
     * 
     * @return Configures the behavior of the client used by SageMaker to interact with the model container during
     *         asynchronous inference.
     */
    public final AsyncInferenceClientConfig clientConfig() {
        return clientConfig;
    }

    /**
     * <p>
     * Specifies the configuration for asynchronous inference invocation outputs.
     * </p>
     * 
     * @return Specifies the configuration for asynchronous inference invocation outputs.
     */
    public final AsyncInferenceOutputConfig outputConfig() {
        return outputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceConfig)) {
            return false;
        }
        AsyncInferenceConfig other = (AsyncInferenceConfig) obj;
        return Objects.equals(clientConfig(), other.clientConfig()) && Objects.equals(outputConfig(), other.outputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInferenceConfig").add("ClientConfig", clientConfig()).add("OutputConfig", outputConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientConfig":
            return Optional.ofNullable(clazz.cast(clientConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientConfig", CLIENT_CONFIG_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceConfig, T> g) {
        return obj -> g.apply((AsyncInferenceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInferenceConfig> {
        /**
         * <p>
         * Configures the behavior of the client used by SageMaker to interact with the model container during
         * asynchronous inference.
         * </p>
         * 
         * @param clientConfig
         *        Configures the behavior of the client used by SageMaker to interact with the model container during
         *        asynchronous inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConfig(AsyncInferenceClientConfig clientConfig);

        /**
         * <p>
         * Configures the behavior of the client used by SageMaker to interact with the model container during
         * asynchronous inference.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncInferenceClientConfig.Builder}
         * avoiding the need to create one manually via {@link AsyncInferenceClientConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsyncInferenceClientConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #clientConfig(AsyncInferenceClientConfig)}.
         * 
         * @param clientConfig
         *        a consumer that will call methods on {@link AsyncInferenceClientConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientConfig(AsyncInferenceClientConfig)
         */
        default Builder clientConfig(Consumer<AsyncInferenceClientConfig.Builder> clientConfig) {
            return clientConfig(AsyncInferenceClientConfig.builder().applyMutation(clientConfig).build());
        }

        /**
         * <p>
         * Specifies the configuration for asynchronous inference invocation outputs.
         * </p>
         * 
         * @param outputConfig
         *        Specifies the configuration for asynchronous inference invocation outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(AsyncInferenceOutputConfig outputConfig);

        /**
         * <p>
         * Specifies the configuration for asynchronous inference invocation outputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncInferenceOutputConfig.Builder}
         * avoiding the need to create one manually via {@link AsyncInferenceOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsyncInferenceOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(AsyncInferenceOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link AsyncInferenceOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(AsyncInferenceOutputConfig)
         */
        default Builder outputConfig(Consumer<AsyncInferenceOutputConfig.Builder> outputConfig) {
            return outputConfig(AsyncInferenceOutputConfig.builder().applyMutation(outputConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AsyncInferenceClientConfig clientConfig;

        private AsyncInferenceOutputConfig outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceConfig model) {
            clientConfig(model.clientConfig);
            outputConfig(model.outputConfig);
        }

        public final AsyncInferenceClientConfig.Builder getClientConfig() {
            return clientConfig != null ? clientConfig.toBuilder() : null;
        }

        public final void setClientConfig(AsyncInferenceClientConfig.BuilderImpl clientConfig) {
            this.clientConfig = clientConfig != null ? clientConfig.build() : null;
        }

        @Override
        public final Builder clientConfig(AsyncInferenceClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public final AsyncInferenceOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(AsyncInferenceOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(AsyncInferenceOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public AsyncInferenceConfig build() {
            return new AsyncInferenceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
