/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This data type is intended for use exclusively by SageMaker Canvas and cannot be used in other contexts at the
 * moment.
 * </p>
 * </note>
 * <p>
 * Specifies the compute configuration for an AutoML job V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLComputeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLComputeConfig.Builder, AutoMLComputeConfig> {
    private static final SdkField<EmrServerlessComputeConfig> EMR_SERVERLESS_COMPUTE_CONFIG_FIELD = SdkField
            .<EmrServerlessComputeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("EmrServerlessComputeConfig")
            .getter(getter(AutoMLComputeConfig::emrServerlessComputeConfig))
            .setter(setter(Builder::emrServerlessComputeConfig))
            .constructor(EmrServerlessComputeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrServerlessComputeConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EMR_SERVERLESS_COMPUTE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EmrServerlessComputeConfig emrServerlessComputeConfig;

    private AutoMLComputeConfig(BuilderImpl builder) {
        this.emrServerlessComputeConfig = builder.emrServerlessComputeConfig;
    }

    /**
     * <p>
     * The configuration for using <a
     * href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html"> EMR Serverless</a> to
     * run the AutoML job V2.
     * </p>
     * <p>
     * To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional compute
     * resources are needed to process large datasets, you need to provide an <code>EmrServerlessComputeConfig</code>
     * object, which includes an <code>ExecutionRoleARN</code> attribute, to the <code>AutoMLComputeConfig</code> of the
     * AutoML job V2 input request.
     * </p>
     * <p>
     * By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that would
     * otherwise exceed the initially provisioned resources, without any manual intervention from you.
     * </p>
     * <p>
     * EMR Serverless is available for the tabular and time series problem types. We recommend setting up this option
     * for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
     * </p>
     * 
     * @return The configuration for using <a
     *         href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html"> EMR
     *         Serverless</a> to run the AutoML job V2.</p>
     *         <p>
     *         To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional
     *         compute resources are needed to process large datasets, you need to provide an
     *         <code>EmrServerlessComputeConfig</code> object, which includes an <code>ExecutionRoleARN</code>
     *         attribute, to the <code>AutoMLComputeConfig</code> of the AutoML job V2 input request.
     *         </p>
     *         <p>
     *         By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that
     *         would otherwise exceed the initially provisioned resources, without any manual intervention from you.
     *         </p>
     *         <p>
     *         EMR Serverless is available for the tabular and time series problem types. We recommend setting up this
     *         option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
     */
    public final EmrServerlessComputeConfig emrServerlessComputeConfig() {
        return emrServerlessComputeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emrServerlessComputeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLComputeConfig)) {
            return false;
        }
        AutoMLComputeConfig other = (AutoMLComputeConfig) obj;
        return Objects.equals(emrServerlessComputeConfig(), other.emrServerlessComputeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLComputeConfig").add("EmrServerlessComputeConfig", emrServerlessComputeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmrServerlessComputeConfig":
            return Optional.ofNullable(clazz.cast(emrServerlessComputeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmrServerlessComputeConfig", EMR_SERVERLESS_COMPUTE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLComputeConfig, T> g) {
        return obj -> g.apply((AutoMLComputeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLComputeConfig> {
        /**
         * <p>
         * The configuration for using <a
         * href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html"> EMR
         * Serverless</a> to run the AutoML job V2.
         * </p>
         * <p>
         * To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional compute
         * resources are needed to process large datasets, you need to provide an
         * <code>EmrServerlessComputeConfig</code> object, which includes an <code>ExecutionRoleARN</code> attribute, to
         * the <code>AutoMLComputeConfig</code> of the AutoML job V2 input request.
         * </p>
         * <p>
         * By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that would
         * otherwise exceed the initially provisioned resources, without any manual intervention from you.
         * </p>
         * <p>
         * EMR Serverless is available for the tabular and time series problem types. We recommend setting up this
         * option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
         * </p>
         * 
         * @param emrServerlessComputeConfig
         *        The configuration for using <a
         *        href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html"> EMR
         *        Serverless</a> to run the AutoML job V2.</p>
         *        <p>
         *        To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional
         *        compute resources are needed to process large datasets, you need to provide an
         *        <code>EmrServerlessComputeConfig</code> object, which includes an <code>ExecutionRoleARN</code>
         *        attribute, to the <code>AutoMLComputeConfig</code> of the AutoML job V2 input request.
         *        </p>
         *        <p>
         *        By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that
         *        would otherwise exceed the initially provisioned resources, without any manual intervention from you.
         *        </p>
         *        <p>
         *        EMR Serverless is available for the tabular and time series problem types. We recommend setting up
         *        this option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emrServerlessComputeConfig(EmrServerlessComputeConfig emrServerlessComputeConfig);

        /**
         * <p>
         * The configuration for using <a
         * href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html"> EMR
         * Serverless</a> to run the AutoML job V2.
         * </p>
         * <p>
         * To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional compute
         * resources are needed to process large datasets, you need to provide an
         * <code>EmrServerlessComputeConfig</code> object, which includes an <code>ExecutionRoleARN</code> attribute, to
         * the <code>AutoMLComputeConfig</code> of the AutoML job V2 input request.
         * </p>
         * <p>
         * By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that would
         * otherwise exceed the initially provisioned resources, without any manual intervention from you.
         * </p>
         * <p>
         * EMR Serverless is available for the tabular and time series problem types. We recommend setting up this
         * option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmrServerlessComputeConfig.Builder}
         * avoiding the need to create one manually via {@link EmrServerlessComputeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmrServerlessComputeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #emrServerlessComputeConfig(EmrServerlessComputeConfig)}.
         * 
         * @param emrServerlessComputeConfig
         *        a consumer that will call methods on {@link EmrServerlessComputeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emrServerlessComputeConfig(EmrServerlessComputeConfig)
         */
        default Builder emrServerlessComputeConfig(Consumer<EmrServerlessComputeConfig.Builder> emrServerlessComputeConfig) {
            return emrServerlessComputeConfig(EmrServerlessComputeConfig.builder().applyMutation(emrServerlessComputeConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EmrServerlessComputeConfig emrServerlessComputeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLComputeConfig model) {
            emrServerlessComputeConfig(model.emrServerlessComputeConfig);
        }

        public final EmrServerlessComputeConfig.Builder getEmrServerlessComputeConfig() {
            return emrServerlessComputeConfig != null ? emrServerlessComputeConfig.toBuilder() : null;
        }

        public final void setEmrServerlessComputeConfig(EmrServerlessComputeConfig.BuilderImpl emrServerlessComputeConfig) {
            this.emrServerlessComputeConfig = emrServerlessComputeConfig != null ? emrServerlessComputeConfig.build() : null;
        }

        @Override
        public final Builder emrServerlessComputeConfig(EmrServerlessComputeConfig emrServerlessComputeConfig) {
            this.emrServerlessComputeConfig = emrServerlessComputeConfig;
            return this;
        }

        @Override
        public AutoMLComputeConfig build() {
            return new AutoMLComputeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
