/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary about an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLJobSummary.Builder, AutoMLJobSummary> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(AutoMLJobSummary::autoMLJobName)).setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobArn").getter(getter(AutoMLJobSummary::autoMLJobArn)).setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobStatus").getter(getter(AutoMLJobSummary::autoMLJobStatusAsString))
            .setter(setter(Builder::autoMLJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobSecondaryStatus").getter(getter(AutoMLJobSummary::autoMLJobSecondaryStatusAsString))
            .setter(setter(Builder::autoMLJobSecondaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AutoMLJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(AutoMLJobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(AutoMLJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(AutoMLJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<List<AutoMLPartialFailureReason>> PARTIAL_FAILURE_REASONS_FIELD = SdkField
            .<List<AutoMLPartialFailureReason>> builder(MarshallingType.LIST)
            .memberName("PartialFailureReasons")
            .getter(getter(AutoMLJobSummary::partialFailureReasons))
            .setter(setter(Builder::partialFailureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLPartialFailureReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLPartialFailureReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            AUTO_ML_JOB_ARN_FIELD, AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, CREATION_TIME_FIELD,
            END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, PARTIAL_FAILURE_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autoMLJobName;

    private final String autoMLJobArn;

    private final String autoMLJobStatus;

    private final String autoMLJobSecondaryStatus;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final List<AutoMLPartialFailureReason> partialFailureReasons;

    private AutoMLJobSummary(BuilderImpl builder) {
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.partialFailureReasons = builder.partialFailureReasons;
    }

    /**
     * <p>
     * The name of the AutoML job you are requesting.
     * </p>
     * 
     * @return The name of the AutoML job you are requesting.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * <p>
     * The ARN of the AutoML job.
     * </p>
     * 
     * @return The ARN of the AutoML job.
     */
    public final String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * <p>
     * The status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return The status of the AutoML job.
     * @see AutoMLJobStatus
     */
    public final AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(autoMLJobStatus);
    }

    /**
     * <p>
     * The status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return The status of the AutoML job.
     * @see AutoMLJobStatus
     */
    public final String autoMLJobStatusAsString() {
        return autoMLJobStatus;
    }

    /**
     * <p>
     * The secondary status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return The secondary status of the AutoML job.
     * @see AutoMLJobSecondaryStatus
     */
    public final AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(autoMLJobSecondaryStatus);
    }

    /**
     * <p>
     * The secondary status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return The secondary status of the AutoML job.
     * @see AutoMLJobSecondaryStatus
     */
    public final String autoMLJobSecondaryStatusAsString() {
        return autoMLJobSecondaryStatus;
    }

    /**
     * <p>
     * When the AutoML job was created.
     * </p>
     * 
     * @return When the AutoML job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The end time of an AutoML job.
     * </p>
     * 
     * @return The end time of an AutoML job.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * When the AutoML job was last modified.
     * </p>
     * 
     * @return When the AutoML job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason of an AutoML job.
     * </p>
     * 
     * @return The failure reason of an AutoML job.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartialFailureReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPartialFailureReasons() {
        return partialFailureReasons != null && !(partialFailureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of reasons for partial failures within an AutoML job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartialFailureReasons} method.
     * </p>
     * 
     * @return The list of reasons for partial failures within an AutoML job.
     */
    public final List<AutoMLPartialFailureReason> partialFailureReasons() {
        return partialFailureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartialFailureReasons() ? partialFailureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobSummary)) {
            return false;
        }
        AutoMLJobSummary other = (AutoMLJobSummary) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName()) && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && Objects.equals(autoMLJobStatusAsString(), other.autoMLJobStatusAsString())
                && Objects.equals(autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && hasPartialFailureReasons() == other.hasPartialFailureReasons()
                && Objects.equals(partialFailureReasons(), other.partialFailureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLJobSummary").add("AutoMLJobName", autoMLJobName()).add("AutoMLJobArn", autoMLJobArn())
                .add("AutoMLJobStatus", autoMLJobStatusAsString())
                .add("AutoMLJobSecondaryStatus", autoMLJobSecondaryStatusAsString()).add("CreationTime", creationTime())
                .add("EndTime", endTime()).add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .add("PartialFailureReasons", hasPartialFailureReasons() ? partialFailureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "AutoMLJobStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobStatusAsString()));
        case "AutoMLJobSecondaryStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobSecondaryStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "PartialFailureReasons":
            return Optional.ofNullable(clazz.cast(partialFailureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoMLJobName", AUTO_ML_JOB_NAME_FIELD);
        map.put("AutoMLJobArn", AUTO_ML_JOB_ARN_FIELD);
        map.put("AutoMLJobStatus", AUTO_ML_JOB_STATUS_FIELD);
        map.put("AutoMLJobSecondaryStatus", AUTO_ML_JOB_SECONDARY_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("PartialFailureReasons", PARTIAL_FAILURE_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobSummary, T> g) {
        return obj -> g.apply((AutoMLJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobSummary> {
        /**
         * <p>
         * The name of the AutoML job you are requesting.
         * </p>
         * 
         * @param autoMLJobName
         *        The name of the AutoML job you are requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * The ARN of the AutoML job.
         * </p>
         * 
         * @param autoMLJobArn
         *        The ARN of the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * The status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobStatus
         *        The status of the AutoML job.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(String autoMLJobStatus);

        /**
         * <p>
         * The status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobStatus
         *        The status of the AutoML job.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus);

        /**
         * <p>
         * The secondary status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        The secondary status of the AutoML job.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus);

        /**
         * <p>
         * The secondary status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        The secondary status of the AutoML job.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus);

        /**
         * <p>
         * When the AutoML job was created.
         * </p>
         * 
         * @param creationTime
         *        When the AutoML job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The end time of an AutoML job.
         * </p>
         * 
         * @param endTime
         *        The end time of an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * When the AutoML job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the AutoML job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason of an AutoML job.
         * </p>
         * 
         * @param failureReason
         *        The failure reason of an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The list of reasons for partial failures within an AutoML job.
         * </p>
         * 
         * @param partialFailureReasons
         *        The list of reasons for partial failures within an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons);

        /**
         * <p>
         * The list of reasons for partial failures within an AutoML job.
         * </p>
         * 
         * @param partialFailureReasons
         *        The list of reasons for partial failures within an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons);

        /**
         * <p>
         * The list of reasons for partial failures within an AutoML job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder#build()} is called
         * immediately and its result is passed to {@link #partialFailureReasons(List<AutoMLPartialFailureReason>)}.
         * 
         * @param partialFailureReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AutoMLPartialFailureReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partialFailureReasons(java.util.Collection<AutoMLPartialFailureReason>)
         */
        Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons);
    }

    static final class BuilderImpl implements Builder {
        private String autoMLJobName;

        private String autoMLJobArn;

        private String autoMLJobStatus;

        private String autoMLJobSecondaryStatus;

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private List<AutoMLPartialFailureReason> partialFailureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobSummary model) {
            autoMLJobName(model.autoMLJobName);
            autoMLJobArn(model.autoMLJobArn);
            autoMLJobStatus(model.autoMLJobStatus);
            autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            partialFailureReasons(model.partialFailureReasons);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final String getAutoMLJobStatus() {
            return autoMLJobStatus;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return autoMLJobSecondaryStatus;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<AutoMLPartialFailureReason.Builder> getPartialFailureReasons() {
            List<AutoMLPartialFailureReason.Builder> result = AutoMLPartialFailureReasonsCopier
                    .copyToBuilder(this.partialFailureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartialFailureReasons(Collection<AutoMLPartialFailureReason.BuilderImpl> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copyFromBuilder(partialFailureReasons);
        }

        @Override
        public final Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copy(partialFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons) {
            partialFailureReasons(Arrays.asList(partialFailureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons) {
            partialFailureReasons(Stream.of(partialFailureReasons)
                    .map(c -> AutoMLPartialFailureReason.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutoMLJobSummary build() {
            return new AutoMLJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
