/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings specific to the problem type used to configure an AutoML job V2. There must be one and only
 * one config of the following type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLProblemTypeConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLProblemTypeConfig.Builder, AutoMLProblemTypeConfig> {
    private static final SdkField<ImageClassificationJobConfig> IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField
            .<ImageClassificationJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ImageClassificationJobConfig")
            .getter(getter(AutoMLProblemTypeConfig::imageClassificationJobConfig))
            .setter(setter(Builder::imageClassificationJobConfig))
            .constructor(ImageClassificationJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageClassificationJobConfig")
                    .build()).build();

    private static final SdkField<TextClassificationJobConfig> TEXT_CLASSIFICATION_JOB_CONFIG_FIELD = SdkField
            .<TextClassificationJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TextClassificationJobConfig")
            .getter(getter(AutoMLProblemTypeConfig::textClassificationJobConfig))
            .setter(setter(Builder::textClassificationJobConfig))
            .constructor(TextClassificationJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextClassificationJobConfig")
                    .build()).build();

    private static final SdkField<TimeSeriesForecastingJobConfig> TIME_SERIES_FORECASTING_JOB_CONFIG_FIELD = SdkField
            .<TimeSeriesForecastingJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesForecastingJobConfig")
            .getter(getter(AutoMLProblemTypeConfig::timeSeriesForecastingJobConfig))
            .setter(setter(Builder::timeSeriesForecastingJobConfig))
            .constructor(TimeSeriesForecastingJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingJobConfig")
                    .build()).build();

    private static final SdkField<TabularJobConfig> TABULAR_JOB_CONFIG_FIELD = SdkField
            .<TabularJobConfig> builder(MarshallingType.SDK_POJO).memberName("TabularJobConfig")
            .getter(getter(AutoMLProblemTypeConfig::tabularJobConfig)).setter(setter(Builder::tabularJobConfig))
            .constructor(TabularJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TabularJobConfig").build()).build();

    private static final SdkField<TextGenerationJobConfig> TEXT_GENERATION_JOB_CONFIG_FIELD = SdkField
            .<TextGenerationJobConfig> builder(MarshallingType.SDK_POJO).memberName("TextGenerationJobConfig")
            .getter(getter(AutoMLProblemTypeConfig::textGenerationJobConfig)).setter(setter(Builder::textGenerationJobConfig))
            .constructor(TextGenerationJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextGenerationJobConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD, TEXT_CLASSIFICATION_JOB_CONFIG_FIELD,
            TIME_SERIES_FORECASTING_JOB_CONFIG_FIELD, TABULAR_JOB_CONFIG_FIELD, TEXT_GENERATION_JOB_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageClassificationJobConfig imageClassificationJobConfig;

    private final TextClassificationJobConfig textClassificationJobConfig;

    private final TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig;

    private final TabularJobConfig tabularJobConfig;

    private final TextGenerationJobConfig textGenerationJobConfig;

    private final Type type;

    private AutoMLProblemTypeConfig(BuilderImpl builder) {
        this.imageClassificationJobConfig = builder.imageClassificationJobConfig;
        this.textClassificationJobConfig = builder.textClassificationJobConfig;
        this.timeSeriesForecastingJobConfig = builder.timeSeriesForecastingJobConfig;
        this.tabularJobConfig = builder.tabularJobConfig;
        this.textGenerationJobConfig = builder.textGenerationJobConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Settings used to configure an AutoML job V2 for the image classification problem type.
     * </p>
     * 
     * @return Settings used to configure an AutoML job V2 for the image classification problem type.
     */
    public final ImageClassificationJobConfig imageClassificationJobConfig() {
        return imageClassificationJobConfig;
    }

    /**
     * <p>
     * Settings used to configure an AutoML job V2 for the text classification problem type.
     * </p>
     * 
     * @return Settings used to configure an AutoML job V2 for the text classification problem type.
     */
    public final TextClassificationJobConfig textClassificationJobConfig() {
        return textClassificationJobConfig;
    }

    /**
     * <p>
     * Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     * </p>
     * 
     * @return Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     */
    public final TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig() {
        return timeSeriesForecastingJobConfig;
    }

    /**
     * <p>
     * Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     * </p>
     * 
     * @return Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     */
    public final TabularJobConfig tabularJobConfig() {
        return tabularJobConfig;
    }

    /**
     * <p>
     * Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.
     * </p>
     * <note>
     * <p>
     * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in regions
     * supported by Canvas. Refer to the documentation of Canvas for the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
     * </p>
     * </note>
     * 
     * @return Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.</p>
     *         <note>
     *         <p>
     *         The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in
     *         regions supported by Canvas. Refer to the documentation of Canvas for the <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported
     *         Regions</a>.
     *         </p>
     */
    public final TextGenerationJobConfig textGenerationJobConfig() {
        return textGenerationJobConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageClassificationJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(textClassificationJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesForecastingJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tabularJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(textGenerationJobConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLProblemTypeConfig)) {
            return false;
        }
        AutoMLProblemTypeConfig other = (AutoMLProblemTypeConfig) obj;
        return Objects.equals(imageClassificationJobConfig(), other.imageClassificationJobConfig())
                && Objects.equals(textClassificationJobConfig(), other.textClassificationJobConfig())
                && Objects.equals(timeSeriesForecastingJobConfig(), other.timeSeriesForecastingJobConfig())
                && Objects.equals(tabularJobConfig(), other.tabularJobConfig())
                && Objects.equals(textGenerationJobConfig(), other.textGenerationJobConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLProblemTypeConfig").add("ImageClassificationJobConfig", imageClassificationJobConfig())
                .add("TextClassificationJobConfig", textClassificationJobConfig())
                .add("TimeSeriesForecastingJobConfig", timeSeriesForecastingJobConfig())
                .add("TabularJobConfig", tabularJobConfig()).add("TextGenerationJobConfig", textGenerationJobConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageClassificationJobConfig":
            return Optional.ofNullable(clazz.cast(imageClassificationJobConfig()));
        case "TextClassificationJobConfig":
            return Optional.ofNullable(clazz.cast(textClassificationJobConfig()));
        case "TimeSeriesForecastingJobConfig":
            return Optional.ofNullable(clazz.cast(timeSeriesForecastingJobConfig()));
        case "TabularJobConfig":
            return Optional.ofNullable(clazz.cast(tabularJobConfig()));
        case "TextGenerationJobConfig":
            return Optional.ofNullable(clazz.cast(textGenerationJobConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #imageClassificationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the image classification problem type.
     * </p>
     * 
     * @param imageClassificationJobConfig
     *        Settings used to configure an AutoML job V2 for the image classification problem type.
     */
    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(
            ImageClassificationJobConfig imageClassificationJobConfig) {
        return builder().imageClassificationJobConfig(imageClassificationJobConfig).build();
    }

    /**
     * Create an instance of this class with {@link #imageClassificationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the image classification problem type.
     * </p>
     * 
     * @param imageClassificationJobConfig
     *        Settings used to configure an AutoML job V2 for the image classification problem type.
     */
    public static AutoMLProblemTypeConfig fromImageClassificationJobConfig(
            Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
        ImageClassificationJobConfig.Builder builder = ImageClassificationJobConfig.builder();
        imageClassificationJobConfig.accept(builder);
        return fromImageClassificationJobConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #textClassificationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the text classification problem type.
     * </p>
     * 
     * @param textClassificationJobConfig
     *        Settings used to configure an AutoML job V2 for the text classification problem type.
     */
    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
        return builder().textClassificationJobConfig(textClassificationJobConfig).build();
    }

    /**
     * Create an instance of this class with {@link #textClassificationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the text classification problem type.
     * </p>
     * 
     * @param textClassificationJobConfig
     *        Settings used to configure an AutoML job V2 for the text classification problem type.
     */
    public static AutoMLProblemTypeConfig fromTextClassificationJobConfig(
            Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
        TextClassificationJobConfig.Builder builder = TextClassificationJobConfig.builder();
        textClassificationJobConfig.accept(builder);
        return fromTextClassificationJobConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #timeSeriesForecastingJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     * </p>
     * 
     * @param timeSeriesForecastingJobConfig
     *        Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     */
    public static AutoMLProblemTypeConfig fromTimeSeriesForecastingJobConfig(
            TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig) {
        return builder().timeSeriesForecastingJobConfig(timeSeriesForecastingJobConfig).build();
    }

    /**
     * Create an instance of this class with {@link #timeSeriesForecastingJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     * </p>
     * 
     * @param timeSeriesForecastingJobConfig
     *        Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
     */
    public static AutoMLProblemTypeConfig fromTimeSeriesForecastingJobConfig(
            Consumer<TimeSeriesForecastingJobConfig.Builder> timeSeriesForecastingJobConfig) {
        TimeSeriesForecastingJobConfig.Builder builder = TimeSeriesForecastingJobConfig.builder();
        timeSeriesForecastingJobConfig.accept(builder);
        return fromTimeSeriesForecastingJobConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tabularJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     * </p>
     * 
     * @param tabularJobConfig
     *        Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     */
    public static AutoMLProblemTypeConfig fromTabularJobConfig(TabularJobConfig tabularJobConfig) {
        return builder().tabularJobConfig(tabularJobConfig).build();
    }

    /**
     * Create an instance of this class with {@link #tabularJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     * </p>
     * 
     * @param tabularJobConfig
     *        Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
     */
    public static AutoMLProblemTypeConfig fromTabularJobConfig(Consumer<TabularJobConfig.Builder> tabularJobConfig) {
        TabularJobConfig.Builder builder = TabularJobConfig.builder();
        tabularJobConfig.accept(builder);
        return fromTabularJobConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #textGenerationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.
     * </p>
     * <note>
     * <p>
     * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in regions
     * supported by Canvas. Refer to the documentation of Canvas for the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
     * </p>
     * </note>
     * 
     * @param textGenerationJobConfig
     *        Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.</p>
     *        <note>
     *        <p>
     *        The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in
     *        regions supported by Canvas. Refer to the documentation of Canvas for the <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
     *        </p>
     */
    public static AutoMLProblemTypeConfig fromTextGenerationJobConfig(TextGenerationJobConfig textGenerationJobConfig) {
        return builder().textGenerationJobConfig(textGenerationJobConfig).build();
    }

    /**
     * Create an instance of this class with {@link #textGenerationJobConfig()} initialized to the given value.
     *
     * <p>
     * Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.
     * </p>
     * <note>
     * <p>
     * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in regions
     * supported by Canvas. Refer to the documentation of Canvas for the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
     * </p>
     * </note>
     * 
     * @param textGenerationJobConfig
     *        Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.</p>
     *        <note>
     *        <p>
     *        The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in
     *        regions supported by Canvas. Refer to the documentation of Canvas for the <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
     *        </p>
     */
    public static AutoMLProblemTypeConfig fromTextGenerationJobConfig(
            Consumer<TextGenerationJobConfig.Builder> textGenerationJobConfig) {
        TextGenerationJobConfig.Builder builder = TextGenerationJobConfig.builder();
        textGenerationJobConfig.accept(builder);
        return fromTextGenerationJobConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImageClassificationJobConfig", IMAGE_CLASSIFICATION_JOB_CONFIG_FIELD);
        map.put("TextClassificationJobConfig", TEXT_CLASSIFICATION_JOB_CONFIG_FIELD);
        map.put("TimeSeriesForecastingJobConfig", TIME_SERIES_FORECASTING_JOB_CONFIG_FIELD);
        map.put("TabularJobConfig", TABULAR_JOB_CONFIG_FIELD);
        map.put("TextGenerationJobConfig", TEXT_GENERATION_JOB_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoMLProblemTypeConfig, T> g) {
        return obj -> g.apply((AutoMLProblemTypeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLProblemTypeConfig> {
        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the image classification problem type.
         * </p>
         * 
         * @param imageClassificationJobConfig
         *        Settings used to configure an AutoML job V2 for the image classification problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig);

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the image classification problem type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageClassificationJobConfig.Builder}
         * avoiding the need to create one manually via {@link ImageClassificationJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageClassificationJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #imageClassificationJobConfig(ImageClassificationJobConfig)}.
         * 
         * @param imageClassificationJobConfig
         *        a consumer that will call methods on {@link ImageClassificationJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageClassificationJobConfig(ImageClassificationJobConfig)
         */
        default Builder imageClassificationJobConfig(Consumer<ImageClassificationJobConfig.Builder> imageClassificationJobConfig) {
            return imageClassificationJobConfig(ImageClassificationJobConfig.builder()
                    .applyMutation(imageClassificationJobConfig).build());
        }

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the text classification problem type.
         * </p>
         * 
         * @param textClassificationJobConfig
         *        Settings used to configure an AutoML job V2 for the text classification problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig);

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the text classification problem type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextClassificationJobConfig.Builder}
         * avoiding the need to create one manually via {@link TextClassificationJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextClassificationJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #textClassificationJobConfig(TextClassificationJobConfig)}.
         * 
         * @param textClassificationJobConfig
         *        a consumer that will call methods on {@link TextClassificationJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textClassificationJobConfig(TextClassificationJobConfig)
         */
        default Builder textClassificationJobConfig(Consumer<TextClassificationJobConfig.Builder> textClassificationJobConfig) {
            return textClassificationJobConfig(TextClassificationJobConfig.builder().applyMutation(textClassificationJobConfig)
                    .build());
        }

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
         * </p>
         * 
         * @param timeSeriesForecastingJobConfig
         *        Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig);

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the time-series forecasting problem type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesForecastingJobConfig.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesForecastingJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesForecastingJobConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig)}.
         * 
         * @param timeSeriesForecastingJobConfig
         *        a consumer that will call methods on {@link TimeSeriesForecastingJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig)
         */
        default Builder timeSeriesForecastingJobConfig(
                Consumer<TimeSeriesForecastingJobConfig.Builder> timeSeriesForecastingJobConfig) {
            return timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig.builder()
                    .applyMutation(timeSeriesForecastingJobConfig).build());
        }

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
         * </p>
         * 
         * @param tabularJobConfig
         *        Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tabularJobConfig(TabularJobConfig tabularJobConfig);

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the tabular problem type (regression, classification).
         * </p>
         * This is a convenience method that creates an instance of the {@link TabularJobConfig.Builder} avoiding the
         * need to create one manually via {@link TabularJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TabularJobConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #tabularJobConfig(TabularJobConfig)}.
         * 
         * @param tabularJobConfig
         *        a consumer that will call methods on {@link TabularJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tabularJobConfig(TabularJobConfig)
         */
        default Builder tabularJobConfig(Consumer<TabularJobConfig.Builder> tabularJobConfig) {
            return tabularJobConfig(TabularJobConfig.builder().applyMutation(tabularJobConfig).build());
        }

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.
         * </p>
         * <note>
         * <p>
         * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in
         * regions supported by Canvas. Refer to the documentation of Canvas for the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
         * </p>
         * </note>
         * 
         * @param textGenerationJobConfig
         *        Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem
         *        type.</p> <note>
         *        <p>
         *        The text generation models that support fine-tuning in Autopilot are currently accessible exclusively
         *        in regions supported by Canvas. Refer to the documentation of Canvas for the <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported
         *        Regions</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textGenerationJobConfig(TextGenerationJobConfig textGenerationJobConfig);

        /**
         * <p>
         * Settings used to configure an AutoML job V2 for the text generation (LLMs fine-tuning) problem type.
         * </p>
         * <note>
         * <p>
         * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in
         * regions supported by Canvas. Refer to the documentation of Canvas for the <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link TextGenerationJobConfig.Builder}
         * avoiding the need to create one manually via {@link TextGenerationJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextGenerationJobConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #textGenerationJobConfig(TextGenerationJobConfig)}.
         * 
         * @param textGenerationJobConfig
         *        a consumer that will call methods on {@link TextGenerationJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textGenerationJobConfig(TextGenerationJobConfig)
         */
        default Builder textGenerationJobConfig(Consumer<TextGenerationJobConfig.Builder> textGenerationJobConfig) {
            return textGenerationJobConfig(TextGenerationJobConfig.builder().applyMutation(textGenerationJobConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageClassificationJobConfig imageClassificationJobConfig;

        private TextClassificationJobConfig textClassificationJobConfig;

        private TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig;

        private TabularJobConfig tabularJobConfig;

        private TextGenerationJobConfig textGenerationJobConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLProblemTypeConfig model) {
            imageClassificationJobConfig(model.imageClassificationJobConfig);
            textClassificationJobConfig(model.textClassificationJobConfig);
            timeSeriesForecastingJobConfig(model.timeSeriesForecastingJobConfig);
            tabularJobConfig(model.tabularJobConfig);
            textGenerationJobConfig(model.textGenerationJobConfig);
        }

        public final ImageClassificationJobConfig.Builder getImageClassificationJobConfig() {
            return imageClassificationJobConfig != null ? imageClassificationJobConfig.toBuilder() : null;
        }

        public final void setImageClassificationJobConfig(ImageClassificationJobConfig.BuilderImpl imageClassificationJobConfig) {
            Object oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig != null ? imageClassificationJobConfig.build()
                    : null;
            handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
        }

        @Override
        public final Builder imageClassificationJobConfig(ImageClassificationJobConfig imageClassificationJobConfig) {
            Object oldValue = this.imageClassificationJobConfig;
            this.imageClassificationJobConfig = imageClassificationJobConfig;
            handleUnionValueChange(Type.IMAGE_CLASSIFICATION_JOB_CONFIG, oldValue, this.imageClassificationJobConfig);
            return this;
        }

        public final TextClassificationJobConfig.Builder getTextClassificationJobConfig() {
            return textClassificationJobConfig != null ? textClassificationJobConfig.toBuilder() : null;
        }

        public final void setTextClassificationJobConfig(TextClassificationJobConfig.BuilderImpl textClassificationJobConfig) {
            Object oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig != null ? textClassificationJobConfig.build() : null;
            handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
        }

        @Override
        public final Builder textClassificationJobConfig(TextClassificationJobConfig textClassificationJobConfig) {
            Object oldValue = this.textClassificationJobConfig;
            this.textClassificationJobConfig = textClassificationJobConfig;
            handleUnionValueChange(Type.TEXT_CLASSIFICATION_JOB_CONFIG, oldValue, this.textClassificationJobConfig);
            return this;
        }

        public final TimeSeriesForecastingJobConfig.Builder getTimeSeriesForecastingJobConfig() {
            return timeSeriesForecastingJobConfig != null ? timeSeriesForecastingJobConfig.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingJobConfig(
                TimeSeriesForecastingJobConfig.BuilderImpl timeSeriesForecastingJobConfig) {
            Object oldValue = this.timeSeriesForecastingJobConfig;
            this.timeSeriesForecastingJobConfig = timeSeriesForecastingJobConfig != null ? timeSeriesForecastingJobConfig.build()
                    : null;
            handleUnionValueChange(Type.TIME_SERIES_FORECASTING_JOB_CONFIG, oldValue, this.timeSeriesForecastingJobConfig);
        }

        @Override
        public final Builder timeSeriesForecastingJobConfig(TimeSeriesForecastingJobConfig timeSeriesForecastingJobConfig) {
            Object oldValue = this.timeSeriesForecastingJobConfig;
            this.timeSeriesForecastingJobConfig = timeSeriesForecastingJobConfig;
            handleUnionValueChange(Type.TIME_SERIES_FORECASTING_JOB_CONFIG, oldValue, this.timeSeriesForecastingJobConfig);
            return this;
        }

        public final TabularJobConfig.Builder getTabularJobConfig() {
            return tabularJobConfig != null ? tabularJobConfig.toBuilder() : null;
        }

        public final void setTabularJobConfig(TabularJobConfig.BuilderImpl tabularJobConfig) {
            Object oldValue = this.tabularJobConfig;
            this.tabularJobConfig = tabularJobConfig != null ? tabularJobConfig.build() : null;
            handleUnionValueChange(Type.TABULAR_JOB_CONFIG, oldValue, this.tabularJobConfig);
        }

        @Override
        public final Builder tabularJobConfig(TabularJobConfig tabularJobConfig) {
            Object oldValue = this.tabularJobConfig;
            this.tabularJobConfig = tabularJobConfig;
            handleUnionValueChange(Type.TABULAR_JOB_CONFIG, oldValue, this.tabularJobConfig);
            return this;
        }

        public final TextGenerationJobConfig.Builder getTextGenerationJobConfig() {
            return textGenerationJobConfig != null ? textGenerationJobConfig.toBuilder() : null;
        }

        public final void setTextGenerationJobConfig(TextGenerationJobConfig.BuilderImpl textGenerationJobConfig) {
            Object oldValue = this.textGenerationJobConfig;
            this.textGenerationJobConfig = textGenerationJobConfig != null ? textGenerationJobConfig.build() : null;
            handleUnionValueChange(Type.TEXT_GENERATION_JOB_CONFIG, oldValue, this.textGenerationJobConfig);
        }

        @Override
        public final Builder textGenerationJobConfig(TextGenerationJobConfig textGenerationJobConfig) {
            Object oldValue = this.textGenerationJobConfig;
            this.textGenerationJobConfig = textGenerationJobConfig;
            handleUnionValueChange(Type.TEXT_GENERATION_JOB_CONFIG, oldValue, this.textGenerationJobConfig);
            return this;
        }

        @Override
        public AutoMLProblemTypeConfig build() {
            return new AutoMLProblemTypeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutoMLProblemTypeConfig#type()
     */
    public enum Type {
        IMAGE_CLASSIFICATION_JOB_CONFIG,

        TEXT_CLASSIFICATION_JOB_CONFIG,

        TIME_SERIES_FORECASTING_JOB_CONFIG,

        TABULAR_JOB_CONFIG,

        TEXT_GENERATION_JOB_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
