/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteClusterNodesResponse extends SageMakerResponse implements
        ToCopyableBuilder<BatchDeleteClusterNodesResponse.Builder, BatchDeleteClusterNodesResponse> {
    private static final SdkField<List<BatchDeleteClusterNodesError>> FAILED_FIELD = SdkField
            .<List<BatchDeleteClusterNodesError>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(BatchDeleteClusterNodesResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteClusterNodesError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteClusterNodesError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(BatchDeleteClusterNodesResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_FIELD, SUCCESSFUL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchDeleteClusterNodesError> failed;

    private final List<String> successful;

    private BatchDeleteClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors encountered when deleting the specified nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return A list of errors encountered when deleting the specified nodes.
     */
    public final List<BatchDeleteClusterNodesError> failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node IDs that were successfully deleted from the specified cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return A list of node IDs that were successfully deleted from the specified cluster.
     */
    public final List<String> successful() {
        return successful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodesResponse)) {
            return false;
        }
        BatchDeleteClusterNodesResponse other = (BatchDeleteClusterNodesResponse) obj;
        return hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed())
                && hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteClusterNodesResponse").add("Failed", hasFailed() ? failed() : null)
                .add("Successful", hasSuccessful() ? successful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Failed", FAILED_FIELD);
        map.put("Successful", SUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodesResponse, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteClusterNodesResponse> {
        /**
         * <p>
         * A list of errors encountered when deleting the specified nodes.
         * </p>
         * 
         * @param failed
         *        A list of errors encountered when deleting the specified nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchDeleteClusterNodesError> failed);

        /**
         * <p>
         * A list of errors encountered when deleting the specified nodes.
         * </p>
         * 
         * @param failed
         *        A list of errors encountered when deleting the specified nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchDeleteClusterNodesError... failed);

        /**
         * <p>
         * A list of errors encountered when deleting the specified nodes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesError.Builder#build()} is
         * called immediately and its result is passed to {@link #failed(List<BatchDeleteClusterNodesError>)}.
         * 
         * @param failed
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(java.util.Collection<BatchDeleteClusterNodesError>)
         */
        Builder failed(Consumer<BatchDeleteClusterNodesError.Builder>... failed);

        /**
         * <p>
         * A list of node IDs that were successfully deleted from the specified cluster.
         * </p>
         * 
         * @param successful
         *        A list of node IDs that were successfully deleted from the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<String> successful);

        /**
         * <p>
         * A list of node IDs that were successfully deleted from the specified cluster.
         * </p>
         * 
         * @param successful
         *        A list of node IDs that were successfully deleted from the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(String... successful);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<BatchDeleteClusterNodesError> failed = DefaultSdkAutoConstructList.getInstance();

        private List<String> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodesResponse model) {
            super(model);
            failed(model.failed);
            successful(model.successful);
        }

        public final List<BatchDeleteClusterNodesError.Builder> getFailed() {
            List<BatchDeleteClusterNodesError.Builder> result = BatchDeleteClusterNodesErrorListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchDeleteClusterNodesError.BuilderImpl> failed) {
            this.failed = BatchDeleteClusterNodesErrorListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchDeleteClusterNodesError> failed) {
            this.failed = BatchDeleteClusterNodesErrorListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchDeleteClusterNodesError... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchDeleteClusterNodesError.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchDeleteClusterNodesError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSuccessful() {
            if (successful instanceof SdkAutoConstructList) {
                return null;
            }
            return successful;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        public BatchDeleteClusterNodesResponse build() {
            return new BatchDeleteClusterNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
