/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input object for the batch transform job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchTransformInput implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchTransformInput.Builder, BatchTransformInput> {
    private static final SdkField<String> DATA_CAPTURED_DESTINATION_S3_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataCapturedDestinationS3Uri")
            .getter(getter(BatchTransformInput::dataCapturedDestinationS3Uri))
            .setter(setter(Builder::dataCapturedDestinationS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCapturedDestinationS3Uri")
                    .build()).build();

    private static final SdkField<MonitoringDatasetFormat> DATASET_FORMAT_FIELD = SdkField
            .<MonitoringDatasetFormat> builder(MarshallingType.SDK_POJO).memberName("DatasetFormat")
            .getter(getter(BatchTransformInput::datasetFormat)).setter(setter(Builder::datasetFormat))
            .constructor(MonitoringDatasetFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetFormat").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(BatchTransformInput::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3InputMode").getter(getter(BatchTransformInput::s3InputModeAsString))
            .setter(setter(Builder::s3InputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()).build();

    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3DataDistributionType").getter(getter(BatchTransformInput::s3DataDistributionTypeAsString))
            .setter(setter(Builder::s3DataDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build())
            .build();

    private static final SdkField<String> FEATURES_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeaturesAttribute").getter(getter(BatchTransformInput::featuresAttribute))
            .setter(setter(Builder::featuresAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturesAttribute").build()).build();

    private static final SdkField<String> INFERENCE_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceAttribute").getter(getter(BatchTransformInput::inferenceAttribute))
            .setter(setter(Builder::inferenceAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAttribute").build())
            .build();

    private static final SdkField<String> PROBABILITY_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProbabilityAttribute").getter(getter(BatchTransformInput::probabilityAttribute))
            .setter(setter(Builder::probabilityAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityAttribute").build())
            .build();

    private static final SdkField<Double> PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("ProbabilityThresholdAttribute")
            .getter(getter(BatchTransformInput::probabilityThresholdAttribute))
            .setter(setter(Builder::probabilityThresholdAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityThresholdAttribute")
                    .build()).build();

    private static final SdkField<String> START_TIME_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimeOffset").getter(getter(BatchTransformInput::startTimeOffset))
            .setter(setter(Builder::startTimeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeOffset").build()).build();

    private static final SdkField<String> END_TIME_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimeOffset").getter(getter(BatchTransformInput::endTimeOffset))
            .setter(setter(Builder::endTimeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimeOffset").build()).build();

    private static final SdkField<String> EXCLUDE_FEATURES_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExcludeFeaturesAttribute").getter(getter(BatchTransformInput::excludeFeaturesAttribute))
            .setter(setter(Builder::excludeFeaturesAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeFeaturesAttribute").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_CAPTURED_DESTINATION_S3_URI_FIELD, DATASET_FORMAT_FIELD, LOCAL_PATH_FIELD, S3_INPUT_MODE_FIELD,
            S3_DATA_DISTRIBUTION_TYPE_FIELD, FEATURES_ATTRIBUTE_FIELD, INFERENCE_ATTRIBUTE_FIELD, PROBABILITY_ATTRIBUTE_FIELD,
            PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD, START_TIME_OFFSET_FIELD, END_TIME_OFFSET_FIELD,
            EXCLUDE_FEATURES_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataCapturedDestinationS3Uri;

    private final MonitoringDatasetFormat datasetFormat;

    private final String localPath;

    private final String s3InputMode;

    private final String s3DataDistributionType;

    private final String featuresAttribute;

    private final String inferenceAttribute;

    private final String probabilityAttribute;

    private final Double probabilityThresholdAttribute;

    private final String startTimeOffset;

    private final String endTimeOffset;

    private final String excludeFeaturesAttribute;

    private BatchTransformInput(BuilderImpl builder) {
        this.dataCapturedDestinationS3Uri = builder.dataCapturedDestinationS3Uri;
        this.datasetFormat = builder.datasetFormat;
        this.localPath = builder.localPath;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
        this.featuresAttribute = builder.featuresAttribute;
        this.inferenceAttribute = builder.inferenceAttribute;
        this.probabilityAttribute = builder.probabilityAttribute;
        this.probabilityThresholdAttribute = builder.probabilityThresholdAttribute;
        this.startTimeOffset = builder.startTimeOffset;
        this.endTimeOffset = builder.endTimeOffset;
        this.excludeFeaturesAttribute = builder.excludeFeaturesAttribute;
    }

    /**
     * <p>
     * The Amazon S3 location being used to capture the data.
     * </p>
     * 
     * @return The Amazon S3 location being used to capture the data.
     */
    public final String dataCapturedDestinationS3Uri() {
        return dataCapturedDestinationS3Uri;
    }

    /**
     * <p>
     * The dataset format for your batch transform job.
     * </p>
     * 
     * @return The dataset format for your batch transform job.
     */
    public final MonitoringDatasetFormat datasetFormat() {
        return datasetFormat;
    }

    /**
     * <p>
     * Path to the filesystem where the batch transform data is available to the container.
     * </p>
     * 
     * @return Path to the filesystem where the batch transform data is available to the container.
     */
    public final String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the
     * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for
     * small files that fit in memory. Defaults to <code>File</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for
     *         the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is
     *         useful for small files that fit in memory. Defaults to <code>File</code>.
     * @see ProcessingS3InputMode
     */
    public final ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(s3InputMode);
    }

    /**
     * <p>
     * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the
     * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for
     * small files that fit in memory. Defaults to <code>File</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for
     *         the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is
     *         useful for small files that fit in memory. Defaults to <code>File</code>.
     * @see ProcessingS3InputMode
     */
    public final String s3InputModeAsString() {
        return s3InputMode;
    }

    /**
     * <p>
     * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
     * <code>FullyReplicated</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
     *         <code>FullyReplicated</code>
     * @see ProcessingS3DataDistributionType
     */
    public final ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(s3DataDistributionType);
    }

    /**
     * <p>
     * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
     * <code>FullyReplicated</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
     *         <code>FullyReplicated</code>
     * @see ProcessingS3DataDistributionType
     */
    public final String s3DataDistributionTypeAsString() {
        return s3DataDistributionType;
    }

    /**
     * <p>
     * The attributes of the input data that are the input features.
     * </p>
     * 
     * @return The attributes of the input data that are the input features.
     */
    public final String featuresAttribute() {
        return featuresAttribute;
    }

    /**
     * <p>
     * The attribute of the input data that represents the ground truth label.
     * </p>
     * 
     * @return The attribute of the input data that represents the ground truth label.
     */
    public final String inferenceAttribute() {
        return inferenceAttribute;
    }

    /**
     * <p>
     * In a classification problem, the attribute that represents the class probability.
     * </p>
     * 
     * @return In a classification problem, the attribute that represents the class probability.
     */
    public final String probabilityAttribute() {
        return probabilityAttribute;
    }

    /**
     * <p>
     * The threshold for the class probability to be evaluated as a positive result.
     * </p>
     * 
     * @return The threshold for the class probability to be evaluated as a positive result.
     */
    public final Double probabilityThresholdAttribute() {
        return probabilityThresholdAttribute;
    }

    /**
     * <p>
     * If specified, monitoring jobs substract this time from the start time. For information about using offsets for
     * scheduling monitoring jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
     * Quality Monitoring Jobs</a>.
     * </p>
     * 
     * @return If specified, monitoring jobs substract this time from the start time. For information about using
     *         offsets for scheduling monitoring jobs, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule
     *         Model Quality Monitoring Jobs</a>.
     */
    public final String startTimeOffset() {
        return startTimeOffset;
    }

    /**
     * <p>
     * If specified, monitoring jobs subtract this time from the end time. For information about using offsets for
     * scheduling monitoring jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
     * Quality Monitoring Jobs</a>.
     * </p>
     * 
     * @return If specified, monitoring jobs subtract this time from the end time. For information about using offsets
     *         for scheduling monitoring jobs, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule
     *         Model Quality Monitoring Jobs</a>.
     */
    public final String endTimeOffset() {
        return endTimeOffset;
    }

    /**
     * <p>
     * The attributes of the input data to exclude from the analysis.
     * </p>
     * 
     * @return The attributes of the input data to exclude from the analysis.
     */
    public final String excludeFeaturesAttribute() {
        return excludeFeaturesAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataCapturedDestinationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(datasetFormat());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(featuresAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(probabilityAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(probabilityThresholdAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(excludeFeaturesAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchTransformInput)) {
            return false;
        }
        BatchTransformInput other = (BatchTransformInput) obj;
        return Objects.equals(dataCapturedDestinationS3Uri(), other.dataCapturedDestinationS3Uri())
                && Objects.equals(datasetFormat(), other.datasetFormat()) && Objects.equals(localPath(), other.localPath())
                && Objects.equals(s3InputModeAsString(), other.s3InputModeAsString())
                && Objects.equals(s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString())
                && Objects.equals(featuresAttribute(), other.featuresAttribute())
                && Objects.equals(inferenceAttribute(), other.inferenceAttribute())
                && Objects.equals(probabilityAttribute(), other.probabilityAttribute())
                && Objects.equals(probabilityThresholdAttribute(), other.probabilityThresholdAttribute())
                && Objects.equals(startTimeOffset(), other.startTimeOffset())
                && Objects.equals(endTimeOffset(), other.endTimeOffset())
                && Objects.equals(excludeFeaturesAttribute(), other.excludeFeaturesAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchTransformInput").add("DataCapturedDestinationS3Uri", dataCapturedDestinationS3Uri())
                .add("DatasetFormat", datasetFormat()).add("LocalPath", localPath()).add("S3InputMode", s3InputModeAsString())
                .add("S3DataDistributionType", s3DataDistributionTypeAsString()).add("FeaturesAttribute", featuresAttribute())
                .add("InferenceAttribute", inferenceAttribute()).add("ProbabilityAttribute", probabilityAttribute())
                .add("ProbabilityThresholdAttribute", probabilityThresholdAttribute()).add("StartTimeOffset", startTimeOffset())
                .add("EndTimeOffset", endTimeOffset()).add("ExcludeFeaturesAttribute", excludeFeaturesAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataCapturedDestinationS3Uri":
            return Optional.ofNullable(clazz.cast(dataCapturedDestinationS3Uri()));
        case "DatasetFormat":
            return Optional.ofNullable(clazz.cast(datasetFormat()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3InputMode":
            return Optional.ofNullable(clazz.cast(s3InputModeAsString()));
        case "S3DataDistributionType":
            return Optional.ofNullable(clazz.cast(s3DataDistributionTypeAsString()));
        case "FeaturesAttribute":
            return Optional.ofNullable(clazz.cast(featuresAttribute()));
        case "InferenceAttribute":
            return Optional.ofNullable(clazz.cast(inferenceAttribute()));
        case "ProbabilityAttribute":
            return Optional.ofNullable(clazz.cast(probabilityAttribute()));
        case "ProbabilityThresholdAttribute":
            return Optional.ofNullable(clazz.cast(probabilityThresholdAttribute()));
        case "StartTimeOffset":
            return Optional.ofNullable(clazz.cast(startTimeOffset()));
        case "EndTimeOffset":
            return Optional.ofNullable(clazz.cast(endTimeOffset()));
        case "ExcludeFeaturesAttribute":
            return Optional.ofNullable(clazz.cast(excludeFeaturesAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataCapturedDestinationS3Uri", DATA_CAPTURED_DESTINATION_S3_URI_FIELD);
        map.put("DatasetFormat", DATASET_FORMAT_FIELD);
        map.put("LocalPath", LOCAL_PATH_FIELD);
        map.put("S3InputMode", S3_INPUT_MODE_FIELD);
        map.put("S3DataDistributionType", S3_DATA_DISTRIBUTION_TYPE_FIELD);
        map.put("FeaturesAttribute", FEATURES_ATTRIBUTE_FIELD);
        map.put("InferenceAttribute", INFERENCE_ATTRIBUTE_FIELD);
        map.put("ProbabilityAttribute", PROBABILITY_ATTRIBUTE_FIELD);
        map.put("ProbabilityThresholdAttribute", PROBABILITY_THRESHOLD_ATTRIBUTE_FIELD);
        map.put("StartTimeOffset", START_TIME_OFFSET_FIELD);
        map.put("EndTimeOffset", END_TIME_OFFSET_FIELD);
        map.put("ExcludeFeaturesAttribute", EXCLUDE_FEATURES_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchTransformInput, T> g) {
        return obj -> g.apply((BatchTransformInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchTransformInput> {
        /**
         * <p>
         * The Amazon S3 location being used to capture the data.
         * </p>
         * 
         * @param dataCapturedDestinationS3Uri
         *        The Amazon S3 location being used to capture the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri);

        /**
         * <p>
         * The dataset format for your batch transform job.
         * </p>
         * 
         * @param datasetFormat
         *        The dataset format for your batch transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetFormat(MonitoringDatasetFormat datasetFormat);

        /**
         * <p>
         * The dataset format for your batch transform job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringDatasetFormat.Builder} avoiding
         * the need to create one manually via {@link MonitoringDatasetFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringDatasetFormat.Builder#build()} is called immediately
         * and its result is passed to {@link #datasetFormat(MonitoringDatasetFormat)}.
         * 
         * @param datasetFormat
         *        a consumer that will call methods on {@link MonitoringDatasetFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetFormat(MonitoringDatasetFormat)
         */
        default Builder datasetFormat(Consumer<MonitoringDatasetFormat.Builder> datasetFormat) {
            return datasetFormat(MonitoringDatasetFormat.builder().applyMutation(datasetFormat).build());
        }

        /**
         * <p>
         * Path to the filesystem where the batch transform data is available to the container.
         * </p>
         * 
         * @param localPath
         *        Path to the filesystem where the batch transform data is available to the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the
         * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful
         * for small files that fit in memory. Defaults to <code>File</code>.
         * </p>
         * 
         * @param s3InputMode
         *        Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for
         *        the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode
         *        is useful for small files that fit in memory. Defaults to <code>File</code>.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(String s3InputMode);

        /**
         * <p>
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the
         * monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful
         * for small files that fit in memory. Defaults to <code>File</code>.
         * </p>
         * 
         * @param s3InputMode
         *        Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for
         *        the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode
         *        is useful for small files that fit in memory. Defaults to <code>File</code>.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(ProcessingS3InputMode s3InputMode);

        /**
         * <p>
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
         * <code>FullyReplicated</code>
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
         *        <code>FullyReplicated</code>
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(String s3DataDistributionType);

        /**
         * <p>
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
         * <code>FullyReplicated</code>
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to
         *        <code>FullyReplicated</code>
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType);

        /**
         * <p>
         * The attributes of the input data that are the input features.
         * </p>
         * 
         * @param featuresAttribute
         *        The attributes of the input data that are the input features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresAttribute(String featuresAttribute);

        /**
         * <p>
         * The attribute of the input data that represents the ground truth label.
         * </p>
         * 
         * @param inferenceAttribute
         *        The attribute of the input data that represents the ground truth label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAttribute(String inferenceAttribute);

        /**
         * <p>
         * In a classification problem, the attribute that represents the class probability.
         * </p>
         * 
         * @param probabilityAttribute
         *        In a classification problem, the attribute that represents the class probability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder probabilityAttribute(String probabilityAttribute);

        /**
         * <p>
         * The threshold for the class probability to be evaluated as a positive result.
         * </p>
         * 
         * @param probabilityThresholdAttribute
         *        The threshold for the class probability to be evaluated as a positive result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder probabilityThresholdAttribute(Double probabilityThresholdAttribute);

        /**
         * <p>
         * If specified, monitoring jobs substract this time from the start time. For information about using offsets
         * for scheduling monitoring jobs, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule
         * Model Quality Monitoring Jobs</a>.
         * </p>
         * 
         * @param startTimeOffset
         *        If specified, monitoring jobs substract this time from the start time. For information about using
         *        offsets for scheduling monitoring jobs, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html"
         *        >Schedule Model Quality Monitoring Jobs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeOffset(String startTimeOffset);

        /**
         * <p>
         * If specified, monitoring jobs subtract this time from the end time. For information about using offsets for
         * scheduling monitoring jobs, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule
         * Model Quality Monitoring Jobs</a>.
         * </p>
         * 
         * @param endTimeOffset
         *        If specified, monitoring jobs subtract this time from the end time. For information about using
         *        offsets for scheduling monitoring jobs, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html"
         *        >Schedule Model Quality Monitoring Jobs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeOffset(String endTimeOffset);

        /**
         * <p>
         * The attributes of the input data to exclude from the analysis.
         * </p>
         * 
         * @param excludeFeaturesAttribute
         *        The attributes of the input data to exclude from the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFeaturesAttribute(String excludeFeaturesAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String dataCapturedDestinationS3Uri;

        private MonitoringDatasetFormat datasetFormat;

        private String localPath;

        private String s3InputMode;

        private String s3DataDistributionType;

        private String featuresAttribute;

        private String inferenceAttribute;

        private String probabilityAttribute;

        private Double probabilityThresholdAttribute;

        private String startTimeOffset;

        private String endTimeOffset;

        private String excludeFeaturesAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchTransformInput model) {
            dataCapturedDestinationS3Uri(model.dataCapturedDestinationS3Uri);
            datasetFormat(model.datasetFormat);
            localPath(model.localPath);
            s3InputMode(model.s3InputMode);
            s3DataDistributionType(model.s3DataDistributionType);
            featuresAttribute(model.featuresAttribute);
            inferenceAttribute(model.inferenceAttribute);
            probabilityAttribute(model.probabilityAttribute);
            probabilityThresholdAttribute(model.probabilityThresholdAttribute);
            startTimeOffset(model.startTimeOffset);
            endTimeOffset(model.endTimeOffset);
            excludeFeaturesAttribute(model.excludeFeaturesAttribute);
        }

        public final String getDataCapturedDestinationS3Uri() {
            return dataCapturedDestinationS3Uri;
        }

        public final void setDataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri) {
            this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
        }

        @Override
        public final Builder dataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri) {
            this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
            return this;
        }

        public final MonitoringDatasetFormat.Builder getDatasetFormat() {
            return datasetFormat != null ? datasetFormat.toBuilder() : null;
        }

        public final void setDatasetFormat(MonitoringDatasetFormat.BuilderImpl datasetFormat) {
            this.datasetFormat = datasetFormat != null ? datasetFormat.build() : null;
        }

        @Override
        public final Builder datasetFormat(MonitoringDatasetFormat datasetFormat) {
            this.datasetFormat = datasetFormat;
            return this;
        }

        public final String getLocalPath() {
            return localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getS3InputMode() {
            return s3InputMode;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final String getS3DataDistributionType() {
            return s3DataDistributionType;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final String getFeaturesAttribute() {
            return featuresAttribute;
        }

        public final void setFeaturesAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
        }

        @Override
        public final Builder featuresAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
            return this;
        }

        public final String getInferenceAttribute() {
            return inferenceAttribute;
        }

        public final void setInferenceAttribute(String inferenceAttribute) {
            this.inferenceAttribute = inferenceAttribute;
        }

        @Override
        public final Builder inferenceAttribute(String inferenceAttribute) {
            this.inferenceAttribute = inferenceAttribute;
            return this;
        }

        public final String getProbabilityAttribute() {
            return probabilityAttribute;
        }

        public final void setProbabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
        }

        @Override
        public final Builder probabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
            return this;
        }

        public final Double getProbabilityThresholdAttribute() {
            return probabilityThresholdAttribute;
        }

        public final void setProbabilityThresholdAttribute(Double probabilityThresholdAttribute) {
            this.probabilityThresholdAttribute = probabilityThresholdAttribute;
        }

        @Override
        public final Builder probabilityThresholdAttribute(Double probabilityThresholdAttribute) {
            this.probabilityThresholdAttribute = probabilityThresholdAttribute;
            return this;
        }

        public final String getStartTimeOffset() {
            return startTimeOffset;
        }

        public final void setStartTimeOffset(String startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(String startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final String getEndTimeOffset() {
            return endTimeOffset;
        }

        public final void setEndTimeOffset(String endTimeOffset) {
            this.endTimeOffset = endTimeOffset;
        }

        @Override
        public final Builder endTimeOffset(String endTimeOffset) {
            this.endTimeOffset = endTimeOffset;
            return this;
        }

        public final String getExcludeFeaturesAttribute() {
            return excludeFeaturesAttribute;
        }

        public final void setExcludeFeaturesAttribute(String excludeFeaturesAttribute) {
            this.excludeFeaturesAttribute = excludeFeaturesAttribute;
        }

        @Override
        public final Builder excludeFeaturesAttribute(String excludeFeaturesAttribute) {
            this.excludeFeaturesAttribute = excludeFeaturesAttribute;
            return this;
        }

        @Override
        public BatchTransformInput build() {
            return new BatchTransformInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
